/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.collections;

import com.mastfrog.util.collections.DoubleMap;
import com.mastfrog.util.collections.DoubleMapConsumer;
import com.mastfrog.util.collections.DoubleSet;
import com.mastfrog.util.collections.DoubleSetImpl;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.search.Bias;
import com.mastfrog.util.sort.Sort;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

final class DoubleMapImpl<T>
implements DoubleMap<T> {
    private final DoubleMapSet keySet;
    private Object[] values;

    DoubleMapImpl(int initialCapacity) {
        Checks.greaterThanZero((String)"initialCapacity", (int)initialCapacity);
        this.keySet = new DoubleMapSet(initialCapacity);
        this.values = new Object[initialCapacity];
    }

    @Override
    public DoubleSet keySet() {
        return this.keySet.unmodifiableView();
    }

    @Override
    public boolean remove(double key) {
        return this.keySet.remove(key);
    }

    @Override
    public int removeRange(double start, double end) {
        return this.keySet.removeRange(start, end);
    }

    @Override
    public void removeAll(double ... keys) {
        if (keys.length == 0) {
            return;
        }
        this.keySet.removeAll(keys);
    }

    @Override
    public void removeAll(DoubleSet set) {
        this.keySet.removeAll(set);
    }

    @Override
    public void put(double key, T value) {
        int pos = this.keySet.size;
        this.keySet.add(key);
        if (this.keySet.size > pos) {
            this.values[pos] = value;
        } else {
            this.values[this.keySet.indexOf((double)key)] = value;
        }
    }

    @Override
    public T get(double key) {
        int ix = this.keySet.indexOf(key);
        if (ix < 0) {
            return null;
        }
        return (T)this.values[ix];
    }

    @Override
    public T getOrDefault(double key, T defaultResult) {
        T result = this.get(key);
        return result == null ? defaultResult : result;
    }

    @Override
    public boolean containsKey(double key) {
        return this.keySet.contains(key);
    }

    @Override
    public int size() {
        return this.keySet.size();
    }

    public T[] valueArray(Class<T> type) {
        Object[] result = (Object[])Array.newInstance(type, this.size());
        System.arraycopy(this.values, 0, result, 0, this.size());
        return result;
    }

    @Override
    public List<T> values() {
        if (this.values.length == this.size()) {
            return Arrays.asList(this.values);
        }
        ArrayList<Object> result = new ArrayList<Object>(this.size());
        for (int i = 0; i < this.size(); ++i) {
            result.add(this.values[i]);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public T valueAt(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index out of range: " + index);
        }
        return (T)this.values[index];
    }

    @Override
    public void forEach(DoubleMapConsumer<? super T> c) {
        for (int i = 0; i < this.size(); ++i) {
            double key = this.keySet.getAsDouble(i);
            Object value = this.values[i];
            c.accept(i, key, value);
        }
    }

    @Override
    public boolean least(DoubleMapConsumer<? super T> c) {
        if (this.size() == 0) {
            return false;
        }
        double val = this.keySet.least();
        Object obj = this.values[0];
        c.accept(0, val, obj);
        return true;
    }

    @Override
    public boolean greatest(DoubleMapConsumer<? super T> c) {
        if (this.size() == 0) {
            return false;
        }
        int ix = this.size() - 1;
        double val = this.keySet.greatest();
        Object obj = this.values[ix];
        c.accept(ix, val, obj);
        return true;
    }

    @Override
    public boolean nearestValueTo(double approximate, double tolerance, DoubleMapConsumer<? super T> c) {
        BH bh = new BH();
        this.nearestValueTo(approximate, (ix, key, value) -> {
            if (Math.abs(key - approximate) < tolerance) {
                bh.set();
                c.accept(ix, key, value);
            }
        });
        return bh.get();
    }

    @Override
    public boolean nearestValueTo(double approximate, DoubleMapConsumer<? super T> c) {
        if (this.size() == 0) {
            return false;
        }
        if (this.size() == 1) {
            this.keySet.ensureClean();
            c.accept(0, this.keySet.data[0], this.values[0]);
            return true;
        }
        int ix = this.keySet.nearestIndexTo(approximate, Bias.NEAREST);
        if (ix < 0) {
            return false;
        }
        double value = this.keySet.data[ix];
        c.accept(ix, value, this.values[ix]);
        return true;
    }

    @Override
    public boolean nearestValueExclusive(double approximate, DoubleMapConsumer<? super T> c) {
        int size = this.keySet.size();
        if (size == 0) {
            return false;
        }
        if (size == 1) {
            this.keySet.ensureClean();
            double result = this.keySet.data[0];
            if (result == approximate) {
                return false;
            }
            c.accept(0, result, this.values[0]);
            return true;
        }
        int ix = this.keySet.nearestIndexTo(approximate, Bias.NEAREST);
        double result = this.keySet.data[ix];
        if (result == approximate) {
            double distNext;
            double nextVal;
            int prevIx = ix - 1;
            int nextIx = ix + 1;
            double prevVal = prevIx < 0 ? Double.MAX_VALUE - (Math.abs(approximate) + 1.0) : this.keySet.data[prevIx];
            double d = nextVal = nextIx >= size ? Double.MAX_VALUE - (Math.abs(approximate) + 1.0) : this.keySet.data[nextIx];
            if (prevIx < 0) {
                c.accept(nextIx, nextVal, this.values[nextIx]);
                return true;
            }
            if (nextIx >= size) {
                c.accept(prevIx, prevVal, this.values[prevIx]);
                return true;
            }
            double distPrev = Math.abs(approximate - prevVal);
            if (distPrev < (distNext = Math.abs(approximate - nextVal))) {
                c.accept(prevIx, prevVal, this.values[prevIx]);
                return true;
            }
            c.accept(nextIx, nextVal, this.values[nextIx]);
            return true;
        }
        c.accept(ix, result, this.values[ix]);
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256).append("{");
        for (int i = 0; i < this.size(); ++i) {
            double key = this.keySet.getAsDouble(i);
            T value = this.valueAt(i);
            sb.append(DoubleSetImpl.FMT.format(key)).append(':').append(value);
            if (i == this.size() - 1) continue;
            sb.append(", ");
        }
        return sb.append("}").toString();
    }

    @Override
    public boolean nearestValueExclusive(double approximate, double tolerance, DoubleMapConsumer<? super T> c) {
        BH bh = new BH();
        this.nearestValueExclusive(approximate, (ix, key, value) -> {
            if (Math.abs(approximate - key) <= tolerance) {
                bh.set();
                c.accept(ix, key, value);
            }
        });
        return bh.get();
    }

    @Override
    public int indexOf(double key) {
        return this.keySet.indexOf(key);
    }

    @Override
    public double key(int index) {
        return this.keySet.getAsDouble(index);
    }

    public int hashCode() {
        long hash = 5L;
        for (int i = 0; i < this.size(); ++i) {
            hash += 7L * Double.doubleToLongBits(this.key(i)) + (long)(51 * Objects.hashCode(this.values[i]));
        }
        return (int)(hash ^ hash << 32);
    }

    public boolean equals(Object o) {
        DoubleMap dm;
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof DoubleMap && (dm = (DoubleMap)o).size() == this.size()) {
            for (int i = 0; i < this.size(); ++i) {
                double od;
                double d = this.key(i);
                if (d != (od = dm.key(i))) {
                    return false;
                }
                Object obj = this.values[i];
                Object o1 = dm.valueAt(i);
                if (Objects.equals(obj, o1)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static /* synthetic */ Object[] access$002(DoubleMapImpl x0, Object[] x1) {
        x0.values = x1;
        return x1;
    }

    static final class BH {
        private boolean value;

        BH() {
        }

        void set() {
            this.value = true;
        }

        void clear() {
            this.value = false;
        }

        boolean get() {
            return this.value;
        }
    }

    final class DoubleMapSet
    extends DoubleSetImpl {
        DoubleMapSet(int initialCapacity) {
            super(initialCapacity);
        }

        @Override
        void moveItem(int srcIndex, int targetIndex, double v) {
            System.out.println("move " + srcIndex + " -> " + targetIndex);
            super.moveItem(srcIndex, targetIndex, v);
            ((DoubleMapImpl)DoubleMapImpl.this).values[targetIndex] = DoubleMapImpl.this.values[srcIndex];
        }

        @Override
        void shiftData(int srcIx, int destIx, int len) {
            super.shiftData(srcIx, destIx, len);
            System.arraycopy(DoubleMapImpl.this.values, srcIx, DoubleMapImpl.this.values, destIx, len);
        }

        @Override
        void grow(int newSize) {
            super.grow(newSize);
            DoubleMapImpl.access$002(DoubleMapImpl.this, Arrays.copyOf(DoubleMapImpl.this.values, newSize));
        }

        @Override
        void sort() {
            Sort.biSort(this.data, DoubleMapImpl.this.values, this.size);
        }
    }
}

