/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.collections;

import com.mastfrog.util.collections.DoubleSetImpl;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.search.Bias;
import java.util.Collection;
import java.util.PrimitiveIterator;
import java.util.function.DoubleConsumer;

public interface DoubleSet
extends Iterable<Double> {
    public static DoubleSet of(Collection<? extends Number> c) {
        Checks.notNull((String)"c", c);
        return DoubleSetImpl.of(c);
    }

    public static DoubleSet ofFloats(float ... floats) {
        Checks.notNull((String)"floats", (Object)floats);
        return DoubleSetImpl.ofFloats(floats);
    }

    public static DoubleSet ofDoubles(double ... doubles) {
        Checks.notNull((String)"doubles", (Object)doubles);
        return DoubleSetImpl.ofDoubles(doubles.length, doubles);
    }

    public static DoubleSet ofDoubles(int capacity, double ... doubles) {
        Checks.notNull((String)"doubles", (Object)doubles);
        Checks.nonNegative((String)"capacity", (int)capacity);
        return DoubleSetImpl.ofDoubles(capacity, doubles);
    }

    public static DoubleSet ofInts(int ... ints) {
        return DoubleSet.ofInts(ints.length, ints);
    }

    public static DoubleSet ofInts(int capacity, int[] ints) {
        Checks.notNull((String)"ints", (Object)ints);
        Checks.nonNegative((String)"capacity", (int)capacity);
        DoubleSetImpl impl = new DoubleSetImpl(capacity);
        for (int i = 0; i < ints.length; ++i) {
            impl.add(ints[i]);
        }
        return impl;
    }

    public static DoubleSet create() {
        return new DoubleSetImpl();
    }

    public static DoubleSet create(int capacity) {
        Checks.nonNegative((String)"capacity", (int)capacity);
        return new DoubleSetImpl(capacity);
    }

    public DoubleSet copy();

    public void add(double var1);

    public void addAll(DoubleSet var1);

    default public void addAll(double[] doubles) {
        this.addAll(DoubleSetImpl.ofDoubles(doubles));
    }

    default public void addAll(float[] floats) {
        for (int i = 0; i < floats.length; ++i) {
            this.add(floats[i]);
        }
    }

    public void clear();

    public boolean contains(double var1);

    public void forEachDouble(DoubleConsumer var1);

    public void forEachReversed(DoubleConsumer var1);

    public double getAsDouble(int var1);

    public double greatest();

    public int indexOf(double var1);

    public boolean isEmpty();

    public PrimitiveIterator.OfDouble iterator();

    public double least();

    public int nearestIndexTo(double var1, Bias var3);

    public double nearestValueTo(double var1, double var3);

    public double nearestValueExclusive(double var1);

    public double nearestValueExclusive(double var1, double var3);

    public double nearestValueTo(double var1);

    public DoubleSet[] partition(int var1);

    public double range();

    default public void removeAll(double ... doubles) {
        this.removeAll(DoubleSetImpl.ofDoubles(doubles));
    }

    public void removeAll(DoubleSet var1);

    public void retainAll(DoubleSet var1);

    public int size();

    public double[] toDoubleArray();

    public DoubleSet unmodifiableView();

    public DoubleSet toReadOnlyCopy();

    public int removeRange(double var1, double var3);

    public boolean remove(double var1);

    default public DoubleSet subset(double least, double greatest) {
        int first = this.nearestIndexTo(Math.min(least, greatest), Bias.FORWARD);
        int last = this.nearestIndexTo(Math.max(least, greatest), Bias.BACKWARD);
        DoubleSetImpl result = new DoubleSetImpl(last - first + 1);
        for (int i = first; i < last; ++i) {
            result.add(this.getAsDouble(i));
        }
        return result;
    }

    default public DoubleSet toSynchronizedSet() {
        return new DoubleSetImpl.SynchronizedDoubleSet(this);
    }
}

