/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.collections;

import com.mastfrog.util.collections.DoubleSet;
import com.mastfrog.util.search.Bias;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.PrimitiveIterator;
import java.util.function.DoubleConsumer;

class DoubleSetImpl
implements DoubleSet {
    static final DecimalFormat FMT = new DecimalFormat("#####################0.##################################");
    double[] data;
    private boolean clean;
    private final int initialCapacity;
    int size;

    public DoubleSetImpl() {
        this(128);
    }

    public DoubleSetImpl(int capacity) {
        this.data = new double[capacity];
        this.initialCapacity = capacity;
    }

    private DoubleSetImpl(double[] data) {
        this.data = data;
        this.initialCapacity = this.size = data.length;
        this.clean = true;
    }

    private DoubleSetImpl(double[] data, int size, boolean clean) {
        this.data = data;
        this.size = size;
        this.clean = clean;
        this.initialCapacity = data.length;
    }

    public static DoubleSetImpl of(Collection<? extends Number> c) {
        DoubleSetImpl set = new DoubleSetImpl(c.size());
        for (Number number : c) {
            if (number == null) {
                throw new IllegalArgumentException("Collection contains null: " + c);
            }
            set.add(number.doubleValue());
        }
        return set;
    }

    public static DoubleSetImpl ofFloats(float ... floats) {
        DoubleSetImpl result = new DoubleSetImpl(floats.length);
        for (int i = 0; i < floats.length; ++i) {
            result.add(floats[i]);
        }
        return result;
    }

    public static DoubleSetImpl ofDoubles(double ... doubles) {
        return DoubleSetImpl.ofDoubles(doubles.length, doubles);
    }

    public static DoubleSetImpl ofDoubles(int capacity, double ... doubles) {
        DoubleSetImpl result = new DoubleSetImpl(capacity);
        for (int i = 0; i < doubles.length; ++i) {
            result.add(doubles[i]);
        }
        return result;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.clean = true;
    }

    @Override
    public DoubleSetImpl copy() {
        double[] newData = Arrays.copyOf(this.data, this.data.length);
        return new DoubleSetImpl(newData, this.size, this.clean);
    }

    private DoubleSetImpl trimmedCopy() {
        double[] newData = Arrays.copyOf(this.data, this.size);
        return new DoubleSetImpl(newData, this.size, this.clean);
    }

    @Override
    public DoubleSet toReadOnlyCopy() {
        return new ReadOnlyDoubleSet(this.trimmedCopy());
    }

    @Override
    public DoubleSet unmodifiableView() {
        return new ReadOnlyDoubleSet(this);
    }

    @Override
    public boolean remove(double key) {
        int ix = this.indexOf(key);
        if (ix >= 0) {
            this.shiftData(ix + 1, ix, this.size - ix);
            --this.size;
            return true;
        }
        return false;
    }

    public String toString() {
        this.ensureClean();
        StringBuilder sb = new StringBuilder("{");
        for (int i = 0; i < this.size; ++i) {
            sb.append(FMT.format(this.data[i]));
            if (i == this.size - 1) continue;
            sb.append(", ");
        }
        return sb.append('}').toString();
    }

    public DoubleSetImpl[] partition(int maxPartitions) {
        this.ensureClean();
        if (maxPartitions < 0) {
            throw new IllegalArgumentException("Negative partitions " + maxPartitions);
        }
        if (maxPartitions == 0 || this.size < maxPartitions * 4) {
            return new DoubleSetImpl[]{this};
        }
        int itemsPer = this.size / maxPartitions;
        if (this.size - (itemsPer - 1) * this.size < 5) {
            --itemsPer;
        }
        if (itemsPer <= 1) {
            return new DoubleSetImpl[]{this};
        }
        int partitions = this.size / itemsPer;
        if (partitions * itemsPer < this.size) {
            ++partitions;
        }
        DoubleSetImpl[] result = new DoubleSetImpl[partitions];
        for (int i = 0; i < partitions; ++i) {
            int start = i * itemsPer;
            int length = i == partitions - 1 ? this.size - start : itemsPer;
            double[] copy = new double[length];
            System.arraycopy(this.data, start, copy, 0, length);
            result[i] = new DoubleSetImpl(copy);
        }
        return result;
    }

    void grow(int newSize) {
        this.data = Arrays.copyOf(this.data, newSize);
    }

    private void maybeGrow() {
        if (this.size == this.data.length - 1) {
            this.grow(this.data.length + (this.initialCapacity - this.initialCapacity / 3));
        }
    }

    void sort() {
        Arrays.sort(this.data, 0, this.size);
    }

    double[] rawData() {
        return this.data;
    }

    void onDedup(int index) {
    }

    private void clean() {
        if (this.size <= 1) {
            return;
        }
        this.sort();
        double last = this.data[0];
        int dedupFrom = -1;
        for (int i = 1; i < this.size; ++i) {
            double v = this.data[i];
            if (v == last) {
                dedupFrom = i;
                break;
            }
            last = v;
        }
        if (dedupFrom != -1) {
            if (dedupFrom == this.size - 1) {
                --this.size;
                return;
            }
            int removed = 1;
            for (int i = dedupFrom; i < this.size; ++i) {
                double v = this.data[i];
                if (v == last && i > dedupFrom) {
                    ++removed;
                } else {
                    this.moveItem(i, i - removed, v);
                }
                last = v;
            }
            this.size -= removed;
        }
    }

    void moveItem(int srcIndex, int targetIndex, double v) {
        this.data[targetIndex] = v;
    }

    @Override
    public double getAsDouble(int index) {
        this.ensureClean();
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("" + index);
        }
        return this.data[index];
    }

    @Override
    public void addAll(DoubleSet set) {
        if (set == this) {
            return;
        }
        int sz = set.size();
        if (sz == 0) {
            return;
        }
        if (this.size + sz > this.data.length) {
            this.data = Arrays.copyOf(this.data, this.size + sz);
        }
        this.clean &= this.greatest() < set.least();
        double[] otherData = set instanceof DoubleSetImpl ? ((DoubleSetImpl)set).data : set.toDoubleArray();
        System.arraycopy(otherData, 0, this.data, this.size, sz);
        this.size += sz;
    }

    @Override
    public int removeRange(double least, double greatest) {
        int stix = this.nearestIndexTo(Math.min(least, greatest), Bias.FORWARD);
        if (stix < 0) {
            return 0;
        }
        int enix = this.nearestIndexTo(Math.max(least, greatest), Bias.BACKWARD);
        if (enix < 0) {
            return 0;
        }
        if (enix < stix) {
            return 0;
        }
        int len = enix - stix;
        this.shiftData(enix, stix, this.size - enix);
        this.size -= len;
        return len;
    }

    void ensureClean() {
        if (!this.clean && this.size > 0) {
            this.clean();
            this.clean = true;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void add(double value) {
        if (value == Double.MIN_VALUE) {
            throw new IllegalArgumentException("Illegal value Double.MIN_VALUE (is used to indicate null results)");
        }
        this.maybeGrow();
        this.data[this.size++] = value;
        if (this.size > 1 && this.data[this.size - 1] >= value) {
            this.clean = false;
        }
    }

    @Override
    public int size() {
        this.ensureClean();
        return this.size;
    }

    @Override
    public double least() {
        if (this.size == 0) {
            return 0.0;
        }
        this.ensureClean();
        return this.data[0];
    }

    @Override
    public double greatest() {
        if (this.size == 0) {
            return 0.0;
        }
        this.ensureClean();
        return this.data[this.size - 1];
    }

    @Override
    public void forEachDouble(DoubleConsumer dc) {
        this.ensureClean();
        for (int i = 0; i < this.size; ++i) {
            dc.accept(this.data[i]);
        }
    }

    @Override
    public void forEachReversed(DoubleConsumer dc) {
        this.ensureClean();
        for (int i = this.size - 1; i >= 0; --i) {
            dc.accept(this.data[i]);
        }
    }

    @Override
    public void removeAll(DoubleSet remove) {
        this.ensureClean();
        remove.forEachReversed(val -> {
            int ix = this.indexOf(val);
            if (ix != -1) {
                this.shiftData(ix + 1, ix, this.size - (ix + 1));
                --this.size;
            }
        });
    }

    void shiftData(int srcIx, int destIx, int len) {
        System.arraycopy(this.data, srcIx, this.data, destIx, len);
    }

    @Override
    public double range() {
        return this.greatest() - this.least();
    }

    @Override
    public void retainAll(DoubleSet retain) {
        if (this.greatest() < retain.least() || this.least() > retain.greatest()) {
            this.clear();
            return;
        }
        this.ensureClean();
        boolean anyRetained = false;
        for (int i = this.size - 1; i >= 0; --i) {
            double v = this.data[i];
            if (!retain.contains(v)) {
                if (!anyRetained) {
                    this.size = i;
                    continue;
                }
                this.shiftData(i + 1, i, this.size - (i + 1));
                --this.size;
                continue;
            }
            anyRetained = true;
        }
    }

    @Override
    public PrimitiveIterator.OfDouble iterator() {
        return new It();
    }

    @Override
    public double[] toDoubleArray() {
        this.ensureClean();
        return Arrays.copyOf(this.data, this.size);
    }

    @Override
    public boolean contains(double d) {
        this.ensureClean();
        return Arrays.binarySearch(this.data, 0, this.size, d) >= 0;
    }

    @Override
    public int indexOf(double d) {
        this.ensureClean();
        int result = Arrays.binarySearch(this.data, 0, this.size, d);
        return result >= 0 ? result : -1;
    }

    public int hashCode() {
        this.ensureClean();
        long result = 5 * (this.size + 1);
        for (int i = 0; i < this.size; ++i) {
            result += 43L * Double.doubleToLongBits(this.data[i]);
        }
        return (int)(result | result << 32);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof DoubleSetImpl) {
            DoubleSetImpl ds = (DoubleSetImpl)o;
            this.ensureClean();
            if (ds.size != this.size) {
                return false;
            }
            if (ds.greatest() != this.greatest()) {
                return false;
            }
            this.ensureClean();
            ds.ensureClean();
            for (int i = 0; i < this.size; ++i) {
                if (this.data[i] == ds.data[i]) continue;
                return false;
            }
            return true;
        }
        if (o instanceof DoubleSet) {
            DoubleSet ds = (DoubleSet)o;
            this.ensureClean();
            if (this.size != ds.size()) {
                return false;
            }
            if (ds.greatest() != this.greatest()) {
                return false;
            }
            for (int i = 0; i < this.size; ++i) {
                if (this.data[i] == ds.getAsDouble(i)) continue;
                return false;
            }
        }
        return false;
    }

    @Override
    public double nearestValueTo(double val, double tolerance) {
        double result = this.nearestValueTo(val);
        if (Math.abs(val - result) > tolerance) {
            return Double.MIN_VALUE;
        }
        return result;
    }

    @Override
    public double nearestValueTo(double val) {
        if (this.size == 0) {
            return Double.MIN_VALUE;
        }
        if (this.size == 1) {
            return this.data[0];
        }
        int ix = this.nearestIndexTo(val, Bias.NEAREST);
        return this.data[ix];
    }

    @Override
    public double nearestValueExclusive(double val, double tolerance) {
        double result = this.nearestValueExclusive(val);
        if (Math.abs(val - result) <= tolerance) {
            return result;
        }
        return Double.MIN_VALUE;
    }

    @Override
    public double nearestValueExclusive(double val) {
        if (this.size == 0) {
            return Double.MIN_VALUE;
        }
        if (this.size == 1) {
            double result = this.data[0];
            if (result == val) {
                return Double.MIN_VALUE;
            }
            return result;
        }
        int ix = this.nearestIndexTo(val, Bias.NEAREST);
        double result = this.data[ix];
        if (result == val) {
            double distNext;
            double nextVal;
            int prevIx = ix - 1;
            int nextIx = ix + 1;
            double prevVal = prevIx < 0 ? Double.MAX_VALUE - (Math.abs(val) + 1.0) : this.data[prevIx];
            double d = nextVal = nextIx >= this.size ? Double.MAX_VALUE - (Math.abs(val) + 1.0) : this.data[nextIx];
            if (prevIx < 0) {
                return nextVal;
            }
            if (nextIx >= this.size) {
                return prevVal;
            }
            double distPrev = Math.abs(val - prevVal);
            if (distPrev < (distNext = Math.abs(val - nextVal))) {
                return prevVal;
            }
            return nextVal;
        }
        return result;
    }

    @Override
    public int nearestIndexTo(double value, Bias bias) {
        this.ensureClean();
        if (this.size == 0) {
            return -1;
        }
        if (this.size == 1) {
            double v = this.data[0];
            switch (bias) {
                case BACKWARD: {
                    return value >= v ? 0 : -1;
                }
                case FORWARD: {
                    return value <= v ? 0 : -1;
                }
                case NEAREST: {
                    return 0;
                }
                case NONE: {
                    return value == v ? 0 : -1;
                }
            }
            throw new AssertionError((Object)bias);
        }
        this.ensureClean();
        if (this.size == 0) {
            return -1;
        }
        if (this.size == 1) {
            double val = this.data[0];
            switch (bias) {
                case BACKWARD: {
                    if (val <= value) {
                        return 0;
                    }
                    return -1;
                }
                case FORWARD: 
                case NEAREST: {
                    if (val >= value) {
                        return 0;
                    }
                    return -1;
                }
            }
        }
        switch (bias) {
            case NONE: {
                int result;
                if (result >= 0) {
                    for (result = this.indexOf(value); result < this.size - 1 && this.data[result + 1] == this.data[result]; ++result) {
                    }
                }
                return result;
            }
            case BACKWARD: 
            case FORWARD: {
                int res2;
                if (res2 != -1) {
                    for (res2 = this.nearestIndexTo(0, this.size - 1, bias, value); res2 < this.size - 1 && this.data[res2 + 1] == this.data[res2]; ++res2) {
                    }
                }
                return res2;
            }
            case NEAREST: {
                double bwdDiff;
                int fwd = this.nearestIndexTo(0, this.size - 1, Bias.FORWARD, value);
                int bwd = this.nearestIndexTo(0, this.size - 1, Bias.BACKWARD, value);
                if (fwd == -1) {
                    return bwd;
                }
                if (bwd == -1) {
                    return fwd;
                }
                if (fwd == bwd) {
                    return fwd;
                }
                double fwdDiff = Math.abs(this.data[fwd] - value);
                if (fwdDiff == (bwdDiff = Math.abs(this.data[bwd] - value))) {
                    return fwd;
                }
                if (fwdDiff < bwdDiff) {
                    return fwd;
                }
                return bwd;
            }
        }
        throw new AssertionError((Object)bias);
    }

    private int nearestIndexTo(int start, int end, Bias bias, double value) {
        double startVal;
        if (start == end) {
            double currentVal = this.data[start];
            if (currentVal == value) {
                return start;
            }
            switch (bias) {
                case BACKWARD: {
                    if (currentVal <= value) {
                        return start;
                    }
                    return -1;
                }
                case FORWARD: {
                    if (currentVal >= value) {
                        return start;
                    }
                    return -1;
                }
            }
        }
        if ((startVal = this.data[start]) == value) {
            return start;
        }
        if (startVal > value) {
            switch (bias) {
                case BACKWARD: {
                    if (startVal > value) {
                        return -1;
                    }
                    return start - 1;
                }
                case FORWARD: {
                    return start;
                }
            }
            return -1;
        }
        double endVal = this.data[end];
        if (endVal == value) {
            return end;
        }
        if (endVal < value) {
            switch (bias) {
                case BACKWARD: {
                    return end;
                }
                case FORWARD: {
                    int result = end + 1;
                    return result < this.size ? result : -1;
                }
            }
            return -1;
        }
        int mid = start + (end - start) / 2;
        double midVal = this.data[mid];
        if (midVal == value) {
            return mid;
        }
        if (midVal < value && endVal > value) {
            int newStart = mid + 1;
            int newEnd = end - 1;
            double nextStartValue = this.data[newStart];
            if (nextStartValue > value && bias == Bias.BACKWARD && (newEnd - newStart <= 1 || midVal < value)) {
                return mid;
            }
            double nextEndValue = this.data[newEnd];
            if (nextEndValue < value && bias == Bias.FORWARD && newEnd - newStart <= 1) {
                return end;
            }
            return this.nearestIndexTo(newStart, newEnd, bias, value);
        }
        if (midVal > value && startVal < value) {
            int nextEnd = mid - 1;
            int nextStart = start + 1;
            double nextEndValue = this.data[nextEnd];
            if (nextEndValue < value && bias == Bias.FORWARD && nextEnd - nextStart <= 1) {
                return mid;
            }
            double newStartValue = this.data[nextStart];
            if (bias == Bias.BACKWARD && newStartValue > value && (startVal < value || nextEnd - nextStart <= 1)) {
                return start;
            }
            return this.nearestIndexTo(nextStart, nextEnd, bias, value);
        }
        return -1;
    }

    static class SynchronizedDoubleSet
    implements DoubleSet {
        private final DoubleSet delegate;

        public SynchronizedDoubleSet(DoubleSet delegate) {
            this.delegate = delegate;
        }

        @Override
        public synchronized DoubleSet copy() {
            return new SynchronizedDoubleSet(this.delegate.copy());
        }

        @Override
        public synchronized void add(double value) {
            this.delegate.add(value);
        }

        @Override
        public synchronized void addAll(DoubleSet set) {
            this.delegate.addAll(set);
        }

        @Override
        public synchronized void addAll(double[] doubles) {
            this.delegate.addAll(doubles);
        }

        @Override
        public synchronized void addAll(float[] floats) {
            this.delegate.addAll(floats);
        }

        @Override
        public synchronized void clear() {
            this.delegate.clear();
        }

        @Override
        public synchronized boolean contains(double d) {
            return this.delegate.contains(d);
        }

        @Override
        public synchronized void forEachDouble(DoubleConsumer dc) {
            this.delegate.forEachDouble(dc);
        }

        @Override
        public synchronized void forEachReversed(DoubleConsumer dc) {
            this.delegate.forEachReversed(dc);
        }

        @Override
        public synchronized double getAsDouble(int index) {
            return this.delegate.getAsDouble(index);
        }

        @Override
        public synchronized double greatest() {
            return this.delegate.greatest();
        }

        @Override
        public synchronized int indexOf(double d) {
            return this.delegate.indexOf(d);
        }

        @Override
        public synchronized boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public synchronized PrimitiveIterator.OfDouble iterator() {
            return new SyIt(this, this.delegate.iterator());
        }

        @Override
        public synchronized double least() {
            return this.delegate.least();
        }

        @Override
        public synchronized int nearestIndexTo(double approximateValue, Bias bias) {
            return this.delegate.nearestIndexTo(approximateValue, bias);
        }

        @Override
        public synchronized double nearestValueTo(double approximateValue, double tolerance) {
            return this.delegate.nearestValueTo(approximateValue, tolerance);
        }

        @Override
        public synchronized double nearestValueExclusive(double approximateValue) {
            return this.delegate.nearestValueExclusive(approximateValue);
        }

        @Override
        public synchronized double nearestValueExclusive(double approximateValue, double tolerance) {
            return this.delegate.nearestValueExclusive(approximateValue, tolerance);
        }

        @Override
        public synchronized double nearestValueTo(double approximateValue) {
            return this.delegate.nearestValueTo(approximateValue);
        }

        @Override
        public synchronized DoubleSet[] partition(int maxPartitions) {
            return this.delegate.partition(maxPartitions);
        }

        @Override
        public synchronized double range() {
            return this.delegate.range();
        }

        @Override
        public synchronized boolean remove(double val) {
            return this.delegate.remove(val);
        }

        @Override
        public synchronized void removeAll(double ... doubles) {
            this.delegate.removeAll(doubles);
        }

        @Override
        public synchronized void removeAll(DoubleSet remove) {
            this.delegate.removeAll(remove);
        }

        @Override
        public synchronized void retainAll(DoubleSet retain) {
            this.delegate.retainAll(retain);
        }

        @Override
        public synchronized int size() {
            return this.delegate.size();
        }

        @Override
        public synchronized double[] toDoubleArray() {
            return this.delegate.toDoubleArray();
        }

        @Override
        public synchronized DoubleSet unmodifiableView() {
            return new ReadOnlyDoubleSet(this);
        }

        @Override
        public synchronized DoubleSet toReadOnlyCopy() {
            return this.delegate.toReadOnlyCopy();
        }

        @Override
        public synchronized int removeRange(double least, double greatest) {
            return this.delegate.removeRange(least, greatest);
        }

        @Override
        public synchronized DoubleSet subset(double least, double greatest) {
            return this.delegate.subset(least, greatest);
        }

        public synchronized String toString() {
            return this.delegate.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            SynchronizedDoubleSet synchronizedDoubleSet = this;
            synchronized (synchronizedDoubleSet) {
                return this.delegate.equals(o);
            }
        }

        public synchronized int hashCode() {
            return this.delegate.hashCode();
        }

        @Override
        public DoubleSet toSynchronizedSet() {
            return this;
        }

        static class SyIt
        implements PrimitiveIterator.OfDouble {
            private final Object lock;
            private final PrimitiveIterator.OfDouble it;

            public SyIt(Object lock, PrimitiveIterator.OfDouble it) {
                this.lock = lock;
                this.it = it;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public double nextDouble() {
                Object object = this.lock;
                synchronized (object) {
                    return this.it.next();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                Object object = this.lock;
                synchronized (object) {
                    return this.it.hasNext();
                }
            }
        }
    }

    static final class ReadOnlyDoubleSet
    implements DoubleSet {
        private final DoubleSet delegate;

        public ReadOnlyDoubleSet(DoubleSet delegate) {
            this.delegate = delegate;
        }

        @Override
        public DoubleSet copy() {
            return this;
        }

        @Override
        public boolean contains(double d) {
            return this.delegate.contains(d);
        }

        @Override
        public void forEachDouble(DoubleConsumer dc) {
            this.delegate.forEachDouble(dc);
        }

        @Override
        public void forEachReversed(DoubleConsumer dc) {
            this.delegate.forEachReversed(dc);
        }

        @Override
        public double getAsDouble(int index) {
            return this.delegate.getAsDouble(index);
        }

        @Override
        public double greatest() {
            return this.delegate.greatest();
        }

        @Override
        public int indexOf(double d) {
            return this.delegate.indexOf(d);
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public PrimitiveIterator.OfDouble iterator() {
            return this.delegate.iterator();
        }

        @Override
        public double least() {
            return this.delegate.least();
        }

        @Override
        public int nearestIndexTo(double approximateValue, Bias bias) {
            return this.delegate.nearestIndexTo(approximateValue, bias);
        }

        @Override
        public double nearestValueTo(double approximateValue, double tolerance) {
            return this.delegate.nearestValueTo(approximateValue, tolerance);
        }

        @Override
        public double nearestValueExclusive(double approximateValue) {
            return this.delegate.nearestValueExclusive(approximateValue);
        }

        @Override
        public double nearestValueExclusive(double approximateValue, double tolerance) {
            return this.delegate.nearestValueExclusive(approximateValue, tolerance);
        }

        @Override
        public double nearestValueTo(double approximateValue) {
            return this.delegate.nearestValueTo(approximateValue);
        }

        @Override
        public DoubleSet[] partition(int maxPartitions) {
            DoubleSet[] origs = this.delegate.partition(maxPartitions);
            DoubleSet[] result = new DoubleSet[origs.length];
            for (int i = 0; i < origs.length; ++i) {
                result[i] = new ReadOnlyDoubleSet(origs[i]);
            }
            return result;
        }

        @Override
        public double range() {
            return this.delegate.range();
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public double[] toDoubleArray() {
            return this.delegate.toDoubleArray();
        }

        @Override
        public void removeAll(double ... doubles) {
            throw new UnsupportedOperationException("Read only set.");
        }

        @Override
        public int removeRange(double least, double greatest) {
            throw new UnsupportedOperationException("Read only set.");
        }

        @Override
        public void add(double value) {
            throw new UnsupportedOperationException("Read only set.");
        }

        @Override
        public boolean remove(double value) {
            throw new UnsupportedOperationException("Read only set.");
        }

        @Override
        public void addAll(DoubleSet set) {
            throw new UnsupportedOperationException("Read only set.");
        }

        @Override
        public void addAll(double[] doubles) {
            throw new UnsupportedOperationException("Read only set.");
        }

        @Override
        public void addAll(float[] floats) {
            throw new UnsupportedOperationException("Read only set.");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Read only set.");
        }

        @Override
        public void removeAll(DoubleSet remove) {
            throw new UnsupportedOperationException("Read only set.");
        }

        @Override
        public void retainAll(DoubleSet retain) {
            throw new UnsupportedOperationException("Read only set.");
        }

        @Override
        public DoubleSet unmodifiableView() {
            return this;
        }

        @Override
        public DoubleSet toReadOnlyCopy() {
            return new ReadOnlyDoubleSet(this.delegate.copy());
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    class It
    implements PrimitiveIterator.OfDouble {
        private int cursor = -1;

        It() {
        }

        @Override
        public double nextDouble() {
            return DoubleSetImpl.this.data[++this.cursor];
        }

        @Override
        public boolean hasNext() {
            return this.cursor + 1 < DoubleSetImpl.this.size;
        }
    }
}

