/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.collections;

import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.strings.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class HeteroMap
implements Iterable<Map.Entry<Key<?>, Object>> {
    private final Map<Key<?>, Object> map;

    public HeteroMap(Map<Key<?>, Object> internal) {
        Checks.notNull((String)"internal", internal);
        if (!internal.isEmpty()) {
            throw new IllegalArgumentException("This constructor is only for use to provide a synchronized or concurrent map.  The passed map may not already have contents.");
        }
        this.map = internal;
    }

    HeteroMap(boolean internal, Map<Key<?>, Object> map) {
        this.map = map;
    }

    public HeteroMap() {
        this(new HashMap());
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public String toString() {
        return '{' + Strings.join((char)',', this.map.entrySet()) + '}';
    }

    public Map<String, Object> toStringObjectMap() {
        ArrayList keys = new ArrayList(this.map.keySet());
        Collections.sort(keys, Comparator.comparing(a -> ((Key)a).name));
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Key key : keys) {
            result.put(key.name, this.get(key));
        }
        return result;
    }

    public HeteroMap copy() {
        HeteroMap result = new HeteroMap();
        result.map.putAll(this.map);
        return result;
    }

    public HeteroMap unmodifiableCopy() {
        HashMap newMap = new HashMap();
        newMap.putAll(this.map);
        return new HeteroMap(true, Collections.unmodifiableMap(newMap));
    }

    private <T> Key<T> findKey(Class<T> type, boolean create) {
        for (Map.Entry<Key<?>, Object> e : this.map.entrySet()) {
            Key<?> k = e.getKey();
            if (type != ((Key)k).type || !((Key)k).name.equals(type.getName())) continue;
            return k;
        }
        if (create) {
            return new Key<T>(type, type.getName());
        }
        return null;
    }

    public <T> T remove(Class<T> type) {
        Key<T> key = this.findKey(type, false);
        if (key != null) {
            return this.remove(key);
        }
        return null;
    }

    public <T> T remove(Key<T> key) {
        Object o = this.map.remove(key);
        return o == null ? null : (T)((Key)key).type.cast(o);
    }

    public <T> Set<T> getAllByType(Class<T> type) {
        HashSet<T> result = new HashSet<T>();
        for (Object o : this.map.values()) {
            if (!type.isInstance(o)) continue;
            result.add(type.cast(o));
        }
        return result;
    }

    public <T> T get(Class<T> type, T defaultValue) {
        Checks.notNull((String)"type", type);
        T result = this.get(type);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public <T> T get(Class<T> type) {
        Checks.notNull((String)"type", type);
        Key<T> key = this.findKey(type, false);
        return key == null ? null : (T)this.get(key);
    }

    public <T> Key<T> put(T value) {
        Checks.notNull((String)"value", value);
        Class<?> type = value.getClass();
        return this.put(type, value);
    }

    public <T> Key<T> put(Class<T> type, T value) {
        Checks.notNull((String)"type", type);
        Checks.notNull((String)"value", value);
        Key<T> key = this.findKey(type, true);
        this.put(key, value);
        return key;
    }

    public <T> T get(Key<T> key, T defaultValue) {
        Checks.notNull((String)"key", key);
        T result = this.get(key);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public <T> T get(Key<T> key) {
        Checks.notNull((String)"key", key);
        return ((Key)key).type.cast(this.map.get(key));
    }

    public <T> HeteroMap put(Key<T> key, T value) {
        Checks.notNull((String)"key", key);
        Checks.notNull((String)"value", value);
        this.map.put(key, ((Key)key).type.cast(value));
        return this;
    }

    public static final <T> Key<T> newKey(Class<T> type, String name) {
        Checks.notNull((String)"type", type);
        Checks.notNull((String)"name", (Object)name);
        return new Key<T>(type, name);
    }

    @Override
    public Iterator<Map.Entry<Key<?>, Object>> iterator() {
        return Collections.unmodifiableSet(this.map.entrySet()).iterator();
    }

    public static final class Key<T> {
        private final Class<T> type;
        private final String name;

        Key(Class<T> type, String name) {
            this.type = type;
            this.name = name;
        }

        public String toString() {
            return this.name + "(" + this.type.getName() + ")";
        }

        public int hashCode() {
            int hash = 5;
            hash = 29 * hash + Objects.hashCode(this.type);
            hash = 29 * hash + Objects.hashCode(this.name);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (!Objects.equals(this.name, other.name)) {
                return false;
            }
            return Objects.equals(this.type, other.type);
        }
    }
}

