/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.collections;

import com.mastfrog.util.collections.ConvertIterator;
import com.mastfrog.util.collections.Converter;
import com.mastfrog.util.strings.Strings;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

final class IdentityList<T>
implements List<T> {
    private final List<Identity<T>> l = new ArrayList<Identity<T>>();

    public IdentityList() {
    }

    private IdentityList(boolean ignored, List<Identity<T>> l) {
        this.l.addAll(l);
    }

    public IdentityList(Collection<? extends T> c) {
        for (T t : c) {
            this.add(t);
        }
    }

    @Override
    public int size() {
        return this.l.size();
    }

    @Override
    public boolean isEmpty() {
        return this.l.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        for (Identity<T> u : this.l) {
            if (((Identity)u).obj != o) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return this.listIterator();
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            result[i] = this.get(i);
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a == null) {
            throw new NullPointerException();
        }
        if (a.length < this.size()) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
        }
        int sz = this.size();
        for (int i = 0; i < sz; ++i) {
            a[i] = this.l.get(i).get();
        }
        return a;
    }

    @Override
    public boolean add(T e) {
        return this.l.add(new Identity<T>(e));
    }

    @Override
    public boolean remove(Object o) {
        Iterator<Identity<T>> it = this.l.iterator();
        while (it.hasNext()) {
            T t = it.next().get();
            if (t != o) continue;
            it.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        boolean result = !c.isEmpty();
        for (Object o : c) {
            result &= this.contains(o);
        }
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        ArrayList<Identity<T>> ll = new ArrayList<Identity<T>>();
        for (T t : c) {
            ll.add(new Identity<T>(t));
        }
        return this.l.addAll(ll);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        ArrayList<Identity<T>> ll = new ArrayList<Identity<T>>();
        for (T t : c) {
            ll.add(new Identity<T>(t));
        }
        return this.l.addAll(index, ll);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        ArrayList ll = new ArrayList();
        for (Object t : c) {
            ll.add(new Identity(t));
        }
        return this.l.removeAll(ll);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        ArrayList ll = new ArrayList();
        for (Object t : c) {
            ll.add(new Identity(t));
        }
        return this.l.retainAll(ll);
    }

    @Override
    public void clear() {
        this.l.clear();
    }

    @Override
    public T get(int index) {
        return this.l.get(index).get();
    }

    @Override
    public T set(int index, T element) {
        Identity<T> u = new Identity<T>(element);
        Identity<T> old = this.l.set(index, u);
        return old == null ? null : (T)old.get();
    }

    @Override
    public void add(int index, T element) {
        this.l.add(index, new Identity<T>(element));
    }

    @Override
    public T remove(int index) {
        Identity<T> result = this.l.remove(index);
        return result == null ? null : (T)result.get();
    }

    @Override
    public int indexOf(Object o) {
        int sz = this.size();
        for (int i = 0; i < sz; ++i) {
            if (o != this.get(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        int sz = this.size();
        for (int i = sz - 1; i >= 0; --i) {
            if (o != this.get(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator<T> listIterator() {
        return new ConvertIterator(this.l.listIterator(), new C());
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new ConvertIterator(this.l.listIterator(index), new C());
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return new IdentityList<T>(true, this.l.subList(fromIndex, toIndex));
    }

    @Override
    public boolean equals(Object o) {
        return o == this;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    public String toString() {
        return Strings.join((char)',', (Iterable)this);
    }

    private static final class C<T>
    implements Converter<T, Identity<T>> {
        private C() {
        }

        @Override
        public Identity<T> unconvert(T r) {
            return new Identity<T>(r);
        }

        @Override
        public T convert(Identity<T> t) {
            return t == null ? null : (T)t.get();
        }
    }

    private static final class Identity<T> {
        private final T obj;

        Identity(T obj) {
            this.obj = obj;
        }

        public boolean equals(Object o) {
            return o == this.obj || o == this;
        }

        public int hashCode() {
            return this.obj == null ? System.identityHashCode(this) : System.identityHashCode(this.obj);
        }

        public String toString() {
            return this.obj == null ? "null" : this.obj.toString();
        }

        public T get() {
            return this.obj;
        }
    }
}

