/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.collections;

import com.mastfrog.abstractions.list.LongResolvable;
import com.mastfrog.util.collections.CollectionUtils;
import com.mastfrog.util.search.Bias;
import com.mastfrog.util.search.BinarySearch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.LongFunction;
import java.util.function.ToLongFunction;

class ImmutableArrayMap<T, R>
implements Map<T, R>,
LongFunction<T> {
    final T[] keys;
    final R[] values;
    final BinarySearch<T> search;
    private final ToLongFunction<? super Object> func;
    private final Class<T> keyType;

    ImmutableArrayMap(Map<T, R> map, Class<T> keyType, Class<R> valType, LongResolvable func) {
        this.keyType = keyType;
        ArrayList<Map.Entry<T, R>> l = new ArrayList<Map.Entry<T, R>>(map.entrySet());
        Collections.sort(l, (o1, o2) -> {
            long a = func.indexOf(o1.getKey());
            long b = func.indexOf(o2.getKey());
            return Long.compare(a, b);
        });
        this.keys = CollectionUtils.genericArray(keyType, l.size());
        this.values = CollectionUtils.genericArray(valType, l.size());
        long lastValue = Long.MIN_VALUE;
        for (int i = 0; i < this.keys.length; ++i) {
            Map.Entry e = (Map.Entry)l.get(i);
            this.keys[i] = e.getKey();
            this.values[i] = e.getValue();
            long val = func.indexOf(this.keys[i]);
            if (val < lastValue) {
                throw new IllegalArgumentException("Function does not match sort order - applyAsLong() on '" + this.keys[i - 1] + "' returned " + lastValue + " but applyAsLong() on '" + this.keys[i] + "' returns " + val);
            }
            lastValue = val;
        }
        ToLongFunction<Object> fn = arg_0 -> ((LongResolvable)func).indexOf(arg_0);
        this.search = new BinarySearch(fn, this.keys.length, this);
        this.func = fn;
    }

    @Override
    public int size() {
        return this.keys.length;
    }

    @Override
    public boolean isEmpty() {
        return this.keys.length == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.keyType.isInstance(key)) {
            T k = this.keyType.cast(key);
            long offset = this.search.search(this.func.applyAsLong(k), Bias.NONE);
            return offset >= 0L;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        for (R o : this.values) {
            if (!Objects.equals(o, value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public R get(Object key) {
        T k;
        long index;
        if (this.keyType.isInstance(key) && (index = this.search.search(this.func.applyAsLong(k = this.keyType.cast(key)), Bias.NONE)) >= 0L) {
            return this.values[(int)index];
        }
        return null;
    }

    @Override
    public R put(T key, R value) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public R remove(Object key) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void putAll(Map<? extends T, ? extends R> m) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public Set<T> keySet() {
        return CollectionUtils.setOf(this.keys);
    }

    @Override
    public Collection<R> values() {
        return Arrays.asList(this.values);
    }

    @Override
    public Set<Map.Entry<T, R>> entrySet() {
        LinkedHashSet<Map.Entry<T, R>> result = new LinkedHashSet<Map.Entry<T, R>>();
        for (int i = 0; i < this.keys.length; ++i) {
            result.add(new E(i));
        }
        return result;
    }

    @Override
    public T apply(long value) {
        return this.keys[(int)value];
    }

    final class E
    implements Map.Entry<T, R> {
        private final int index;

        public E(int index) {
            this.index = index;
        }

        @Override
        public T getKey() {
            return ImmutableArrayMap.this.keys[this.index];
        }

        @Override
        public R getValue() {
            return ImmutableArrayMap.this.values[this.index];
        }

        @Override
        public R setValue(R value) {
            throw new UnsupportedOperationException("Not supported.");
        }

        public String toString() {
            return ImmutableArrayMap.this.keys[this.index] + " = " + ImmutableArrayMap.this.values[this.index];
        }

        @Override
        public int hashCode() {
            return this.index;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Map.Entry && Objects.equals(((Map.Entry)o).getKey(), this.getKey()) && Objects.equals(((Map.Entry)o).getValue(), this.getValue());
        }
    }
}

