/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.collections;

import com.mastfrog.util.collections.IntListImpl;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.search.Bias;
import java.util.Collection;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.function.IntConsumer;

public interface IntList
extends List<Integer> {
    public static IntList create() {
        return new IntListImpl();
    }

    public static IntList create(int initialCapacity) {
        return new IntListImpl(Checks.greaterThanOne((String)"initialCapacity", (int)initialCapacity));
    }

    public static IntList create(Collection<? extends Integer> vals) {
        if (vals instanceof IntList) {
            return ((IntList)vals).copy();
        }
        IntListImpl result = new IntListImpl(vals.size());
        result.addAll(vals);
        return result;
    }

    public static IntList createFrom(int ... vals) {
        return new IntListImpl(vals);
    }

    public void add(int var1);

    @Override
    public void add(int var1, int var2);

    public void addAll(int ... var1);

    public void addAll(int var1, int ... var2);

    public void addArray(int ... var1);

    public boolean contains(int var1);

    public void forEach(IntConsumer var1);

    public void forEachReversed(IntConsumer var1);

    @Override
    public Integer get(int var1);

    public int getAsInt(int var1);

    public int indexOf(int var1);

    public int lastIndexOf(int var1);

    @Override
    public Integer remove(int var1);

    public void removeAt(int var1);

    @Override
    public boolean removeLast();

    @Override
    public int set(int var1, int var2);

    public IntList subList(int var1, int var2);

    public IntList copy();

    public int[] toIntArray();

    public int first();

    public int last();

    public int indexOfPresumingSorted(int var1);

    public int nearestIndexToPresumingSorted(int var1, Bias var2);

    public void sort();

    public PrimitiveIterator.OfInt iterator();

    public int adjustValues(int var1, int var2, int var3);

    public int adjustValues(int var1, int var2);
}

