/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.collections;

import com.mastfrog.util.collections.IntList;
import com.mastfrog.util.search.Bias;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.function.Consumer;
import java.util.function.IntConsumer;

final class IntListImpl
extends AbstractList<Integer>
implements IntList,
Serializable {
    private int[] values;
    private int size;
    private final int initialCapacity;

    IntListImpl(int initialCapacity) {
        this.values = new int[initialCapacity];
        this.initialCapacity = initialCapacity;
    }

    IntListImpl() {
        this(96);
    }

    IntListImpl(int[] ints) {
        this(ints, false);
    }

    IntListImpl(int[] ints, boolean unsafe) {
        this.values = ints.length == 0 ? new int[16] : (unsafe ? ints : Arrays.copyOf(ints, ints.length));
        this.size = ints.length;
        this.initialCapacity = Math.max(16, this.size);
    }

    @Override
    public IntListImpl copy() {
        int[] newValues = Arrays.copyOf(this.values, this.size);
        return new IntListImpl(newValues, true);
    }

    @Override
    public boolean addAll(Collection<? extends Integer> c) {
        if (c.isEmpty()) {
            return false;
        }
        if (c instanceof IntListImpl) {
            if (!c.isEmpty()) {
                this.maybeGrow(this.size + c.size());
                IntListImpl il = (IntListImpl)c;
                System.arraycopy(il.values, 0, this.values, this.size, il.size);
                this.size += il.size;
            }
            return c.isEmpty();
        }
        Iterator<? extends Integer> ints = c.iterator();
        if (ints instanceof PrimitiveIterator.OfInt) {
            int[] nue = new int[c.size()];
            PrimitiveIterator.OfInt p = (PrimitiveIterator.OfInt)ints;
            int ix = 0;
            while (p.hasNext()) {
                nue[ix++] = p.nextInt();
            }
            this.addAll(nue);
            return nue.length > 0;
        }
        return super.addAll(c);
    }

    @Override
    public IntListImpl subList(int fromIndex, int toIndex) {
        this.checkIndex(fromIndex);
        this.checkIndex(toIndex);
        int[] nue = new int[toIndex - fromIndex];
        System.arraycopy(this.values, fromIndex, nue, 0, nue.length);
        return new IntListImpl(nue, true);
    }

    @Override
    public int[] toIntArray() {
        return Arrays.copyOf(this.values, this.size);
    }

    @Override
    public int getAsInt(int index) {
        this.checkIndex(index);
        return this.values[index];
    }

    @Override
    public boolean removeLast() {
        if (this.size > 0) {
            --this.size;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void add(int value) {
        this.maybeGrow(this.size + 1);
        this.values[this.size++] = value;
    }

    @Override
    public void addArray(int ... arr) {
        this.maybeGrow(this.size + arr.length);
        System.arraycopy(arr, 0, this.values, this.size, arr.length);
        this.size += arr.length;
    }

    @Override
    public int indexOf(int value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.values[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void sort() {
        if (this.size > 0) {
            Arrays.sort(this.values, 0, this.size);
        }
    }

    @Override
    public int indexOfPresumingSorted(int value) {
        if (this.size == 0) {
            return -1;
        }
        if (this.size == 1) {
            return value == this.values[0] ? 0 : -1;
        }
        return Arrays.binarySearch(this.values, 0, this.size, value);
    }

    @Override
    public int adjustValues(int fromIndex, int toIndex, int by) {
        if (toIndex <= fromIndex) {
            throw new IllegalArgumentException("toIndex must be > fromIndex, but got " + fromIndex + ", " + toIndex);
        }
        int result = 0;
        if (by != 0) {
            int i = Math.max(0, fromIndex);
            while (i < Math.min(this.size, toIndex)) {
                int n = i++;
                this.values[n] = this.values[n] + by;
                ++result;
            }
        }
        return result;
    }

    @Override
    public int adjustValues(int aboveIndex, int by) {
        int result = 0;
        if (by != 0) {
            int i = Math.max(0, aboveIndex);
            while (i < this.size) {
                int n = i++;
                this.values[n] = this.values[n] + by;
                ++result;
            }
        }
        return result;
    }

    @Override
    public int nearestIndexToPresumingSorted(int value, Bias bias) {
        if (this.size == 0) {
            return -1;
        }
        if (this.size == 1) {
            int val = this.values[0];
            switch (bias) {
                case BACKWARD: {
                    if (val <= value) {
                        return 0;
                    }
                    return -1;
                }
                case FORWARD: 
                case NEAREST: {
                    if (val >= value) {
                        return 0;
                    }
                    return -1;
                }
            }
        }
        switch (bias) {
            case NONE: {
                int result;
                if (result >= 0) {
                    for (result = this.indexOfPresumingSorted(value); result < this.size - 1 && this.values[result + 1] == this.values[result]; ++result) {
                    }
                }
                return result;
            }
            case BACKWARD: 
            case FORWARD: {
                int res2;
                if (res2 != -1) {
                    for (res2 = this.nearestIndexToPresumingSorted(0, this.size - 1, bias, value); res2 < this.size - 1 && this.values[res2 + 1] == this.values[res2]; ++res2) {
                    }
                }
                return res2;
            }
            case NEAREST: {
                int bwdDiff;
                int fwd = this.nearestIndexToPresumingSorted(0, this.size - 1, Bias.FORWARD, value);
                int bwd = this.nearestIndexToPresumingSorted(0, this.size - 1, Bias.BACKWARD, value);
                if (fwd == -1) {
                    return bwd;
                }
                if (bwd == -1) {
                    return fwd;
                }
                if (fwd == bwd) {
                    return fwd;
                }
                int fwdDiff = Math.abs(this.values[fwd] - value);
                if (fwdDiff == (bwdDiff = Math.abs(this.values[bwd] - value))) {
                    return fwd;
                }
                if (fwdDiff < bwdDiff) {
                    return fwd;
                }
                return bwd;
            }
        }
        throw new AssertionError((Object)bias);
    }

    @Override
    public int last() {
        if (this.size == 0) {
            throw new NoSuchElementException("Empty");
        }
        return this.values[this.size - 1];
    }

    @Override
    public int first() {
        if (this.size == 0) {
            throw new NoSuchElementException("Empty");
        }
        return this.values[0];
    }

    private int nearestIndexToPresumingSorted(int start, int end, Bias bias, int value) {
        int startVal;
        if (start == end) {
            int currentVal = this.values[start];
            if (currentVal == value) {
                return start;
            }
            switch (bias) {
                case BACKWARD: {
                    if (currentVal <= value) {
                        return start;
                    }
                    return -1;
                }
                case FORWARD: {
                    if (currentVal >= value) {
                        return start;
                    }
                    return -1;
                }
            }
        }
        if ((startVal = this.values[start]) == value) {
            return start;
        }
        if (startVal > value) {
            switch (bias) {
                case BACKWARD: {
                    if (startVal > value) {
                        return -1;
                    }
                    return start - 1;
                }
                case FORWARD: {
                    return start;
                }
            }
            return -1;
        }
        int endVal = this.values[end];
        if (endVal == value) {
            return end;
        }
        if (endVal < value) {
            switch (bias) {
                case BACKWARD: {
                    return end;
                }
                case FORWARD: {
                    int result = end + 1;
                    return result < this.size ? result : -1;
                }
            }
            return -1;
        }
        int mid = start + (end - start) / 2;
        int midVal = this.values[mid];
        if (midVal == value) {
            return mid;
        }
        if (midVal < value && endVal > value) {
            int newStart = mid + 1;
            int newEnd = end - 1;
            int nextStartValue = this.values[newStart];
            if (nextStartValue > value && bias == Bias.BACKWARD && (newEnd - newStart <= 1 || midVal < value)) {
                return mid;
            }
            int nextEndValue = this.values[newEnd];
            if (nextEndValue < value && bias == Bias.FORWARD && newEnd - newStart <= 1) {
                return end;
            }
            return this.nearestIndexToPresumingSorted(newStart, newEnd, bias, value);
        }
        if (midVal > value && startVal < value) {
            int nextEnd = mid - 1;
            int nextStart = start + 1;
            int nextEndValue = this.values[nextEnd];
            if (nextEndValue < value && bias == Bias.FORWARD && nextEnd - nextStart <= 1) {
                return mid;
            }
            int newStartValue = this.values[nextStart];
            if (bias == Bias.BACKWARD && newStartValue > value && (startVal < value || nextEnd - nextStart <= 1)) {
                return start;
            }
            return this.nearestIndexToPresumingSorted(nextStart, nextEnd, bias, value);
        }
        return -1;
    }

    @Override
    public boolean contains(int value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.values[i] != value) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addAll(int ... values) {
        this.maybeGrow(this.size + values.length);
        System.arraycopy(values, 0, this.values, this.size, values.length);
        this.size += values.length;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index not between 0-" + this.size + ": " + index);
        }
    }

    @Override
    public void removeAt(int index) {
        this.checkIndex(index);
        if (index != this.size - 1) {
            System.arraycopy(this.values, index + 1, this.values, index, this.size - (index + 1));
        }
        --this.size;
    }

    @Override
    public Integer remove(int index) {
        this.checkIndex(index);
        int old = this.values[index];
        if (index != this.size - 1) {
            System.arraycopy(this.values, index + 1, this.values, index, this.size - (index + 1));
        }
        --this.size;
        return old;
    }

    @Override
    public void forEach(IntConsumer c) {
        for (int i = 0; i < this.size; ++i) {
            c.accept(this.values[i]);
        }
    }

    @Override
    public void forEachReversed(IntConsumer c) {
        for (int i = this.size - 1; i >= 0; --i) {
            c.accept(this.values[i]);
        }
    }

    private void maybeGrow(int newSize) {
        if (newSize >= this.values.length) {
            newSize = newSize % this.initialCapacity == 0 ? (newSize += this.initialCapacity) : this.initialCapacity * Math.max(this.initialCapacity * 2, newSize / this.initialCapacity + 1);
            this.values = Arrays.copyOf(this.values, newSize);
        }
    }

    @Override
    public Integer get(int index) {
        this.checkIndex(index);
        return this.values[index];
    }

    @Override
    public void forEach(Consumer<? super Integer> action) {
        for (int i = 0; i < this.size; ++i) {
            action.accept((Integer)this.values[i]);
        }
    }

    @Override
    public void addAll(int index, int ... nue) {
        this.checkIndex(index);
        this.maybeGrow(this.size + this.values.length);
        System.arraycopy(this.values, index, this.values, index + nue.length, this.size - index);
        System.arraycopy(nue, 0, this.values, index, this.values.length);
        this.size += this.values.length;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Integer> c) {
        if (c.isEmpty()) {
            return false;
        }
        if (c.size() == 1) {
            return this.add(c.iterator().next());
        }
        int[] all = new int[c.size()];
        int i = 0;
        Iterator<? extends Integer> it = c.iterator();
        while (it.hasNext()) {
            all[i] = it.next();
            ++i;
        }
        this.addAll(index, all);
        return true;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public int lastIndexOf(int i) {
        for (int j = this.size - 1; j >= 0; --j) {
            if (this.values[j] != i) continue;
            return j;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (!(o instanceof Integer)) {
            return -1;
        }
        return this.lastIndexOf((Integer)o);
    }

    @Override
    public void add(int index, Integer element) {
        this.add(index, (int)element);
    }

    @Override
    public void add(int index, int element) {
        int sz = this.size();
        if (index < 0 || index >= sz) {
            throw new IllegalArgumentException("Index out of range - size " + this.size() + " but passed " + index);
        }
        this.maybeGrow(sz + 1);
        System.arraycopy(this.values, index, this.values, index + 1, this.values.length - index - 1);
        this.values[index] = element;
        ++this.size;
    }

    @Override
    public int set(int index, int value) {
        this.checkIndex(index);
        int old = this.values[index];
        this.values[index] = value;
        return old;
    }

    @Override
    public Integer set(int index, Integer element) {
        return this.set(index, (int)element);
    }

    @Override
    public boolean add(Integer e) {
        this.add((int)e);
        return true;
    }

    @Override
    public PrimitiveIterator.OfInt iterator() {
        return new Iter();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(2 + 4 * this.size).append('[');
        for (int i = 0; i < this.size; ++i) {
            sb.append(this.get(i));
            if (i == this.size - 1) continue;
            sb.append(", ");
        }
        return sb.append(']').toString();
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (int i = 0; i < this.size; ++i) {
            hashCode = 31 * hashCode + this.values[i];
        }
        return hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof IntListImpl) {
            IntListImpl other = (IntListImpl)o;
            if (other.size != this.size) {
                return false;
            }
            if (this.size == 0) {
                return true;
            }
            for (int i = 0; i < this.size; ++i) {
                if (this.values[i] == other.values[i]) continue;
                return false;
            }
            return true;
        }
        return super.equals(o);
    }

    private class Iter
    implements PrimitiveIterator.OfInt {
        private int pos = -1;

        private Iter() {
        }

        @Override
        public boolean hasNext() {
            return this.pos + 1 < IntListImpl.this.size;
        }

        @Override
        public Integer next() {
            return this.nextInt();
        }

        @Override
        public int nextInt() {
            if (this.pos >= IntListImpl.this.size) {
                throw new NoSuchElementException(this.pos + " of " + IntListImpl.this.size);
            }
            return IntListImpl.this.values[++this.pos];
        }
    }
}

