/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.collections;

import com.mastfrog.util.collections.ArrayIntMap;
import com.mastfrog.util.collections.IntMapSynchronized;
import com.mastfrog.util.search.Bias;
import java.io.Serializable;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.function.IntConsumer;

public interface IntMap<T>
extends Iterable<Map.Entry<Integer, T>>,
Map<Integer, T>,
Serializable {
    public boolean containsKey(int var1);

    public void decrementKeys(int var1);

    public static <T> IntMap<T> of(int[] keys, T[] vals) {
        return new ArrayIntMap(keys, vals);
    }

    default public int[] keysArray() {
        int[] result = new int[this.size()];
        int ix = 0;
        PrimitiveIterator.OfInt oi = this.keysIterator();
        while (oi.hasNext()) {
            result[ix++] = oi.nextInt();
        }
        return result;
    }

    default public Object[] valuesArray() {
        Object[] result = new Object[this.size()];
        int ix = 0;
        PrimitiveIterator.OfInt oi = this.keysIterator();
        while (oi.hasNext()) {
            result[ix++] = this.get(oi.nextInt());
        }
        return result;
    }

    public Iterable<Map.Entry<Integer, T>> entries();

    default public T remove(int key) {
        return (T)this.remove((Object)key);
    }

    public T get(int var1);

    public T getIfPresent(int var1, T var2);

    public int[] getKeys();

    public int highestKey();

    public PrimitiveIterator.OfInt keysIterator();

    public int lowestKey();

    public int nearest(int var1, boolean var2);

    default public int nearest(int key, Bias bias) {
        switch (bias) {
            case NONE: {
                return this.containsKey(key) ? key : -1;
            }
            case BACKWARD: {
                return this.nearest(key, true);
            }
            case FORWARD: {
                return this.nearest(key, false);
            }
            case NEAREST: {
                int distFwd;
                int back = this.nearest(key, false);
                int fwd = this.nearest(key, true);
                int distBack = back < 0 ? Integer.MAX_VALUE : Math.abs(key - back);
                int n = distFwd = fwd < 0 ? Integer.MAX_VALUE : Math.abs(fwd - key);
                if (distFwd <= distBack) {
                    return fwd;
                }
                return back;
            }
        }
        throw new AssertionError((Object)bias);
    }

    default public T nearestValue(int key, Bias bias) {
        int actualKey = this.nearest(key, bias);
        return actualKey == -1 ? null : (T)this.get(key);
    }

    @Override
    public T put(int var1, T var2);

    default public IntMap<T> toSynchronizedIntMap() {
        return new IntMapSynchronized(this);
    }

    default public void forEachKey(IntConsumer cons) {
        int[] k = this.getKeys();
        for (int i = 0; i < k.length; ++i) {
            cons.accept(k[i]);
        }
    }

    @Override
    default public void forEach(IntMapConsumer<? super T> cons) {
        int[] k = this.getKeys();
        for (int i = 0; i < k.length; ++i) {
            T t = this.get(k[i]);
            cons.accept(k[i], t);
        }
    }

    default public boolean forSomeKeys(IntMapAbortableConsumer<? super T> cons) {
        int[] k = this.getKeys();
        for (int i = 0; i < k.length; ++i) {
            T t = this.get(k[i]);
            boolean result = cons.accept(k[i], t);
            if (result) continue;
            return false;
        }
        return true;
    }

    @FunctionalInterface
    public static interface IntMapAbortableConsumer<T> {
        public boolean accept(int var1, T var2);
    }

    @FunctionalInterface
    public static interface IntMapConsumer<T> {
        public void accept(int var1, T var2);
    }
}

