/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.collections;

import com.mastfrog.util.collections.IntMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntConsumer;

final class IntMapSynchronized<T>
implements IntMap<T> {
    private final IntMap<T> delegate;

    public IntMapSynchronized(IntMap<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public synchronized boolean containsKey(int key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public synchronized void decrementKeys(int decrement) {
        this.delegate.decrementKeys(decrement);
    }

    @Override
    public synchronized Iterable<Map.Entry<Integer, T>> entries() {
        return this.delegate.entries();
    }

    @Override
    public synchronized T get(int key) {
        return this.delegate.get(key);
    }

    @Override
    public synchronized int[] getKeys() {
        return this.delegate.getKeys();
    }

    @Override
    public synchronized int highestKey() {
        return this.delegate.highestKey();
    }

    @Override
    public PrimitiveIterator.OfInt keysIterator() {
        return new SyncPrimIterator(this);
    }

    @Override
    public synchronized T getIfPresent(int key, T defaultValue) {
        return this.delegate.getIfPresent(key, defaultValue);
    }

    @Override
    public synchronized int lowestKey() {
        return this.delegate.lowestKey();
    }

    @Override
    public synchronized int nearest(int key, boolean backward) {
        return this.delegate.nearest(key, backward);
    }

    @Override
    public synchronized T put(int key, T val) {
        return this.delegate.put(key, val);
    }

    @Override
    public synchronized IntMap<T> toSynchronizedIntMap() {
        return this;
    }

    @Override
    public synchronized void forEachKey(IntConsumer cons) {
        this.delegate.forEachKey(cons);
    }

    @Override
    public synchronized void forEach(IntMap.IntMapConsumer<? super T> cons) {
        this.delegate.forEach(cons);
    }

    @Override
    public synchronized boolean forSomeKeys(IntMap.IntMapAbortableConsumer<? super T> cons) {
        return this.delegate.forSomeKeys(cons);
    }

    @Override
    public synchronized Iterator<Map.Entry<Integer, T>> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public synchronized void forEach(Consumer<? super Map.Entry<Integer, T>> action) {
        this.delegate.forEach(action);
    }

    @Override
    public synchronized Spliterator<Map.Entry<Integer, T>> spliterator() {
        return this.delegate.spliterator();
    }

    @Override
    public synchronized int size() {
        return this.delegate.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public synchronized T get(Object key) {
        return (T)this.delegate.get(key);
    }

    @Override
    public synchronized T put(Integer key, T value) {
        return this.delegate.put(key, value);
    }

    @Override
    public synchronized T remove(Object key) {
        return (T)this.delegate.remove(key);
    }

    @Override
    public synchronized void putAll(Map<? extends Integer, ? extends T> m) {
        this.delegate.putAll(m);
    }

    @Override
    public synchronized void clear() {
        this.delegate.clear();
    }

    @Override
    public synchronized Set<Integer> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public synchronized Collection<T> values() {
        return this.delegate.values();
    }

    @Override
    public synchronized Set<Map.Entry<Integer, T>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public synchronized T getOrDefault(Object key, T defaultValue) {
        return this.delegate.getOrDefault(key, defaultValue);
    }

    @Override
    public synchronized void forEach(BiConsumer<? super Integer, ? super T> action) {
        this.delegate.forEach(action);
    }

    @Override
    public synchronized void replaceAll(BiFunction<? super Integer, ? super T, ? extends T> function) {
        this.delegate.replaceAll(function);
    }

    @Override
    public synchronized T putIfAbsent(Integer key, T value) {
        return this.delegate.putIfAbsent(key, value);
    }

    @Override
    public synchronized boolean remove(Object key, Object value) {
        return this.delegate.remove(key, value);
    }

    @Override
    public synchronized boolean replace(Integer key, T oldValue, T newValue) {
        return this.delegate.replace(key, oldValue, newValue);
    }

    @Override
    public synchronized T replace(Integer key, T value) {
        return this.delegate.replace(key, value);
    }

    @Override
    public synchronized T computeIfAbsent(Integer key, Function<? super Integer, ? extends T> mappingFunction) {
        return this.delegate.computeIfAbsent(key, mappingFunction);
    }

    @Override
    public synchronized T computeIfPresent(Integer key, BiFunction<? super Integer, ? super T, ? extends T> remappingFunction) {
        return this.delegate.computeIfPresent(key, remappingFunction);
    }

    @Override
    public synchronized T compute(Integer key, BiFunction<? super Integer, ? super T, ? extends T> remappingFunction) {
        return this.delegate.compute(key, remappingFunction);
    }

    @Override
    public synchronized T merge(Integer key, T value, BiFunction<? super T, ? super T, ? extends T> remappingFunction) {
        return this.delegate.merge(key, value, remappingFunction);
    }

    @Override
    public synchronized int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public synchronized boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public synchronized String toString() {
        return this.delegate.toString();
    }

    static final class SyncPrimIterator
    implements PrimitiveIterator.OfInt {
        private final PrimitiveIterator.OfInt delegate;
        private final Object lock;

        public SyncPrimIterator(IntMapSynchronized<?> map) {
            this.lock = map;
            this.delegate = ((IntMapSynchronized)map).delegate.keysIterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int nextInt() {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.nextInt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.hasNext();
            }
        }
    }
}

