/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.collections;

import com.mastfrog.util.collections.IntSetImpl;
import java.util.BitSet;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.Random;
import java.util.Set;
import java.util.function.IntConsumer;

public abstract class IntSet
implements Set<Integer>,
Cloneable {
    public static final IntSet EMPTY = new Empty();

    IntSet() {
    }

    public static IntSet create(int capacity) {
        return new IntSetImpl(capacity);
    }

    public static IntSet create() {
        return IntSet.create(96);
    }

    public static IntSet create(int[] arr) {
        BitSet set = new BitSet(arr.length);
        for (int i = 0; i < arr.length; ++i) {
            set.set(arr[i]);
        }
        return new IntSetImpl(set);
    }

    public static IntSet create(BitSet bits) {
        return new IntSetImpl((BitSet)bits.clone());
    }

    public static IntSet create(Collection<? extends Integer> set) {
        return new IntSetImpl(set);
    }

    public static IntSet toIntSet(Collection<? extends Integer> set) {
        if (set instanceof IntSet) {
            return (IntSet)set;
        }
        return new IntSetImpl(set);
    }

    public static IntSet merge(Iterable<IntSet> all) {
        BitSet bits = null;
        for (IntSet i : all) {
            if (bits == null) {
                bits = i.toBits();
                continue;
            }
            bits.or(bits);
        }
        return bits == null ? new IntSetImpl(1) : new IntSetImpl(bits);
    }

    public static IntSet intersection(Iterable<IntSet> all) {
        BitSet bits = null;
        for (IntSet i : all) {
            if (bits == null) {
                bits = i.toBits();
                continue;
            }
            bits.and(bits);
        }
        return bits == null ? new IntSetImpl(1) : new IntSetImpl(bits);
    }

    abstract BitSet bitsUnsafe();

    public IntSet intersection(IntSet other) {
        BitSet b1 = this.bitsUnsafe();
        BitSet nue = (BitSet)other.bitsUnsafe().clone();
        nue.and(b1);
        return new IntSetImpl(nue);
    }

    public IntSet or(IntSet other) {
        BitSet b1 = this.bitsUnsafe();
        BitSet nue = other.toBits();
        nue.or(b1);
        return new IntSetImpl(nue);
    }

    public IntSet xor(IntSet other) {
        BitSet b1 = this.bitsUnsafe();
        BitSet nue = other.toBits();
        nue.xor(b1);
        return new IntSetImpl(nue);
    }

    public IntSet addAll(int ... ints) {
        for (int i : ints) {
            this.add(i);
        }
        return this;
    }

    public abstract BitSet toBits();

    @Override
    public final boolean add(int val) {
        if (val < 0) {
            throw new IllegalArgumentException("Negative values not allowed");
        }
        return this._add(val);
    }

    abstract boolean _add(int var1);

    public int pick(Random r) {
        int max = this.bitsUnsafe().length();
        int pos = r.nextInt(max);
        int result = this.bitsUnsafe().previousSetBit(pos);
        if (result == -1) {
            result = this.bitsUnsafe().nextSetBit(pos);
        }
        return result;
    }

    public boolean sameContents(Set<Integer> other) {
        if (this.size() != other.size()) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other instanceof IntSet) {
            return this.bitsUnsafe().equals(((IntSet)other).bitsUnsafe());
        }
        BitSet matched = (BitSet)this.bitsUnsafe().clone();
        for (Integer o : other) {
            matched.clear(o);
        }
        return matched.cardinality() == 0;
    }

    public abstract int removeLast();

    public abstract void forEach(IntConsumer var1);

    public abstract void forEachReversed(IntConsumer var1);

    public abstract int[] toIntArray();

    public Integer pick(Random r, Set<Integer> notIn) {
        if (notIn.size() >= this.size()) {
            return null;
        }
        int result = this.pick(r);
        BitSet bits = this.bitsUnsafe();
        if (result == -1 || notIn.contains(result)) {
            int pos;
            int len = bits.length();
            int origPos = pos = r.nextInt(bits.length());
            int direction = 1;
            if (pos > len / 2) {
                direction = -1;
            }
            if (bits.get(pos) && !notIn.contains(pos)) {
                return pos;
            }
            boolean flipped = false;
            while (true) {
                int n = result = direction == -1 ? bits.previousSetBit(pos + direction) : bits.nextSetBit(pos + direction);
                if (result == -1) {
                    if (flipped) {
                        result = -1;
                        break;
                    }
                    flipped = true;
                    direction *= -1;
                    pos = origPos;
                }
                if (!notIn.contains(result)) break;
                pos = result;
            }
        }
        if (result == -1) {
            return null;
        }
        notIn.add(result);
        return result;
    }

    public int first() {
        return this.bitsUnsafe().nextSetBit(0);
    }

    public int last() {
        return this.bitsUnsafe().previousSetBit(Integer.MAX_VALUE);
    }

    public int max() {
        int sz = this.bitsUnsafe().size();
        return this.bitsUnsafe().previousSetBit(sz);
    }

    public abstract boolean remove(int var1);

    public abstract int removeFirst();

    public abstract boolean contains(int var1);

    @Override
    public abstract void clear();

    public abstract PrimitiveIterator.OfInt iterator();

    private static final class Empty
    extends IntSet
    implements PrimitiveIterator.OfInt {
        private Empty() {
        }

        @Override
        BitSet bitsUnsafe() {
            return new BitSet(0);
        }

        @Override
        public IntSet or(IntSet other) {
            return other;
        }

        @Override
        public IntSet xor(IntSet other) {
            return new IntSetImpl().xor(other);
        }

        @Override
        public IntSet addAll(int ... ints) {
            throw new UnsupportedOperationException("Immutable.");
        }

        @Override
        public BitSet toBits() {
            return new BitSet(1);
        }

        @Override
        boolean _add(int val) {
            throw new UnsupportedOperationException("Immutable.");
        }

        @Override
        public boolean remove(int val) {
            throw new UnsupportedOperationException("Immutable.");
        }

        @Override
        public int first() {
            return -1;
        }

        @Override
        public int removeFirst() {
            throw new UnsupportedOperationException("Immutable.");
        }

        @Override
        public int removeLast() {
            throw new UnsupportedOperationException("Immutable.");
        }

        @Override
        public void forEach(IntConsumer cons) {
        }

        @Override
        public void forEachReversed(IntConsumer cons) {
        }

        @Override
        public int[] toIntArray() {
            return new int[0];
        }

        @Override
        public int last() {
            throw new NoSuchElementException("Empty.");
        }

        @Override
        public boolean contains(int val) {
            return false;
        }

        @Override
        public void clear() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean contains(Object o) {
            return false;
        }

        @Override
        public PrimitiveIterator.OfInt iterator() {
            return this;
        }

        @Override
        public Object[] toArray() {
            return new Integer[0];
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return new Object[0];
        }

        @Override
        public boolean add(Integer e) {
            throw new UnsupportedOperationException("Immutable.");
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("Immutable.");
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return c.isEmpty();
        }

        @Override
        public boolean addAll(Collection<? extends Integer> c) {
            throw new UnsupportedOperationException("Immutable.");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException("Immutable.");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException("Immutable.");
        }

        @Override
        public int nextInt() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasNext() {
            return false;
        }
    }
}

