/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.collections;

import com.mastfrog.util.collections.IntSet;
import java.lang.reflect.Array;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.PrimitiveIterator;
import java.util.Random;
import java.util.Set;
import java.util.function.IntConsumer;

final class IntSetImpl
extends IntSet {
    private final BitSet bits;

    IntSetImpl() {
        this(96);
    }

    IntSetImpl(int capacity) {
        this.bits = new BitSet(capacity);
    }

    IntSetImpl(Collection<? extends Integer> other) {
        this(other.size());
        this.addAll(other);
    }

    IntSetImpl(BitSet bits) {
        this.bits = bits;
    }

    @Override
    BitSet bitsUnsafe() {
        return this.bits;
    }

    public IntSetImpl intersection(IntSetImpl other) {
        BitSet nue = other.bits;
        nue.and(this.bits);
        return new IntSetImpl(nue);
    }

    @Override
    public IntSetImpl or(IntSet other) {
        BitSet nue = other.toBits();
        nue.or(this.bits);
        return new IntSetImpl(nue);
    }

    @Override
    public IntSet xor(IntSet other) {
        BitSet nue = other.toBits();
        nue.xor(this.bits);
        return new IntSetImpl(nue);
    }

    @Override
    public IntSetImpl addAll(int ... ints) {
        for (int i : ints) {
            this.add(i);
        }
        return this;
    }

    @Override
    public BitSet toBits() {
        return (BitSet)this.bits.clone();
    }

    @Override
    boolean _add(int val) {
        boolean result;
        if (val < 0) {
            throw new IllegalArgumentException("Bit set cannot support negative indices");
        }
        boolean bl = result = !this.bits.get(val);
        if (result) {
            this.bits.set(val);
        }
        return result;
    }

    @Override
    public boolean remove(int val) {
        boolean result = this.bits.get(val);
        this.bits.clear(val);
        return result;
    }

    @Override
    public int pick(Random r) {
        int max = this.bits.length();
        int pos = r.nextInt(max);
        int result = this.bits.previousSetBit(pos);
        if (result == -1) {
            result = this.bits.nextSetBit(pos);
        }
        return result;
    }

    @Override
    public boolean sameContents(Set<Integer> other) {
        if (this.size() != other.size()) {
            return false;
        }
        BitSet matched = (BitSet)this.bits.clone();
        for (Integer o : other) {
            matched.clear(o);
        }
        return matched.cardinality() == 0;
    }

    @Override
    public int first() {
        return this.bits.nextSetBit(0);
    }

    @Override
    public int removeFirst() {
        int pos = this.bits.nextSetBit(0);
        if (pos != -1) {
            this.bits.clear(pos);
        }
        return pos;
    }

    @Override
    public int removeLast() {
        int pos = this.bits.previousSetBit(Integer.MAX_VALUE);
        if (pos != -1) {
            this.bits.clear(pos);
        }
        return pos;
    }

    @Override
    public void forEach(IntConsumer cons) {
        int curr = this.bits.nextSetBit(0);
        while (curr != -1) {
            cons.accept(curr);
            curr = this.bits.nextSetBit(curr + 1);
        }
    }

    @Override
    public void forEachReversed(IntConsumer cons) {
        int curr = this.bits.previousSetBit(Integer.MAX_VALUE);
        while (curr != -1) {
            cons.accept(curr);
            curr = this.bits.previousSetBit(curr - 1);
        }
    }

    @Override
    public int[] toIntArray() {
        int[] result = new int[this.size()];
        int curr = this.bits.nextSetBit(0);
        int i = 0;
        while (curr != -1) {
            result[i] = curr;
            curr = this.bits.nextSetBit(curr + 1);
            ++i;
        }
        return result;
    }

    @Override
    public Integer pick(Random r, Set<Integer> notIn) {
        if (notIn.size() >= this.size()) {
            return null;
        }
        int result = this.pick(r);
        if (result == -1 || notIn.contains(result)) {
            int pos;
            int len = this.bits.length();
            int origPos = pos = r.nextInt(this.bits.length());
            int direction = 1;
            if (pos > len / 2) {
                direction = -1;
            }
            if (this.bits.get(pos) && !notIn.contains(pos)) {
                return pos;
            }
            boolean flipped = false;
            while (true) {
                int n = result = direction == -1 ? this.bits.previousSetBit(pos + direction) : this.bits.nextSetBit(pos + direction);
                if (result == -1) {
                    if (flipped) {
                        result = -1;
                        break;
                    }
                    flipped = true;
                    direction *= -1;
                    pos = origPos;
                }
                if (!notIn.contains(result)) break;
                pos = result;
            }
        }
        if (result == -1) {
            return null;
        }
        notIn.add(result);
        return result;
    }

    @Override
    public int size() {
        return this.bits.cardinality();
    }

    @Override
    public int last() {
        int sz = this.bits.size();
        return this.bits.previousSetBit(sz);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(int val) {
        return this.bits.get(val);
    }

    @Override
    public boolean contains(Object o) {
        return o instanceof Integer && (Integer)o >= 0 && this.bits.get((Integer)o);
    }

    @Override
    public PrimitiveIterator.OfInt iterator() {
        return new BitSetIterator(this.bits);
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        int curr = this.bits.nextSetBit(0);
        int i = 0;
        while (curr != -1) {
            result[i] = curr;
            ++i;
            curr = this.bits.nextSetBit(curr + 1);
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] result) {
        if (result.length < this.size()) {
            result = (Object[])Array.newInstance(result.getClass().getComponentType(), this.size());
        }
        int curr = this.bits.nextSetBit(0);
        int i = 0;
        while (curr != -1) {
            result[i] = curr;
            ++i;
            curr = this.bits.nextSetBit(curr + 1);
        }
        return result;
    }

    @Override
    public boolean add(Integer e) {
        return this.add((int)e);
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Integer) {
            return this.remove((Integer)o);
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        boolean result = false;
        for (Object o : c) {
            if (o instanceof Integer) {
                int val = (Integer)o;
                result = this.contains(val);
                if (result) continue;
                break;
            }
            return false;
        }
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends Integer> c) {
        boolean result;
        if (c instanceof IntSet) {
            int old = this.size();
            this.bits.or(((IntSet)c).bitsUnsafe());
            result = this.size() != old;
        } else {
            BitSet bs = new BitSet();
            for (Integer n : c) {
                int val = n;
                if (bs.get(val)) continue;
                bs.set(val);
            }
            boolean bl = result = !bs.isEmpty();
            if (result) {
                this.bits.or(bs);
            }
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean result;
        if (c instanceof IntSetImpl) {
            int old = this.bits.cardinality();
            this.bits.and(((IntSetImpl)c).bits);
            return this.bits.cardinality() != old;
        }
        BitSet bs = new BitSet();
        for (Object o : c) {
            if (!(o instanceof Integer)) continue;
            bs.set((Integer)o);
        }
        boolean bl = result = !bs.isEmpty();
        if (result) {
            this.bits.and(bs);
        }
        return result && !this.bits.isEmpty();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c instanceof IntSetImpl) {
            int old = this.bits.cardinality();
            this.bits.andNot(((IntSetImpl)c).bits);
            return old != this.bits.cardinality();
        }
        BitSet bs = new BitSet();
        for (Object o : c) {
            if (!(o instanceof Integer)) continue;
            bs.set((Integer)o);
        }
        int size = this.size();
        this.bits.andNot(bs);
        return size != this.size();
    }

    @Override
    public void clear() {
        this.bits.clear();
    }

    @Override
    public int hashCode() {
        int h = 0;
        int curr = this.bits.nextSetBit(0);
        int i = 0;
        while (curr != -1) {
            h += curr;
            ++i;
            curr = this.bits.nextSetBit(curr + 1);
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof IntSetImpl) {
            return ((IntSetImpl)o).bits.equals(this.bits);
        }
        if (o instanceof Iterable) {
            BitSet bs = new BitSet(this.size());
            Iterable it = (Iterable)o;
            for (Object elem : it) {
                if (elem instanceof Integer) {
                    bs.set((Integer)elem);
                    continue;
                }
                return false;
            }
            return bs.equals(this.bits);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.size() * 8).append('[');
        int curr = this.bits.nextSetBit(0);
        while (curr != -1) {
            sb.append(curr);
            if (this.bits.nextSetBit(curr + 1) != -1) {
                sb.append(", ");
            }
            curr = this.bits.nextSetBit(curr + 1);
        }
        return sb.append(']').toString();
    }

    private static final class BitSetIterator
    implements Iterator<Integer>,
    PrimitiveIterator.OfInt {
        int pos = 0;
        private final BitSet bits;

        public BitSetIterator(BitSet bits) {
            this.bits = bits;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.bits.length();
        }

        @Override
        public int nextInt() {
            int result = this.bits.nextSetBit(this.pos);
            if (result == -1) {
                throw new IndexOutOfBoundsException("No more values");
            }
            this.pos = result + 1;
            return result;
        }
    }
}

