/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.collections;

import com.mastfrog.util.collections.ArraysManager;
import com.mastfrog.util.collections.ArraysPool;
import com.mastfrog.util.collections.LongList;
import com.mastfrog.util.collections.Longerator;
import com.mastfrog.util.preconditions.Checks;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import java.util.function.UnaryOperator;

final class LongListImpl
extends AbstractList<Long>
implements LongList {
    private final ArraysManager.Longs arrays;
    private int size = 0;
    private boolean sorted = true;

    private LongListImpl(LongListImpl copy) {
        this.arrays = new ArraysManager.Longs(copy.arrays);
        this.sorted = copy.sorted;
        this.size = copy.size;
    }

    public LongListImpl() {
        this(64);
    }

    LongListImpl(ArraysManager.Longs arrays) {
        this.arrays = arrays;
    }

    public LongListImpl(int batchSize) {
        this(new ArraysManager.Longs(batchSize));
    }

    public LongListImpl(int batchSize, int initialPoolSize, int maxPoolSize) {
        this(new ArraysManager.Longs(batchSize, maxPoolSize == 0 ? ArraysPool.uncachedPool(batchSize) : ArraysPool.cachingPool(batchSize, initialPoolSize, maxPoolSize)));
    }

    public LongListImpl(long[] longs) {
        this(longs, Math.max(64, longs.length));
    }

    public LongListImpl(long[] longs, int batchSize) {
        this(longs, new boolean[1], batchSize);
    }

    LongListImpl(long[] longs, boolean[] sortVal, int batchSize) {
        this(longs, (boolean sorted) -> {
            sortVal[0] = sorted;
        }, batchSize);
        this.sorted = sortVal[0];
    }

    LongListImpl(long[] longs, ArraysManager.SortChecker checker, int batchSize) {
        this(new ArraysManager.Longs(batchSize, checker, new long[][]{longs}));
        this.size = longs.length;
    }

    public LongListImpl(long[][] longs, int batchSize) {
        this(longs, new boolean[1], batchSize);
    }

    LongListImpl(long[][] longs, boolean[] sortVal, int batchSize) {
        this(longs, (boolean sorted) -> {
            sortVal[0] = sorted;
        }, batchSize);
        this.sorted = sortVal[0];
    }

    LongListImpl(long[][] longs, ArraysManager.SortChecker checker, int batchSize) {
        this(new ArraysManager.Longs(batchSize, checker, longs));
        this.size = longs.length;
    }

    public LongListImpl(List<long[]> nue, int size, int batchSize, boolean sorted) {
        this(LongListImpl.listToArray(nue), new boolean[1], batchSize);
        this.size = size;
        this.sorted = sorted;
    }

    @Override
    public LongListImpl duplicate() {
        return new LongListImpl(this);
    }

    static long[][] listToArray(List<long[]> l) {
        long[][] result = new long[l.size()][];
        for (int i = 0; i < l.size(); ++i) {
            result[i] = l.get(i);
        }
        return result;
    }

    @Override
    public boolean add(Long e) {
        return this.add((long)e);
    }

    @Override
    public boolean add(long l) {
        if (this.size > 0 && this.sorted) {
            this.sorted = l > this.getLong(this.size - 1);
        }
        long[] arr = this.arrayForIndex(this.size, true);
        arr[this.size % this.arrays.batchSize()] = l;
        ++this.size;
        return true;
    }

    @Override
    public Long set(int index, Long element) {
        return this.set(index, (long)element);
    }

    @Override
    public long[] toLongArray() {
        return this.arrays.toLongArray(this.size);
    }

    @Override
    public void add(int index, Long element) {
        this.add(index, (long)element);
    }

    @Override
    public boolean addAll(Collection<? extends Long> c) {
        if (c.isEmpty()) {
            return false;
        }
        boolean first = true;
        long last = Long.MIN_VALUE;
        for (Long l : c) {
            if (l == null) {
                throw new IllegalArgumentException("Null element in array");
            }
            long val = l;
            if (val <= last) {
                this.sorted = false;
            }
            this.add(val);
            if (first) {
                first = false;
            }
            last = val;
        }
        return !c.isEmpty();
    }

    @Override
    public boolean addAll(long[] longs) {
        if (((long[])Checks.notNull((String)"longs", (Object)longs)).length == 0) {
            return false;
        }
        int batchSize = this.arrays.batchSize();
        int pos = this.size % batchSize;
        int cursor = 0;
        if (this.sorted) {
            long val;
            this.sorted = this.arrays.isSorted(longs);
            if (this.sorted && this.size > 0 && (val = this.getLong(this.size - 1)) >= longs[0]) {
                this.sorted = false;
            }
        }
        while (cursor < longs.length) {
            long[] arr = this.arrayForIndex(this.size, true);
            int count = Math.min(longs.length - cursor, batchSize - pos);
            System.arraycopy(longs, cursor, arr, pos, count);
            pos = 0;
            cursor += count;
            this.size += count;
        }
        return true;
    }

    int currentCapacity() {
        return this.arrays.size() * this.arrays.batchSize();
    }

    private void clobberWithCollection(int index, Collection<? extends Long> c) {
        if (c instanceof LongListImpl) {
            LongListImpl ll = (LongListImpl)c;
            for (int i = 0; i < ll.size; ++i) {
                this.set(index + i, ll.getLong(i));
            }
            return;
        }
        Iterator<? extends Long> it = c.iterator();
        int ix = index;
        long prev = ix == 0 ? Long.MIN_VALUE : this.getLong(ix - 1);
        boolean first = true;
        while (it.hasNext()) {
            long l = it.next();
            if (!first && prev >= l) {
                this.sorted = false;
            }
            this.set(ix++, l);
            prev = l;
            first = false;
        }
        if (ix < this.size && this.getLong(ix) <= prev) {
            this.sorted = false;
        }
    }

    @Override
    public boolean addAll(int index, long[] c) {
        if (((long[])Checks.notNull((String)"c", (Object)c)).length == 0) {
            return false;
        }
        if (index > this.size) {
            throw new IllegalArgumentException("Cannot insert at " + index + " in list of " + this.size);
        }
        if (index == this.size) {
            return this.addAll(c);
        }
        int batchSize = this.arrays.batchSize();
        int firstArray = index / batchSize;
        int offset = index % batchSize;
        if (offset % batchSize == 0 && c.length % batchSize == 0) {
            if (this.sorted) {
                boolean arrayIsSorted = this.arrays.isSorted(c);
                if (!arrayIsSorted) {
                    this.sorted = false;
                } else {
                    long prev;
                    boolean hasPrevious;
                    boolean bl = hasPrevious = index > 0;
                    if (hasPrevious && (prev = this.getLong(index - 1)) >= c[0]) {
                        this.sorted = false;
                    }
                    if (this.sorted) {
                        long next;
                        boolean hasNext;
                        boolean bl2 = hasNext = index < this.size;
                        if (hasNext && c[c.length - 1] >= (next = this.getLong(index))) {
                            this.sorted = false;
                        }
                    }
                }
            }
            for (int i = 0; i < c.length; i += batchSize) {
                long[] batch = (long[])this.arrays.addOne(firstArray);
                this.arrays.copy(c, 0, batch, i * batchSize, batchSize);
                ++firstArray;
            }
            this.size += c.length;
            return true;
        }
        int count = c.length;
        this.arrays.shiftOneArrayRight(firstArray, offset, count);
        this.size += count;
        long last = Long.MIN_VALUE;
        for (int i = 0; i < c.length; ++i) {
            long l = c[i];
            if (index >= this.arrays.capacity()) {
                this.arrays.addOne();
            }
            if (i > 0 && this.sorted && last >= l) {
                this.sorted = false;
            }
            this.set(index++, l);
            last = l;
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Long> c) {
        if (((Collection)Checks.notNull((String)"c", c)).isEmpty()) {
            return false;
        }
        if (index > this.size) {
            throw new IllegalArgumentException("Cannot insert at " + index + " in list of " + this.size);
        }
        if (index == this.size) {
            return this.addAll(c);
        }
        int batchSize = this.arrays.batchSize();
        int firstArray = index / batchSize;
        int offset = index % batchSize;
        if (offset % batchSize == 0 && c.size() % batchSize == 0) {
            long last;
            Iterator<? extends Long> iter = c.iterator();
            long l = last = this.size > 0 && index > 0 ? this.getLong(index - 1) : Long.MIN_VALUE;
            while (iter.hasNext()) {
                long[] batch = (long[])this.arrays.addOne(firstArray);
                ++firstArray;
                for (int i = 0; i < batch.length; ++i) {
                    long value;
                    Long val = iter.next();
                    if (val == null) {
                        throw new IllegalArgumentException("Collection contains null at " + i + ": " + c);
                    }
                    batch[i] = value = val.longValue();
                    if (last > value) continue;
                    this.sorted = false;
                }
            }
            this.size += c.size();
            return true;
        }
        int count = c.size();
        this.arrays.shiftOneArrayRight(firstArray, offset, count);
        this.size += count;
        this.clobberWithCollection(index, c);
        return true;
    }

    @Override
    public void add(int index, long element) {
        if (index == this.size) {
            this.add(element);
            return;
        }
        if (index > this.size) {
            throw new IndexOutOfBoundsException("Cannot add at " + index + " - size is " + this.size);
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("Negative index " + index);
        }
        int firstArray = index / this.arrays.batchSize();
        if (this.size + 1 / this.arrays.batchSize() > this.arrays.size()) {
            this.arrays.addOne();
        }
        long[] destArray = (long[])this.arrays.shiftOneArrayRight(firstArray, index % this.arrays.batchSize(), 1);
        destArray[index % this.arrays.batchSize()] = element;
        long preceding = Long.MIN_VALUE;
        long next = Long.MAX_VALUE;
        ++this.size;
        if (this.sorted) {
            boolean hasSubsequent;
            boolean hasPreceding = index > 0;
            boolean bl = hasSubsequent = index < this.size - 1;
            if (hasPreceding) {
                preceding = this.getLong(index - 1);
            }
            if (hasSubsequent) {
                next = this.getLong(index + 1);
            }
            if (next <= element && hasSubsequent || preceding >= element && hasPreceding) {
                this.sorted = false;
            }
        }
        this.set(index, element);
    }

    @Override
    public Long remove(int index) {
        return this.removeAt(index);
    }

    @Override
    public void clear() {
        this.arrays.clear();
        this.size = 0;
        this.sorted = true;
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("Negative from index " + fromIndex);
        }
        if (toIndex < 0) {
            throw new IndexOutOfBoundsException("Negative to index " + fromIndex);
        }
        if (toIndex > this.size) {
            throw new IndexOutOfBoundsException("To index is past end: " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("From index < toIndex " + fromIndex + " is < " + toIndex);
        }
        if (fromIndex == toIndex) {
            return;
        }
        if (toIndex == this.size) {
            this.size = fromIndex;
            this.arrays.pruneTo(this.size);
        } else if (fromIndex + 1 == toIndex) {
            this.remove(fromIndex);
        } else if (fromIndex == 0 && toIndex == this.size) {
            this.clear();
        } else {
            this.arrays.removeRange(fromIndex, toIndex);
            this.size -= toIndex - fromIndex;
            this.arrays.pruneTo(this.size);
            return;
        }
    }

    public long removeAt(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Invalid index " + index + " in list of " + this.size);
        }
        if (index == this.size - 1) {
            long val = this.getLong(this.size - 1);
            --this.size;
            this.arrays.pruneTo(this.size);
            if (this.size == 0) {
                this.sorted = true;
            }
            return val;
        }
        long val = this.getLong(index);
        this.arrays.removeAt(index);
        --this.size;
        this.arrays.pruneTo(this.size);
        if (this.size == 0) {
            this.sorted = true;
        }
        return val;
    }

    @Override
    public int removeLong(long val) {
        int ix = this.indexOf(val);
        if (ix < 0) {
            return -1;
        }
        this.removeAt(ix);
        return ix;
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Long) {
            return this.removeLong((Long)o) >= 0;
        }
        return false;
    }

    @Override
    public boolean isSorted() {
        return this.sorted;
    }

    @Override
    public boolean sort() {
        if (!this.sorted) {
            Collections.sort(this);
            Longerator lngs = this.longerator();
            boolean first = true;
            long last = Long.MIN_VALUE;
            this.sorted = true;
            while (lngs.hasNext()) {
                long val = lngs.next();
                if (!first && val == last) {
                    this.sorted = false;
                    break;
                }
                last = val;
                first = false;
            }
        }
        return this.sorted;
    }

    @Override
    public Longerator longerator() {
        return new Longerator(){
            int ix = -1;

            @Override
            public long next() {
                return LongListImpl.this.getLong(++this.ix);
            }

            @Override
            public boolean hasNext() {
                return this.ix + 1 < LongListImpl.this.size;
            }
        };
    }

    @Override
    public long set(int index, long element) {
        long subsequent;
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("No such element " + index);
        }
        long[] arr = this.arrayForIndex(index, false);
        int offset = index % this.arrays.batchSize();
        arr[offset] = element;
        long preceding = index == 0 ? -1L : this.getLong(index - 1);
        long l = subsequent = index != this.size - 1 ? this.getLong(index + 1) : -1L;
        if (preceding != -1L && preceding >= element) {
            this.sorted = false;
        }
        if (subsequent != -1L && subsequent <= element) {
            this.sorted = false;
        }
        return 0L;
    }

    @Override
    public int indexOfArray(long[] val) {
        int i;
        if (val.length == 0) {
            return 0;
        }
        if (val.length > this.size) {
            return -1;
        }
        if (val.length == 1) {
            return this.indexOf(val[0]);
        }
        if (this.sorted && !this.arrays.isSorted(val)) {
            return -1;
        }
        int first = this.indexOf(val[0]);
        if (first == -1) {
            return -1;
        }
        if (this.size - 1 - first < val.length) {
            return -1;
        }
        for (i = first + 1; i < first + val.length && val[i - first] == this.getLong(i); ++i) {
            if (i != first + val.length - 1) continue;
            return first;
        }
        for (i = first + 1; i < this.size - 1 - val.length; ++i) {
            for (int j = 0; j < val.length && val[j] == this.getLong(i + j); ++j) {
                if (j != val.length - 1) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int indexOf(long test) {
        if (this.size == 0 || this.arrays.isEmpty()) {
            return -1;
        }
        int batchSize = this.arrays.batchSize();
        int ct = Math.min(this.arrays.size(), this.size / batchSize + 1);
        if (this.sorted) {
            if (this.size > 0 && (this.getLong(0) > test || this.getLong(this.size - 1) < test)) {
                return -1;
            }
            for (int i = 0; i < ct; ++i) {
                int lastIndex;
                if (i >= this.arrays.size()) {
                    throw new IllegalArgumentException("Bad array index " + i + " of " + ct + " with arrays size " + this.arrays.size() + ", arrays.batchSize() " + batchSize + ", size " + this.size + " ct computed to " + ct + " size/arrays.batchSize() " + this.size / batchSize);
                }
                long[] a = (long[])this.arrays.get(i);
                long first = a[0];
                if (first > test) {
                    return -1;
                }
                if (i == ct - 1) {
                    if (this.size > batchSize) {
                        lastIndex = this.size % batchSize - 1;
                        if (lastIndex == -1) {
                            lastIndex = batchSize - 1;
                        }
                    } else {
                        lastIndex = this.size - 1;
                    }
                } else {
                    lastIndex = a.length - 1;
                }
                assert (lastIndex >= 0) : "Bad last index on array " + i + " of " + ct + " size " + this.size + " arrays.batchSize() " + batchSize + " array should be " + i * batchSize + " thru " + (i + 1) * batchSize + " got lastIndex " + lastIndex;
                long last = a[lastIndex];
                assert (last > first) : "Last <= first: " + first + " -> " + last + " in " + ct + " lastIndex " + lastIndex + " size " + a.length + " arr " + Arrays.toString(a);
                if (test == first) {
                    return i * batchSize;
                }
                if (test == last) {
                    return i * batchSize + lastIndex;
                }
                if (test <= first || test >= last) continue;
                int localIndex = Arrays.binarySearch(a, 0, lastIndex, test);
                if (localIndex >= 0) {
                    return i * batchSize + localIndex;
                }
                return -1;
            }
        } else {
            for (int i = 0; i < ct; ++i) {
                int offset;
                long[] a = (long[])this.arrays.get(i);
                for (int j = 0; j < a.length && (offset = i * batchSize + j) <= this.size; ++j) {
                    long check = a[j];
                    if (check != test) continue;
                    return i * batchSize + j;
                }
            }
        }
        return -1;
    }

    @Override
    public int indexOf(Object o) {
        if (o instanceof Number) {
            long test = ((Number)o).longValue();
            return this.indexOf(test);
        }
        return -1;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Long) {
            long test = ((Number)o).longValue();
            return this.contains(test);
        }
        return false;
    }

    @Override
    public boolean contains(long test) {
        return this.indexOf(test) >= 0;
    }

    private long[] arrayForIndex(int index, boolean grow) {
        int arrayIndex = index / this.arrays.batchSize();
        long ct = this.arrays.size();
        long[] result = null;
        if (ct < (long)(arrayIndex + 1)) {
            if (!grow) {
                return null;
            }
            while (this.arrays.size() < arrayIndex + 1) {
                result = (long[])this.arrays.addOne();
            }
        } else {
            return (long[])this.arrays.get(arrayIndex);
        }
        return result;
    }

    @Override
    public Long get(int index) {
        return this.getLong(index);
    }

    @Override
    public long getLong(int index) {
        long[] arr = this.arrayForIndex(index, false);
        if (arr == null) {
            throw new IndexOutOfBoundsException("No array for index " + index + " in " + this.arrays.size() + " with batch size " + this.arrays.batchSize() + ": " + this);
        }
        return arr[index % this.arrays.batchSize()];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        block0: for (int i = 0; i < this.arrays.size(); ++i) {
            long[] els = (long[])this.arrays.get(i);
            for (int j = 0; j < els.length; ++j) {
                int offset = i * this.arrays.batchSize() + j;
                if (offset == this.size) break block0;
                long l = els[j];
                hashCode = 31 * hashCode + Long.hashCode(l);
            }
        }
        return hashCode;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.size * 5 + 2).append('[');
        block0: for (int i = 0; i < this.arrays.size(); ++i) {
            long[] els = (long[])this.arrays.get(i);
            for (int j = 0; j < els.length; ++j) {
                int offset = i * this.arrays.batchSize() + j;
                if (offset == this.size) break block0;
                long l = els[j];
                if (i != 0 || j != 0) {
                    sb.append(',');
                }
                sb.append(l);
            }
        }
        return sb.append(']').toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof LongListImpl) {
            LongListImpl ll = (LongListImpl)o;
            if (ll.size() != this.size) {
                return false;
            }
            if (ll.arrays.batchSize() == this.arrays.batchSize()) {
                int ix = 0;
                Iterator a = this.arrays.iterator();
                Iterator b = ll.arrays.iterator();
                while (a.hasNext()) {
                    if (ix + this.arrays.batchSize() > this.size) {
                        long[] aa = (long[])a.next();
                        long[] bb = (long[])b.next();
                        int max = this.size % this.arrays.batchSize();
                        for (int i = 0; i < max; ++i) {
                            if (aa[i] == bb[i]) continue;
                            return false;
                        }
                    } else if (!Arrays.equals((long[])a.next(), (long[])b.next())) {
                        return false;
                    }
                    if ((ix += this.arrays.batchSize()) <= this.size) continue;
                }
                return true;
            }
            for (int i = 0; i < this.size; ++i) {
                long b;
                long a = this.getLong(i);
                if (a == (b = ll.getLong(i))) continue;
                return false;
            }
            return true;
        }
        if (o instanceof List) {
            List ll = (List)o;
            if (ll.size() != this.size) {
                return false;
            }
            for (int i = 0; i < this.arrays.size(); ++i) {
                int offset;
                long[] els = (long[])this.arrays.get(i);
                for (int j = 0; j < els.length && (offset = i * this.arrays.batchSize() + j) != this.size; ++j) {
                    long value = els[j];
                    Object item = ll.get(offset);
                    if (item instanceof Long) {
                        Long l = (Long)item;
                        if (value == l) continue;
                        return false;
                    }
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (o instanceof Long) {
                long val = (Long)o;
                if (this.indexOf(val) >= 0) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public void forEach(Consumer<? super Long> action) {
        this.forEach(action::accept);
    }

    @Override
    public LongListImpl subList(int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return new LongListImpl();
        }
        if (fromIndex == 0 && toIndex == this.size) {
            return new LongListImpl(this);
        }
        if (fromIndex % this.arrays.batchSize() == 0) {
            int firstArray = fromIndex / this.arrays.batchSize();
            ArrayList<long[]> nue = new ArrayList<long[]>();
            for (int i = firstArray; i < this.arrays.size(); ++i) {
                long[] curr = (long[])this.arrays.get(i);
                nue.add(Arrays.copyOf(curr, curr.length));
                if (i * this.arrays.batchSize() > toIndex - fromIndex) break;
            }
            int newSize = toIndex - fromIndex;
            return new LongListImpl(nue, newSize, this.arrays.batchSize(), this.sorted);
        }
        LongListImpl nue = new LongListImpl(this.arrays.batchSize());
        for (int i = fromIndex; i < toIndex; ++i) {
            nue.add(this.getLong(i));
        }
        return nue;
    }

    @Override
    public void forEach(LongConsumer consumer) {
        for (int i = this.arrays.size() - 1; i >= 0; --i) {
            int offset;
            long[] ll = (long[])this.arrays.get(i);
            int base = i * this.arrays.batchSize();
            for (int j = ll.length - 1; j >= 0 && (offset = i * base + j) < this.size; --j) {
                long curr = ll[j];
                consumer.accept(curr);
            }
        }
    }

    @Override
    public void replaceAll(UnaryOperator<Long> operator) {
        for (int i = this.arrays.size() - 1; i >= 0; --i) {
            int offset;
            long[] ll = (long[])this.arrays.get(i);
            int base = i * this.arrays.batchSize();
            for (int j = ll.length - 1; j >= 0 && (offset = i * base + j) < this.size; --j) {
                long curr = ll[j];
                ll[j] = (Long)operator.apply(curr);
            }
        }
    }

    @Override
    public Iterator<Long> iterator() {
        return new PrimitiveIterator.OfLong(){
            int ix = -1;

            @Override
            public boolean hasNext() {
                return this.ix < LongListImpl.this.size - 1;
            }

            @Override
            public Long next() {
                return this.nextLong();
            }

            @Override
            public long nextLong() {
                return LongListImpl.this.getLong(++this.ix);
            }
        };
    }

    @Override
    public int lastIndexOf(long val) {
        if (this.sorted) {
            return this.indexOf(val);
        }
        for (int i = this.arrays.size() - 1; i >= 0; --i) {
            long[] ll = (long[])this.arrays.get(i);
            for (int j = ll.length - 1; j >= 0; --j) {
                long curr;
                int offset = i * this.arrays.batchSize() + j;
                if (offset >= this.size || val != (curr = ll[j])) continue;
                return offset;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (!(o instanceof Long)) {
            return -1;
        }
        long val = (Long)o;
        return this.lastIndexOf(val);
    }
}

