/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.collections;

import com.mastfrog.util.collections.Pair;
import com.mastfrog.util.preconditions.Exceptions;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;

public interface MapBuilder2<T, R> {
    public ValueBuilder<T, R> map(T var1);

    default public MapBuilder2<T, R> map(T key, R val) {
        return this.map(key).to(val);
    }

    public Map<T, R> build();

    public Map<T, R> buildLinkedHashMap();

    public Map<T, R> buildImmutableMap();

    default public MapBuilder2<T, R> maybeMap(BooleanSupplier testCondition, Consumer<MapBuilder2<T, R>> callIfTrue) {
        if (testCondition.getAsBoolean()) {
            callIfTrue.accept(this);
        }
        return this;
    }

    default public HashingMapBuilder<T, R> toHashingMapBuilder(String algorithm) {
        return this.toHashingMapBuilder(algorithm, o -> o.toString().getBytes(StandardCharsets.UTF_8));
    }

    default public HashingMapBuilder<T, R> toHashingMapBuilder(String algorithm, final Function<Object, byte[]> toBytes) {
        try {
            final MessageDigest digest = MessageDigest.getInstance(algorithm);
            final MapBuilder2 outer = this;
            return new HashingMapBuilder<T, R>(){
                byte[] digested;

                @Override
                public byte[] hash() {
                    if (this.digested == null) {
                        this.digested = digest.digest();
                    }
                    return this.digested;
                }

                @Override
                public String hashString() {
                    Base64.Encoder enc = Base64.getEncoder();
                    return enc.encodeToString(this.hash());
                }

                @Override
                public HashingMapBuilder.HashingValueBuilder<T, R> map(final T key) {
                    if (this.digested != null) {
                        throw new IllegalStateException("Hash already computed");
                    }
                    final 1 otr = this;
                    return new HashingMapBuilder.HashingValueBuilder<T, R>(){

                        @Override
                        public HashingMapBuilder<T, R> to(R value) {
                            if (digested != null) {
                                throw new IllegalStateException("Hash already computed");
                            }
                            outer.map(key).to(value);
                            digest.update((byte[])toBytes.apply(key));
                            digest.update((byte)58);
                            digest.update((byte[])toBytes.apply(value));
                            digest.update((byte)47);
                            return otr;
                        }

                        @Override
                        public Map<T, R> finallyTo(R value) {
                            this.to(value);
                            return outer.build();
                        }

                        @Override
                        public Pair<Map<T, R>, byte[]> toAndBuild(R val) {
                            MapBuilder2 result = this.to(val);
                            return Pair.from(result.build()).apply(this.hash());
                        }
                    };
                }

                @Override
                public Map<T, R> build() {
                    this.hash();
                    return outer.build();
                }

                @Override
                public Map<T, R> buildLinkedHashMap() {
                    return outer.buildLinkedHashMap();
                }

                @Override
                public Map<T, R> buildImmutableMap() {
                    return outer.buildImmutableMap();
                }
            };
        }
        catch (NoSuchAlgorithmException ex) {
            return (HashingMapBuilder)Exceptions.chuck((Throwable)ex);
        }
    }

    public static interface HashingMapBuilder<T, R>
    extends MapBuilder2<T, R> {
        public byte[] hash();

        public String hashString();

        @Override
        public HashingValueBuilder<T, R> map(T var1);

        public static interface HashingValueBuilder<T, R>
        extends ValueBuilder<T, R> {
            @Override
            public HashingMapBuilder<T, R> to(R var1);

            public Pair<Map<T, R>, byte[]> toAndBuild(R var1);

            default public Pair<Map<T, R>, String> toAndBuildWithStringHash(R val) {
                Base64.Encoder enc = Base64.getEncoder();
                return this.toAndBuild(val).transformB(enc::encodeToString);
            }
        }
    }

    public static interface ValueBuilder<T, R> {
        public MapBuilder2<T, R> to(R var1);

        public Map<T, R> finallyTo(R var1);
    }
}

