/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.collections;

import com.mastfrog.util.collections.MapBuilder2;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

final class MapBuilder2Impl<T, R>
implements MapBuilder2<T, R> {
    private final Map<T, R> data = new LinkedHashMap<T, R>();

    MapBuilder2Impl() {
    }

    @Override
    public MapBuilder2.ValueBuilder<T, R> map(T key) {
        return new ValueBuilderImpl(key, this);
    }

    @Override
    public Map<T, R> build() {
        return new HashMap<T, R>(this.data);
    }

    @Override
    public Map<T, R> buildLinkedHashMap() {
        return new LinkedHashMap<T, R>(this.data);
    }

    @Override
    public Map<T, R> buildImmutableMap() {
        if (this.data.isEmpty()) {
            return Collections.emptyMap();
        }
        if (this.data.size() == 1) {
            Map.Entry<T, R> e = this.data.entrySet().iterator().next();
            return Collections.singletonMap(e.getKey(), e.getValue());
        }
        return Collections.unmodifiableMap(this.build());
    }

    static class ValueBuilderImpl<T, R>
    implements MapBuilder2.ValueBuilder<T, R> {
        private final T key;
        private final MapBuilder2Impl<T, R> parent;

        ValueBuilderImpl(T key, MapBuilder2Impl<T, R> parent) {
            this.key = key;
            this.parent = parent;
        }

        @Override
        public MapBuilder2<T, R> to(R value) {
            ((MapBuilder2Impl)this.parent).data.put(this.key, value);
            return this.parent;
        }

        @Override
        public Map<T, R> finallyTo(R value) {
            return this.to(value).build();
        }
    }
}

