/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.collections;

import com.mastfrog.util.collections.ConcatenatedIterables;
import com.mastfrog.util.strings.Strings;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

final class MergeIterables<T>
implements ConcatenatedIterables<T> {
    private final List<Iterable<T>> all = new LinkedList<Iterable<T>>();

    MergeIterables(Iterable<T> a, Iterable<T> b) {
        this.all.add(a);
        this.all.add(b);
    }

    MergeIterables(Iterable<T> a, Iterable<T> b, Iterable<T> c) {
        this.all.add(a);
        this.all.add(b);
        this.all.add(c);
    }

    @SafeVarargs
    MergeIterables(Iterable<T> ... iterables) {
        this.all.addAll(Arrays.asList(iterables));
    }

    MergeIterables(Iterable<Iterable<T>> all) {
        for (Iterable<T> iter : all) {
            this.all.add(iter);
        }
    }

    MergeIterables() {
    }

    @Override
    public void add(Iterable<T> iterable) {
        this.all.add(iterable);
    }

    @Override
    public Iterator<T> iterator() {
        if (this.all.isEmpty()) {
            return Collections.emptyIterator();
        }
        if (this.all.size() == 1) {
            return this.all.iterator().next().iterator();
        }
        LinkedList iterators = new LinkedList();
        for (Iterable<T> iterable : this.all) {
            iterators.add(iterable.iterator());
        }
        return new MergeIterator(iterators);
    }

    public String toString() {
        return Strings.join((String)", ", (Iterable)this);
    }

    private static final class MergeIterator<T>
    implements Iterator<T> {
        private final LinkedList<Iterator<T>> iterators;

        MergeIterator(LinkedList<Iterator<T>> iterators) {
            this.iterators = iterators;
        }

        private Iterator<T> iter() {
            if (this.iterators.isEmpty()) {
                return null;
            }
            Iterator<T> result = this.iterators.get(0);
            if (!result.hasNext()) {
                this.iterators.remove(0);
                return this.iter();
            }
            return result;
        }

        @Override
        public boolean hasNext() {
            Iterator<T> curr = this.iter();
            return curr != null && curr.hasNext();
        }

        @Override
        public T next() {
            Iterator<T> iter = this.iter();
            if (iter == null) {
                throw new NoSuchElementException();
            }
            return iter.next();
        }

        @Override
        public void remove() {
            Iterator<T> iter = this.iter();
            if (iter == null) {
                throw new NoSuchElementException();
            }
            iter.remove();
        }
    }
}

