/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.collections;

import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

final class MergeListIterator<T>
implements ListIterator<T> {
    private final ListIterator<ListIterator<T>> iterators;
    private ListIterator<T> curr;
    private int index;

    MergeListIterator(List<ListIterator<T>> iterators) {
        this(iterators.listIterator());
    }

    MergeListIterator(ListIterator<ListIterator<T>> iterators) {
        this.iterators = iterators;
        this.curr = iterators.hasNext() ? iterators.next() : Collections.emptyListIterator();
    }

    ListIterator<T> toNext() {
        ListIterator<T> last = this.curr;
        int ct = 0;
        while (this.curr != null && !this.curr.hasNext()) {
            ListIterator<T> listIterator = this.curr = this.iterators.hasNext() ? this.iterators.next() : this.curr;
            if (ct == 0 && this.curr == last && this.iterators.hasNext()) {
                this.curr = this.iterators.next();
            }
            if (this.curr == last) break;
            last = this.curr;
            ++ct;
        }
        return this.curr;
    }

    ListIterator<T> toPrev() {
        ListIterator<T> last = this.curr;
        int ct = 0;
        while (this.curr != null && !this.curr.hasPrevious()) {
            ListIterator<T> listIterator = this.curr = this.iterators.hasPrevious() ? this.iterators.previous() : this.curr;
            if (ct == 0 && this.curr == last && this.iterators.hasPrevious()) {
                this.curr = this.iterators.previous();
            }
            if (this.curr == last) break;
            last = this.curr;
            ++ct;
        }
        return this.curr;
    }

    private ListIterator<T> iter(boolean forward) {
        if (this.curr == null) {
            this.curr = this.toNext();
        }
        if (this.curr != null) {
            boolean usable;
            boolean bl = usable = forward ? this.curr.hasNext() : this.curr.hasPrevious();
            if (!usable) {
                this.curr = forward ? this.toNext() : this.toPrev();
            }
        }
        return this.curr;
    }

    @Override
    public boolean hasNext() {
        ListIterator<T> it = this.iter(true);
        return it != null && it.hasNext();
    }

    @Override
    public T next() {
        ListIterator<T> iter = this.iter(true);
        if (iter == null) {
            throw new NoSuchElementException(this.index + " out of bounds");
        }
        ++this.index;
        return (T)iter.next();
    }

    @Override
    public void remove() {
        ListIterator<T> iter = this.curr == null ? this.iter(true) : this.curr;
        iter.remove();
    }

    @Override
    public boolean hasPrevious() {
        return this.iter(false).hasPrevious();
    }

    @Override
    public T previous() {
        ListIterator<T> iter = this.iter(false);
        if (iter == null) {
            throw new NoSuchElementException(this.index + " out of bounds");
        }
        --this.index;
        return iter.previous();
    }

    @Override
    public int nextIndex() {
        return this.index;
    }

    @Override
    public int previousIndex() {
        return this.index - 1;
    }

    @Override
    public void set(T e) {
        if (this.curr == null) {
            this.curr = this.iter(true);
        }
        this.curr.set(e);
    }

    @Override
    public void add(T e) {
        throw new UnsupportedOperationException("Not supported.");
    }
}

