/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.collections;

import com.mastfrog.util.collections.CollectionUtils;
import com.mastfrog.util.collections.MergeListIterator;
import com.mastfrog.util.preconditions.Checks;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;

final class MultiList<T>
extends AbstractList<T> {
    private final List<List<T>> lists;

    MultiList(List<List<T>> lists) {
        int mx = lists.size();
        for (int i = 0; i < mx; ++i) {
            if (lists.get(i) != null) continue;
            throw new IllegalArgumentException("List of lists contains a null at " + i);
        }
        this.lists = (List)Checks.notNull((String)"lists", lists);
    }

    MultiList(Collection<? extends Collection<T>> coll) {
        ArrayList<List> l = new ArrayList<List>(((Collection)Checks.notNull((String)"coll", coll)).size());
        for (Collection<T> c : coll) {
            if (c.isEmpty()) continue;
            l.add(c instanceof List ? (List<Object>)c : new ArrayList<T>(c));
        }
        this.lists = Collections.unmodifiableList(l);
    }

    @Override
    public T get(int index) {
        int total = this.lists.size();
        int offset = 0;
        for (int i = 0; i < total; ++i) {
            List<T> l = this.lists.get(i);
            int sz = l.size();
            if (index >= offset && index < offset + sz) {
                return l.get(index - offset);
            }
            offset += l.size();
        }
        throw new IndexOutOfBoundsException("Bad index " + index + " of " + this.size());
    }

    @Override
    public int size() {
        int result = 0;
        for (List<T> l : this.lists) {
            result += l.size();
        }
        return result;
    }

    @Override
    public Iterator<T> iterator() {
        return CollectionUtils.combine(CollectionUtils.transform(this.lists, List::iterator));
    }

    @Override
    public ListIterator<T> listIterator() {
        return new MergeListIterator(CollectionUtils.transform(this.lists, l -> l.listIterator()));
    }

    @Override
    public <A> A[] toArray(A[] a) {
        int max;
        int size = this.size();
        Class<?> type = a.getClass().getComponentType();
        if (a.length != size) {
            a = (Object[])Array.newInstance(type, size);
        }
        if ((max = this.lists.size()) == 0) {
            return a;
        }
        int pos = 0;
        for (int i = 0; i < max; ++i) {
            List<Object> l = this.lists.get(i);
            int lmx = l.size();
            Object[] temp = l.toArray((Object[])Array.newInstance(type, lmx));
            System.arraycopy(temp, 0, a, pos, temp.length);
            pos += temp.length;
        }
        return a;
    }

    @Override
    public boolean contains(Object o) {
        boolean result = false;
        for (List<T> l : this.lists) {
            if (!l.contains(o)) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        Iterator<T> e1 = this.iterator();
        Iterator e2 = ((List)o).iterator();
        while (e1.hasNext() && e2.hasNext()) {
            Object o2;
            T o1 = e1.next();
            if (Objects.equals(o1, o2 = e2.next())) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }
}

