/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.collections;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;

final class Pair<A, B> {
    public final A a;
    public final B b;

    public Pair(A a, B b) {
        this.a = a;
        this.b = b;
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + Objects.hashCode(this.a);
        hash = 89 * hash + Objects.hashCode(this.b);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Pair other = (Pair)obj;
        if (!Objects.equals(this.a, other.a)) {
            return false;
        }
        return Objects.equals(this.b, other.b);
    }

    public String toString() {
        return this.a + "," + this.b;
    }

    public <C> C apply(BiFunction<A, B, C> func) {
        return func.apply(this.a, this.b);
    }

    public Object[] toArray() {
        return new Object[]{this.a, this.b};
    }

    public static <A, B> Function<B, Pair<A, B>> from(A a) {
        return b -> new Pair<Object, Object>(a, b);
    }

    public <C> Pair<A, C> transformB(Function<B, C> func) {
        return new Pair<A, C>(this.a, func.apply(this.b));
    }

    public <C> Pair<C, B> transformA(Function<A, C> func) {
        return new Pair<C, B>(func.apply(this.a), this.b);
    }
}

