/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.collections;

import com.mastfrog.util.preconditions.Checks;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

final class ReversedList<T>
implements List<T> {
    private final List<T> del;

    public ReversedList(List<T> del) {
        Checks.notNull((String)"del", del);
        this.del = del;
    }

    List<T> delegate() {
        return this.del;
    }

    @Override
    public int size() {
        return this.del.size();
    }

    @Override
    public boolean isEmpty() {
        return this.del.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.del.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return new ReversedIterator<T>(this.del);
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    private <T> T[] ensureArraySize(T[] arr) {
        if (arr.length >= this.size()) {
            return arr;
        }
        return (Object[])Array.newInstance(arr.getClass().getComponentType(), this.size());
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        int sz = this.size();
        ts = this.ensureArraySize(ts);
        for (int i = 0; i < sz; ++i) {
            ts[i] = this.get(i);
        }
        return ts;
    }

    @Override
    public boolean add(T e) {
        this.del.add(0, e);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        return this.del.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> clctn) {
        return this.del.containsAll(clctn);
    }

    @Override
    public boolean addAll(Collection<? extends T> clctn) {
        if (clctn.isEmpty()) {
            return false;
        }
        boolean result = true;
        for (T obj : clctn) {
            this.del.add(0, obj);
        }
        return result;
    }

    @Override
    public boolean addAll(int i, Collection<? extends T> clctn) {
        return this.del.addAll(this.index(i), clctn);
    }

    @Override
    public boolean removeAll(Collection<?> clctn) {
        return this.del.removeAll(clctn);
    }

    @Override
    public boolean retainAll(Collection<?> clctn) {
        return this.del.retainAll(clctn);
    }

    @Override
    public void clear() {
        this.del.clear();
    }

    @Override
    public T get(int i) {
        return this.del.get(this.index(i));
    }

    @Override
    public T set(int i, T e) {
        return this.del.set(this.index(i), e);
    }

    @Override
    public void add(int i, T e) {
        this.del.add(this.index(i), e);
    }

    @Override
    public T remove(int i) {
        return this.del.remove(this.index(i));
    }

    @Override
    public int indexOf(Object o) {
        return this.index(this.del.lastIndexOf(o));
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.index(this.del.indexOf(o));
    }

    @Override
    public ListIterator<T> listIterator() {
        return new ReversedIterator<T>(this.del);
    }

    @Override
    public ListIterator<T> listIterator(int i) {
        return new ReversedIterator<T>(this.del, this.index(i) + 1);
    }

    @Override
    public List<T> subList(int i, int i1) {
        return new ReversedList<T>(this.del.subList(i, i1));
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof ReversedList && ((ReversedList)o).del.equals(this.del);
    }

    @Override
    public int hashCode() {
        return this.del.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (T o : this) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(o);
        }
        return sb.toString();
    }

    private int index(int i) {
        if (i < 0) {
            return i;
        }
        return this.size() - (i + 1);
    }

    private static class ReversedIterator<T>
    implements Iterator<T>,
    ListIterator<T> {
        private final List<T> l;
        private int ix;
        private final int size;

        public ReversedIterator(List<T> l) {
            this(l, l.size());
        }

        public ReversedIterator(List<T> l, int ix) {
            this.l = l;
            this.ix = ix;
            this.size = l.size();
        }

        private void check() {
            if (this.size != this.l.size()) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasNext() {
            return this.ix >= 1;
        }

        @Override
        public T next() {
            return this.l.get(--this.ix);
        }

        @Override
        public void remove() {
            this.l.remove(this.ix);
        }

        @Override
        public boolean hasPrevious() {
            this.check();
            return this.ix < this.size;
        }

        @Override
        public T previous() {
            this.check();
            return this.l.get(++this.ix);
        }

        @Override
        public int nextIndex() {
            return this.size - (this.ix + 1);
        }

        @Override
        public int previousIndex() {
            this.check();
            return this.size - (this.ix - 1);
        }

        @Override
        public void set(T e) {
            this.l.set(this.ix, e);
        }

        @Override
        public void add(T e) {
            this.l.add(0, e);
        }
    }
}

