/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.collections;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Consumer;

class SimpleWeakSet<T>
extends AbstractSet<T> {
    private final Map<T, Boolean> backingStore = new WeakHashMap<T, Boolean>();

    SimpleWeakSet() {
    }

    SimpleWeakSet(Collection<? extends T> other) {
        this.addAll(other);
    }

    @Override
    public String toString() {
        return this.backingStore.keySet().toString();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.backingStore.keySet().containsAll(c);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.backingStore.keySet().toArray(a);
    }

    @Override
    public Object[] toArray() {
        return this.backingStore.keySet().toArray();
    }

    @Override
    public boolean contains(Object o) {
        return this.backingStore.containsKey(o);
    }

    @Override
    public boolean isEmpty() {
        return this.backingStore.isEmpty();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.backingStore.keySet().forEach(action);
    }

    @Override
    public Iterator<T> iterator() {
        return this.backingStore.keySet().iterator();
    }

    @Override
    public void clear() {
        this.backingStore.clear();
    }

    @Override
    public int size() {
        return this.backingStore.size();
    }

    @Override
    public boolean add(T e) {
        if (e == null) {
            throw new IllegalArgumentException("Null argument to add");
        }
        Boolean result = this.backingStore.put(e, Boolean.TRUE);
        return result == null ? false : result;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        int oldSize = this.size();
        for (T t : c) {
            this.backingStore.put(t, Boolean.TRUE);
        }
        return this.size() != oldSize;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            if (o == null) continue;
            changed |= this.backingStore.remove(o).booleanValue();
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        HashSet<T> toRemove = new HashSet<T>();
        for (Map.Entry<T, Boolean> e : this.backingStore.entrySet()) {
            if (c.contains(e.getKey())) continue;
            toRemove.add(e.getKey());
        }
        return this.removeAll(toRemove);
    }

    @Override
    public boolean remove(Object o) {
        if (o != null) {
            return this.backingStore.remove(o) != null;
        }
        return false;
    }
}

