/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.collections;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;

final class SingleItemList<T>
implements List<T> {
    private T item;

    SingleItemList() {
    }

    SingleItemList(T item) {
        this.item = item;
    }

    @Override
    public int size() {
        return this.item == null ? 0 : 1;
    }

    @Override
    public boolean isEmpty() {
        return this.item == null;
    }

    @Override
    public boolean contains(Object o) {
        return Objects.equals(o, this.item);
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private boolean used;

            @Override
            public boolean hasNext() {
                return SingleItemList.this.item != null && !this.used;
            }

            @Override
            public void remove() {
                if (!this.used) {
                    throw new IndexOutOfBoundsException();
                }
                SingleItemList.this.item = null;
            }

            @Override
            public T next() {
                if (SingleItemList.this.item == null) {
                    throw new IndexOutOfBoundsException();
                }
                this.used = true;
                return SingleItemList.this.item;
            }
        };
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.item};
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a == null || a.length != 1) {
            Object[] result = (Object[])Array.newInstance(this.item.getClass(), 1);
            result[0] = this.item;
            return result;
        }
        a[0] = this.item;
        return a;
    }

    @Override
    public boolean add(T e) {
        if (this.item != null) {
            throw new IndexOutOfBoundsException("One item supported");
        }
        this.item = e;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        if (Objects.equals(this.item, o)) {
            this.item = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return c.size() == 1 && Objects.equals(this.item, c.iterator().next());
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        Iterator<T> iterator = c.iterator();
        if (iterator.hasNext()) {
            T t = iterator.next();
            return this.add(t);
        }
        return false;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        return this.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.item != null && c.contains(this.item)) {
            this.item = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.item != null && c.contains(this.item)) {
            return true;
        }
        this.item = null;
        return false;
    }

    @Override
    public void clear() {
        this.item = null;
    }

    @Override
    public T get(int index) {
        if (index == 0 && this.item != null) {
            return this.item;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public T set(int index, T element) {
        if (index > 0) {
            throw new IndexOutOfBoundsException(index + " out of range");
        }
        T old = this.item;
        if (index == 0) {
            this.item = element;
        }
        return old;
    }

    @Override
    public void add(int index, T element) {
        this.add(element);
    }

    @Override
    public T remove(int index) {
        if (index == 0 && this.item != null) {
            T old = this.item;
            this.item = null;
            return old;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int indexOf(Object o) {
        return Objects.equals(o, this.item) ? 0 : -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.indexOf(o) == 0 ? 0 : -1;
    }

    @Override
    public ListIterator<T> listIterator() {
        return Arrays.asList(this.item).listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return Arrays.asList(this.item).listIterator(index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return Arrays.asList(this.item).subList(fromIndex, toIndex);
    }

    @Override
    public int hashCode() {
        return Arrays.asList(this.item).hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof List) {
            List l = (List)o;
            if (l.isEmpty() && this.isEmpty()) {
                return true;
            }
            int sz = this.size();
            if (l.size() != sz) {
                return false;
            }
            return Objects.equals(this.get(0), l.get(0));
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString()).append("[");
        if (this.item != null) {
            sb.append(this.item);
        }
        sb.append(']');
        return sb.toString();
    }
}

