/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.collections;

import com.mastfrog.util.preconditions.Checks;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

final class SupplierMap<T, R>
implements Map<T, R> {
    private final Map<T, R> delegate;
    private final Supplier<R> supplier;

    SupplierMap(Supplier<R> supplier) {
        this.supplier = (Supplier)Checks.notNull((String)"supplier", supplier);
        this.delegate = new HashMap<T, R>();
    }

    SupplierMap(Supplier<R> supplier, Map<T, R> delegate) {
        this.supplier = (Supplier)Checks.notNull((String)"supplier", supplier);
        this.delegate = (Map)Checks.notNull((String)"delegate", delegate);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public R get(Object key) {
        R result = this.delegate.get(key);
        if (result == null) {
            result = this.supplier.get();
            this.delegate.put(key, result);
        }
        return result;
    }

    public R getIfPresent(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public R put(T key, R value) {
        return this.delegate.put(key, value);
    }

    @Override
    public R remove(Object key) {
        return this.delegate.remove(key);
    }

    @Override
    public void putAll(Map<? extends T, ? extends R> m) {
        this.delegate.putAll(m);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Set<T> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<R> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<T, R>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public R getOrDefault(Object key, R defaultValue) {
        return this.delegate.getOrDefault(key, defaultValue);
    }

    @Override
    public void forEach(BiConsumer<? super T, ? super R> action) {
        this.delegate.forEach(action);
    }

    @Override
    public void replaceAll(BiFunction<? super T, ? super R, ? extends R> function) {
        this.delegate.replaceAll(function);
    }

    @Override
    public R putIfAbsent(T key, R value) {
        return this.delegate.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.delegate.remove(key, value);
    }

    @Override
    public boolean replace(T key, R oldValue, R newValue) {
        return this.delegate.replace(key, oldValue, newValue);
    }

    @Override
    public R replace(T key, R value) {
        return this.delegate.replace(key, value);
    }

    @Override
    public R computeIfAbsent(T key, Function<? super T, ? extends R> mappingFunction) {
        return this.delegate.computeIfAbsent(key, mappingFunction);
    }

    @Override
    public R computeIfPresent(T key, BiFunction<? super T, ? super R, ? extends R> remappingFunction) {
        return this.delegate.computeIfPresent(key, remappingFunction);
    }

    @Override
    public R compute(T key, BiFunction<? super T, ? super R, ? extends R> remappingFunction) {
        return this.delegate.compute(key, remappingFunction);
    }

    @Override
    public R merge(T key, R value, BiFunction<? super R, ? super R, ? extends R> remappingFunction) {
        return this.delegate.merge(key, value, remappingFunction);
    }

    public String toString() {
        if (this.delegate.isEmpty()) {
            return "{}";
        }
        StringBuilder result = new StringBuilder(120).append("{");
        Iterator<Map.Entry<T, R>> it = this.delegate.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<T, R> e = it.next();
            result.append(e.getKey()).append(":").append(e.getValue());
            if (!it.hasNext()) continue;
            result.append(", ");
        }
        return result.append('}').toString();
    }
}

