/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.search;

import com.mastfrog.abstractions.list.LongIndexed;
import com.mastfrog.abstractions.list.LongIndexedResolvable;
import com.mastfrog.abstractions.list.LongResolvable;
import com.mastfrog.util.search.Bias;
import java.util.List;
import java.util.function.Function;
import java.util.function.LongFunction;
import java.util.function.ToLongFunction;

public class BinarySearch<T> {
    private final LongResolvable eval;
    private final LongIndexed<T> indexed;

    public BinarySearch(LongResolvable eval, LongIndexed<T> indexed) {
        this.eval = eval;
        this.indexed = indexed;
        assert (this.checkSorted());
    }

    public BinarySearch(LongResolvable eval, List<T> l) {
        this(eval, new ListWrap<T>(l));
    }

    public BinarySearch(ToLongFunction<? super Object> eval, long count, LongFunction<T> getter) {
        this(value -> eval.applyAsLong(value), new LongFunctionWrapper<T>(count, getter));
    }

    public BinarySearch(LongIndexedResolvable<T> res) {
        this(arg_0 -> res.indexOf(arg_0), res.size(), arg_0 -> res.forIndex(arg_0));
    }

    public static <R extends Number> BinarySearch<R> binarySearch(final LongFunction<R> indexer, final long count) {
        LongIndexedResolvable ix = new LongIndexedResolvable<R>(){

            public R forIndex(long index) {
                return (Number)indexer.apply(index);
            }

            public long size() {
                return count;
            }

            public long indexOf(Object obj) {
                return ((Number)obj).longValue();
            }
        };
        return new BinarySearch((LongResolvable)ix, ix);
    }

    public static <R extends Number> BinarySearch<R> binarySearch(final long count, final Function<Long, R> indexer) {
        Evaluator<Number> eval = Number::longValue;
        LongIndexed ix = new LongIndexed<R>(){

            public R forIndex(long index) {
                return (Number)indexer.apply(index);
            }

            public long size() {
                return count;
            }
        };
        return new BinarySearch(eval, ix);
    }

    private boolean checkSorted() {
        long val = Long.MIN_VALUE;
        long sz = this.indexed.size();
        for (long i = 0L; i < sz; ++i) {
            Object t = this.indexed.forIndex(i);
            long nue = this.eval.indexOf(t);
            if (val != Long.MIN_VALUE && nue < val) {
                throw new IllegalArgumentException("Collection is not sorted at " + i + " - " + this.indexed);
            }
            val = nue;
        }
        return true;
    }

    public long search(long value, Bias bias) {
        return this.search(0L, this.indexed.size() - 1L, value, bias);
    }

    public T match(T prototype, Bias bias) {
        long value = this.eval.indexOf(prototype);
        long index = this.search(value, bias);
        return (T)(index == -1L ? null : this.indexed.forIndex(index));
    }

    public T searchFor(long value, Bias bias) {
        long index = this.search(value, bias);
        return (T)(index == -1L ? null : this.indexed.forIndex(index));
    }

    private long search(long start, long end, long value, Bias bias) {
        long range = end - start;
        if (range == 0L) {
            return start;
        }
        if (range == 1L) {
            Object ahead = this.indexed.forIndex(end);
            Object behind = this.indexed.forIndex(start);
            long v1 = this.eval.indexOf(behind);
            long v2 = this.eval.indexOf(ahead);
            if (value == v1) {
                return start;
            }
            if (value == v2) {
                return end;
            }
            switch (bias) {
                case BACKWARD: {
                    if (v2 < value) {
                        return end;
                    }
                    if (v1 > value) {
                        return -1L;
                    }
                    return start;
                }
                case FORWARD: {
                    if (v1 > value) {
                        return start;
                    }
                    if (v2 < value) {
                        return -1L;
                    }
                    return end;
                }
                case NEAREST: {
                    if (v1 == value) {
                        return start;
                    }
                    if (v2 == value) {
                        return end;
                    }
                    if (Math.abs(v1 - value) < Math.abs(v2 - value)) {
                        return start;
                    }
                    return end;
                }
                case NONE: {
                    if (v1 == value) {
                        return start;
                    }
                    if (v2 == value) {
                        return end;
                    }
                    return -1L;
                }
            }
            throw new AssertionError((Object)bias);
        }
        long mid = start + range / 2L;
        long vm = this.eval.indexOf(this.indexed.forIndex(mid));
        if (value >= vm) {
            return this.search(mid, end, value, bias);
        }
        return this.search(start, mid, value, bias);
    }

    private static final class ListWrap<T>
    implements LongIndexed<T> {
        private final List<T> l;

        ListWrap(List<T> l) {
            this.l = l;
        }

        public T forIndex(long index) {
            return this.l.get((int)index);
        }

        public long size() {
            return this.l.size();
        }

        public String toString() {
            return super.toString() + '{' + this.l + '}';
        }
    }

    @Deprecated
    public static interface Indexed<T>
    extends LongIndexed<T> {
        public T get(long var1);

        public long size();
    }

    @Deprecated
    public static interface Evaluator<T>
    extends ToLongFunction<T>,
    LongResolvable {
        public long getValue(T var1);

        @Override
        default public long applyAsLong(T value) {
            return this.getValue(value);
        }

        default public long indexOf(Object obj) {
            return this.getValue(obj);
        }
    }

    private static final class LongFunctionWrapper<T>
    implements LongIndexed<T> {
        private final long count;
        private final LongFunction<T> getter;

        public LongFunctionWrapper(long count, LongFunction<T> getter) {
            this.count = count;
            this.getter = getter;
        }

        public T forIndex(long index) {
            return this.getter.apply(index);
        }

        public long size() {
            return this.count;
        }
    }
}

