/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.sort;

import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.sort.Swapper;

public final class Sort {
    public static <T> void biSort(int[] keys, T[] other, int size) {
        Sort.checkSizeInvariants(keys, other, size);
        Sort.multiSort(keys, size, Swapper.forArray(other));
    }

    public static <T> void biSort(double[] keys, T[] other, int size) {
        Sort.checkSizeInvariants(keys, other, size);
        Sort.multiSort(keys, size, Swapper.forArray(other));
    }

    public static <T> void biSort(float[] keys, T[] other, int size) {
        Sort.checkSizeInvariants(keys, other, size);
        Sort.multiSort(keys, size, Swapper.forArray(other));
    }

    public static <T> void biSort(long[] keys, T[] other, int size) {
        Sort.checkSizeInvariants(keys, other, size);
        Sort.multiSort(keys, size, Swapper.forArray(other));
    }

    public static <T> void biSort(short[] keys, T[] other, int size) {
        Sort.checkSizeInvariants(keys, other, size);
        Sort.multiSort(keys, size, Swapper.forArray(other));
    }

    public static void multiSort(int[] keys, int size, Swapper swapper) {
        Sort.checkSizeInvariant(keys, size);
        Sort._multiSort(keys, size, (Swapper)Checks.notNull((String)"swapper", (Object)swapper));
    }

    private static void _multiSort(int[] keys, int size, Swapper swapper) {
        if (size < 2) {
            return;
        }
        Sort.sortInts(keys, swapper, 0, size);
    }

    public static void multiSort(int[] keys, int fromIndex, int toIndex, Swapper swapper) {
        Sort.checkBoundsInvariant(keys, fromIndex, toIndex);
        Sort._multiSort(keys, fromIndex, toIndex, (Swapper)Checks.notNull((String)"swapper", (Object)swapper));
    }

    private static void _multiSort(int[] keys, int fromIndex, int toIndex, Swapper swapper) {
        Sort.sortInts(keys, swapper, fromIndex, toIndex - fromIndex);
    }

    public static void multiSort(long[] a, int fromIndex, int toIndex, Swapper swapper) {
        Sort.checkBoundsInvariant(a, fromIndex, toIndex);
        Sort._multiSort(a, fromIndex, toIndex, (Swapper)Checks.notNull((String)"swapper", (Object)swapper));
    }

    private static void _multiSort(long[] a, int fromIndex, int toIndex, Swapper swapper) {
        Sort.sortLongs(a, swapper, fromIndex, toIndex - fromIndex);
    }

    public static void multiSort(long[] keys, int size, Swapper swapper) {
        Sort.checkSizeInvariant(keys, size);
        Sort._multiSort(keys, size, (Swapper)Checks.notNull((String)"swapper", (Object)swapper));
    }

    private static void _multiSort(long[] keys, int size, Swapper swapper) {
        if (size < 2) {
            return;
        }
        Sort.sortLongs(keys, swapper, 0, size);
    }

    public static void multiSort(double[] keys, int fromIndex, int toIndex, Swapper swapper) {
        Sort.checkBoundsInvariant(keys, fromIndex, toIndex);
        Sort._multiSort(keys, fromIndex, toIndex, (Swapper)Checks.notNull((String)"swapper", (Object)swapper));
    }

    private static void _multiSort(double[] keys, int fromIndex, int toIndex, Swapper swapper) {
        Sort.sortDoubles(keys, swapper, fromIndex, toIndex - fromIndex);
    }

    public static void multiSort(double[] keys, int size, Swapper swapper) {
        Sort.checkSizeInvariant(keys, size);
        Sort._multiSort(keys, size, (Swapper)Checks.notNull((String)"swapper", (Object)swapper));
    }

    private static void _multiSort(double[] keys, int size, Swapper swapper) {
        if (size < 2) {
            return;
        }
        Sort.sortDoubles(keys, swapper, 0, size);
    }

    public static void multiSort(float[] keys, int size, Swapper swapper) {
        Sort.checkSizeInvariant(keys, size);
        Sort._multiSort(keys, size, (Swapper)Checks.notNull((String)"swapper", (Object)swapper));
    }

    private static void _multiSort(float[] keys, int size, Swapper swapper) {
        if (size < 2) {
            return;
        }
        Sort.sortFloats(keys, swapper, 0, size);
    }

    public static void multiSort(float[] keys, int fromIndex, int toIndex, Swapper swapper) {
        Sort.checkBoundsInvariant(keys, fromIndex, toIndex);
        Sort._multiSort(keys, fromIndex, toIndex, (Swapper)Checks.notNull((String)"swapper", (Object)swapper));
    }

    private static void _multiSort(float[] keys, int fromIndex, int toIndex, Swapper swapper) {
        Sort.sortFloats(keys, swapper, fromIndex, toIndex - fromIndex);
    }

    public static void multiSort(short[] keys, int size, Swapper swapper) {
        Sort.checkSizeInvariant(keys, size);
        Sort._multiSort(keys, size, (Swapper)Checks.notNull((String)"swapper", (Object)swapper));
    }

    private static void _multiSort(short[] keys, int size, Swapper swapper) {
        if (size < 2) {
            return;
        }
        Sort.sortShorts(keys, swapper, 0, size);
    }

    public static void multiSort(short[] keys, int fromIndex, int toIndex, Swapper swapper) {
        Sort.checkBoundsInvariant(keys, fromIndex, toIndex);
        Sort._multiSort(keys, fromIndex, toIndex, (Swapper)Checks.notNull((String)"swapper", (Object)swapper));
    }

    private static void _multiSort(short[] keys, int fromIndex, int toIndex, Swapper swapper) {
        Sort.sortShorts(keys, swapper, fromIndex, toIndex - fromIndex);
    }

    private static void sortInts(int[] x, Swapper swapper, int off, int len) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && x[j - 1] > x[j]; --j) {
                    Sort.swap(x, swapper, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = Sort.med3(x, l, l + s, l + 2 * s);
                m = Sort.med3(x, m - s, m, m + s);
                n = Sort.med3(x, n - 2 * s, n - s, n);
            }
            m = Sort.med3(x, l, m, n);
        }
        int v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && x[b] <= v) {
                if (x[b] == v) {
                    Sort.swap(x, swapper, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && x[c] >= v) {
                if (x[c] == v) {
                    Sort.swap(x, swapper, c, d--);
                }
                --c;
            }
            if (b > c) break;
            Sort.swap(x, swapper, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        Sort.vecswap(x, swapper, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        Sort.vecswap(x, swapper, b, n - s, s);
        s = b - a;
        if (s > 1) {
            Sort.sortInts(x, swapper, off, s);
        }
        if ((s = d - c) > 1) {
            Sort.sortInts(x, swapper, n - s, s);
        }
    }

    private static void swap(int[] x, Swapper swapper, int a, int b) {
        int t = x[a];
        x[a] = x[b];
        x[b] = t;
        swapper.swap(a, b);
    }

    private static void vecswap(int[] x, Swapper swapper, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            Sort.swap(x, swapper, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(int[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }

    private static void sortDoubles(double[] x, Swapper swapper, int off, int len) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && x[j - 1] > x[j]; --j) {
                    Sort.swap(x, swapper, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = Sort.med3(x, l, l + s, l + 2 * s);
                m = Sort.med3(x, m - s, m, m + s);
                n = Sort.med3(x, n - 2 * s, n - s, n);
            }
            m = Sort.med3(x, l, m, n);
        }
        double v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && x[b] <= v) {
                if (x[b] == v) {
                    Sort.swap(x, swapper, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && x[c] >= v) {
                if (x[c] == v) {
                    Sort.swap(x, swapper, c, d--);
                }
                --c;
            }
            if (b > c) break;
            Sort.swap(x, swapper, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        Sort.vecswap(x, swapper, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        Sort.vecswap(x, swapper, b, n - s, s);
        s = b - a;
        if (s > 1) {
            Sort.sortDoubles(x, swapper, off, s);
        }
        if ((s = d - c) > 1) {
            Sort.sortDoubles(x, swapper, n - s, s);
        }
    }

    private static void swap(double[] x, Swapper swapper, int a, int b) {
        double t = x[a];
        x[a] = x[b];
        x[b] = t;
        swapper.swap(a, b);
    }

    private static void vecswap(double[] x, Swapper swapper, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            Sort.swap(x, swapper, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(double[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }

    private static void sortFloats(float[] x, Swapper swapper, int off, int len) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && x[j - 1] > x[j]; --j) {
                    Sort.swap(x, swapper, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = Sort.med3(x, l, l + s, l + 2 * s);
                m = Sort.med3(x, m - s, m, m + s);
                n = Sort.med3(x, n - 2 * s, n - s, n);
            }
            m = Sort.med3(x, l, m, n);
        }
        float v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && x[b] <= v) {
                if (x[b] == v) {
                    Sort.swap(x, swapper, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && x[c] >= v) {
                if (x[c] == v) {
                    Sort.swap(x, swapper, c, d--);
                }
                --c;
            }
            if (b > c) break;
            Sort.swap(x, swapper, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        Sort.vecswap(x, swapper, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        Sort.vecswap(x, swapper, b, n - s, s);
        s = b - a;
        if (s > 1) {
            Sort.sortFloats(x, swapper, off, s);
        }
        if ((s = d - c) > 1) {
            Sort.sortFloats(x, swapper, n - s, s);
        }
    }

    private static void swap(float[] x, Swapper swapper, int a, int b) {
        float t = x[a];
        x[a] = x[b];
        x[b] = t;
        swapper.swap(a, b);
    }

    private static void vecswap(float[] x, Swapper swapper, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            Sort.swap(x, swapper, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(float[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }

    private static void sortLongs(long[] x, Swapper swapper, int off, int len) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && x[j - 1] > x[j]; --j) {
                    Sort.swap(x, swapper, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = Sort.med3(x, l, l + s, l + 2 * s);
                m = Sort.med3(x, m - s, m, m + s);
                n = Sort.med3(x, n - 2 * s, n - s, n);
            }
            m = Sort.med3(x, l, m, n);
        }
        long v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && x[b] <= v) {
                if (x[b] == v) {
                    Sort.swap(x, swapper, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && x[c] >= v) {
                if (x[c] == v) {
                    Sort.swap(x, swapper, c, d--);
                }
                --c;
            }
            if (b > c) break;
            Sort.swap(x, swapper, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        Sort.vecswap(x, swapper, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        Sort.vecswap(x, swapper, b, n - s, s);
        s = b - a;
        if (s > 1) {
            Sort.sortLongs(x, swapper, off, s);
        }
        if ((s = d - c) > 1) {
            Sort.sortLongs(x, swapper, n - s, s);
        }
    }

    private static void swap(long[] x, Swapper swapper, int a, int b) {
        long t = x[a];
        x[a] = x[b];
        x[b] = t;
        swapper.swap(a, b);
    }

    private static void vecswap(long[] x, Swapper swapper, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            Sort.swap(x, swapper, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(long[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }

    private static void sortShorts(short[] x, Swapper swapper, int off, int len) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && x[j - 1] > x[j]; --j) {
                    Sort.swap(x, swapper, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = Sort.med3(x, l, l + s, l + 2 * s);
                m = Sort.med3(x, m - s, m, m + s);
                n = Sort.med3(x, n - 2 * s, n - s, n);
            }
            m = Sort.med3(x, l, m, n);
        }
        short v = x[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && x[b] <= v) {
                if (x[b] == v) {
                    Sort.swap(x, swapper, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && x[c] >= v) {
                if (x[c] == v) {
                    Sort.swap(x, swapper, c, d--);
                }
                --c;
            }
            if (b > c) break;
            Sort.swap(x, swapper, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        Sort.vecswap(x, swapper, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        Sort.vecswap(x, swapper, b, n - s, s);
        s = b - a;
        if (s > 1) {
            Sort.sortShorts(x, swapper, off, s);
        }
        if ((s = d - c) > 1) {
            Sort.sortShorts(x, swapper, n - s, s);
        }
    }

    private static void swap(short[] x, Swapper swapper, int a, int b) {
        short t = x[a];
        x[a] = x[b];
        x[b] = t;
        swapper.swap(a, b);
    }

    private static void vecswap(short[] x, Swapper swapper, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            Sort.swap(x, swapper, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(short[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }

    private static <T> void checkSizeInvariants(int[] keys, T[] other, int size) {
        Checks.notNull((String)"keys", (Object)keys);
        Checks.notNull((String)"other", other);
        Checks.nonNegative((String)"size", (int)size);
        if (keys.length < size) {
            throw new IllegalArgumentException("Number array length " + keys.length + " < sort limit " + size);
        }
        if (other.length < size) {
            throw new IllegalArgumentException("Associated array length " + other.length + "< sort limit " + size);
        }
    }

    private static <T> void checkSizeInvariants(double[] keys, T[] other, int size) {
        Checks.notNull((String)"keys", (Object)keys);
        Checks.notNull((String)"other", other);
        Checks.nonNegative((String)"size", (int)size);
        if (keys.length < size) {
            throw new IllegalArgumentException("Number array length " + keys.length + " < sort limit " + size);
        }
        if (other.length < size) {
            throw new IllegalArgumentException("Associated array length " + other.length + "< sort limit " + size);
        }
    }

    private static <T> void checkSizeInvariants(long[] keys, T[] other, int size) {
        Checks.notNull((String)"keys", (Object)keys);
        Checks.notNull((String)"other", other);
        Checks.nonNegative((String)"size", (int)size);
        if (keys.length < size) {
            throw new IllegalArgumentException("Number array length " + keys.length + " < sort limit " + size);
        }
        if (other.length < size) {
            throw new IllegalArgumentException("Associated array length " + other.length + "< sort limit " + size);
        }
    }

    private static <T> void checkSizeInvariants(float[] keys, T[] other, int size) {
        Checks.notNull((String)"keys", (Object)keys);
        Checks.notNull((String)"other", other);
        Checks.nonNegative((String)"size", (int)size);
        if (keys.length < size) {
            throw new IllegalArgumentException("Number array length " + keys.length + " < sort limit " + size);
        }
        if (other.length < size) {
            throw new IllegalArgumentException("Associated array length " + other.length + "< sort limit " + size);
        }
    }

    private static <T> void checkSizeInvariants(short[] keys, T[] other, int size) {
        Checks.notNull((String)"keys", (Object)keys);
        Checks.nonNegative((String)"size", (int)size);
        Checks.notNull((String)"other", other);
        if (keys.length < size) {
            throw new IllegalArgumentException("Number array length " + keys.length + " < sort limit " + size);
        }
        if (other.length < size) {
            throw new IllegalArgumentException("Associated array length " + other.length + "< sort limit " + size);
        }
    }

    private static void checkSizeInvariant(int[] keys, int size) {
        Checks.notNull((String)"keys", (Object)keys);
        Checks.nonNegative((String)"size", (int)size);
        if (keys.length < size) {
            throw new IllegalArgumentException("Number array length " + keys.length + " < sort limit " + size);
        }
    }

    private static void checkSizeInvariant(double[] keys, int size) {
        Checks.notNull((String)"keys", (Object)keys);
        Checks.nonNegative((String)"size", (int)size);
        if (keys.length < size) {
            throw new IllegalArgumentException("Number array length " + keys.length + " < sort limit " + size);
        }
    }

    private static void checkSizeInvariant(long[] keys, int size) {
        Checks.notNull((String)"keys", (Object)keys);
        Checks.nonNegative((String)"size", (int)size);
        if (keys.length < size) {
            throw new IllegalArgumentException("Number array length " + keys.length + " < sort limit " + size);
        }
    }

    private static void checkSizeInvariant(float[] keys, int size) {
        Checks.notNull((String)"keys", (Object)keys);
        Checks.nonNegative((String)"size", (int)size);
        if (keys.length < size) {
            throw new IllegalArgumentException("Number array length " + keys.length + " < sort limit " + size);
        }
    }

    private static void checkSizeInvariant(short[] keys, int size) {
        Checks.notNull((String)"keys", (Object)keys);
        Checks.nonNegative((String)"size", (int)size);
        if (keys.length < size) {
            throw new IllegalArgumentException("Number array length " + keys.length + " < sort limit " + size);
        }
    }

    private static void checkBoundsInvariant(int[] keys, int from, int to) {
        Checks.notNull((String)"keys", (Object)keys);
        Checks.nonNegative((String)"from", (int)from);
        if (to < from) {
            throw new IllegalArgumentException("End index " + to + " < start " + from);
        }
    }

    private static void checkBoundsInvariant(double[] keys, int from, int to) {
        Checks.notNull((String)"keys", (Object)keys);
        Checks.nonNegative((String)"from", (int)from);
        if (to < from) {
            throw new IllegalArgumentException("End index " + to + " < start " + from);
        }
    }

    private static void checkBoundsInvariant(float[] keys, int from, int to) {
        Checks.notNull((String)"keys", (Object)keys);
        Checks.nonNegative((String)"from", (int)from);
        if (to < from) {
            throw new IllegalArgumentException("End index " + to + " < start " + from);
        }
    }

    private static void checkBoundsInvariant(long[] keys, int from, int to) {
        Checks.notNull((String)"keys", (Object)keys);
        Checks.nonNegative((String)"from", (int)from);
        if (to < from) {
            throw new IllegalArgumentException("End index " + to + " < start " + from);
        }
    }

    private static void checkBoundsInvariant(short[] keys, int from, int to) {
        Checks.notNull((String)"keys", (Object)keys);
        Checks.nonNegative((String)"from", (int)from);
        if (to < from) {
            throw new IllegalArgumentException("End index " + to + " < start " + from);
        }
    }

    private Sort() {
        throw new AssertionError();
    }
}

