/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.file;

import java.nio.CharBuffer;
import java.util.Spliterator;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;

final class CharBuffersCharSequence
implements CharSequence {
    private final CharBuffer[] buffers;
    private int length = -1;

    public CharBuffersCharSequence(CharBuffer[] buffers) {
        this.buffers = buffers;
    }

    @Override
    public int length() {
        if (this.length == -1) {
            int result = 0;
            for (int i = 0; i < this.buffers.length; ++i) {
                result += this.buffers[i].length();
            }
            this.length = result;
        }
        return this.length;
    }

    private int[] bufferIndexOfPosition(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Negative index " + index);
        }
        int pos = 0;
        for (int i = 0; i < this.buffers.length; ++i) {
            int len = this.buffers[i].length();
            if (index >= pos && index < pos + len) {
                return new int[]{i, pos};
            }
            pos += len;
        }
        return new int[]{-1, -1};
    }

    @Override
    public char charAt(int index) {
        int[] bi = this.bufferIndexOfPosition(index);
        if (bi[0] == -1) {
            throw new IndexOutOfBoundsException(index + " of " + this.length());
        }
        CharBuffer buf = this.buffers[bi[0]];
        int offset = index - bi[1];
        return buf.charAt(offset);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    @Override
    public IntStream chars() {
        return StreamSupport.intStream(this.spliterator(), false);
    }

    private Spliterator.OfInt spliterator() {
        return new Spliterator.OfInt(){
            private int bufferIndex = 0;
            private int indexInBuffer = -1;

            @Override
            public Spliterator.OfInt trySplit() {
                return this;
            }

            @Override
            public boolean tryAdvance(IntConsumer action) {
                CharBuffer buf = null;
                while (this.bufferIndex < CharBuffersCharSequence.this.buffers.length) {
                    buf = CharBuffersCharSequence.this.buffers[this.bufferIndex];
                    ++this.indexInBuffer;
                    if (this.indexInBuffer < buf.length()) break;
                    ++this.bufferIndex;
                    this.indexInBuffer = -1;
                    buf = null;
                }
                if (buf != null) {
                    action.accept(CharBuffersCharSequence.this.buffers[this.bufferIndex].charAt(this.indexInBuffer));
                    return true;
                }
                return false;
            }

            @Override
            public long estimateSize() {
                return CharBuffersCharSequence.this.length();
            }

            @Override
            public int characteristics() {
                return 1296;
            }
        };
    }

    @Override
    public String toString() {
        char[] c = new char[this.length()];
        int ix = 0;
        for (int i = 0; i < this.buffers.length; ++i) {
            int l = this.buffers[i].length();
            for (int j = 0; j < l; ++j) {
                c[ix++] = this.buffers[i].charAt(j);
            }
        }
        return new String(c);
    }

    public int hashCode() {
        if (this.length() == 0) {
            return 0;
        }
        int result = 0;
        for (int i = 0; i < this.buffers.length; ++i) {
            int l = this.buffers[i].length();
            for (int j = 0; j < l; ++j) {
                result = 31 * result + this.buffers[i].charAt(j);
            }
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof CharSequence) {
            CharSequence cs = (CharSequence)o;
            int len = this.length();
            if (len != cs.length()) {
                return false;
            }
            int ix = 0;
            for (int i = 0; i < this.buffers.length; ++i) {
                int l = this.buffers[i].length();
                for (int j = 0; j < l; ++j) {
                    char c = this.buffers[i].charAt(j);
                    if (cs.charAt(ix++) == c) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

