/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.file;

import com.mastfrog.function.throwing.io.IOFunction;
import com.mastfrog.util.streams.ContinuousLineStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;

final class Tail
implements IOFunction<Predicate<CharSequence>, Runnable> {
    private final Executor exec;
    private final Path path;
    private final int bufferSize;
    private final Charset charset;

    Tail(Executor exec, Path path, int bufferSize, Charset charset) throws IOException {
        this.exec = exec;
        this.path = path;
        this.bufferSize = bufferSize;
        this.charset = charset;
    }

    public Runnable watch(Predicate<CharSequence> lineConsumer) throws IOException {
        WatchService watch = this.path.getFileSystem().newWatchService();
        WatchKey key = this.path.getParent().register(watch, StandardWatchEventKinds.ENTRY_MODIFY);
        ContinuousLineStream stream = ContinuousLineStream.of(this.path.toFile(), this.bufferSize, this.charset);
        Canceller cancel = new Canceller(key);
        this.exec.execute(() -> {
            try {
                this.watch(cancel, watch, key, stream, lineConsumer);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (IOException ex) {
                Logger.getLogger(Tail.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        return cancel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void watch(Canceller canceller, WatchService watch, WatchKey key, ContinuousLineStream stream, Predicate<CharSequence> lineConsumer) throws InterruptedException, IOException {
        canceller.setThread();
        try {
            int tightLoopCount = 0;
            long lastLoop = System.currentTimeMillis();
            long polls = 0L;
            while (true) {
                if (canceller.isCancelled()) {
                    return;
                }
                while (stream.hasMoreLines()) {
                    if (!lineConsumer.test(stream.nextLine())) {
                        return;
                    }
                    if (!canceller.isCancelled()) continue;
                    return;
                }
                if (canceller.isCancelled()) {
                    return;
                }
                long now = System.currentTimeMillis();
                long elapsed = now - lastLoop;
                if (elapsed <= 1L) {
                    if (++tightLoopCount > 15) {
                        tightLoopCount = 0;
                        Thread.sleep(10L);
                    }
                } else {
                    tightLoopCount = 0;
                }
                lastLoop = now;
                WatchKey k = watch.take();
                k.pollEvents();
                boolean foundOurFile = false;
                for (WatchEvent<?> e : k.pollEvents()) {
                    if (e.kind() == StandardWatchEventKinds.ENTRY_MODIFY) {
                        Path p = (Path)e.context();
                        if (!this.path.equals(p) && !this.path.getFileName().equals(p)) continue;
                        foundOurFile = true;
                        break;
                    }
                    if (e.kind() != CoderResult.OVERFLOW) continue;
                    foundOurFile = true;
                    break;
                }
                if (!foundOurFile) {
                    k.reset();
                } else {
                    Thread.yield();
                    if (canceller.isCancelled()) {
                        return;
                    }
                    while (stream.hasMoreLines()) {
                        if (canceller.isCancelled()) {
                            return;
                        }
                        if (lineConsumer.test(stream.nextLine())) continue;
                        return;
                    }
                    boolean valid = k.reset();
                    if (!valid) {
                        break;
                    }
                }
                ++polls;
            }
        }
        finally {
            canceller.setCancelled();
            try {
                key.cancel();
            }
            finally {
                try {
                    watch.close();
                }
                finally {
                    stream.close();
                }
            }
        }
    }

    public Runnable apply(Predicate<CharSequence> a) throws IOException {
        return this.watch(a);
    }

    private static class Canceller
    implements Runnable {
        private final AtomicBoolean cancelled = new AtomicBoolean();
        private Thread thread;
        private final WatchKey key;

        Canceller(WatchKey key) {
            this.key = key;
        }

        void setCancelled() {
            this.cancelled.set(true);
            this.key.cancel();
        }

        boolean isCancelled() {
            return this.cancelled.get() || !this.key.isValid();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancel() {
            Thread t;
            Canceller canceller = this;
            synchronized (canceller) {
                t = this.thread;
            }
            if (this.cancelled.compareAndSet(false, true)) {
                if (t != null) {
                    t.interrupt();
                }
                this.key.cancel();
            }
        }

        synchronized void setThread() {
            if (this.cancelled.get()) {
                Thread.currentThread().interrupt();
                return;
            }
            this.thread = Thread.currentThread();
        }

        @Override
        public void run() {
            this.cancel();
        }
    }
}

