/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.path;

import com.mastfrog.util.path.UnixPath;
import com.mastfrog.util.preconditions.Checks;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Consumer;

public class ComponentUPath
implements UnixPath {
    private static final String[] EMPTY = new String[0];
    static final ComponentUPath EMPTY_PATH = new ComponentUPath(false);
    static final ComponentUPath EMPTY_PATH_ABS = new ComponentUPath(true);
    private final String[] components;
    private final boolean absolute;
    private String stringValue;
    private int hashCode;
    private boolean normChecked;
    private boolean norm;

    String infoString() {
        StringBuilder sb = new StringBuilder().append("ComponentUPath{").append(System.identityHashCode(this)).append(" absolute ").append(this.absolute).append(" components " + this.components.length).append(" {");
        for (int i = 0; i < this.components.length; ++i) {
            String c = this.components[i];
            sb.append('\'').append(c).append('\'');
            if (i == this.components.length - 1) continue;
            sb.append(", ");
        }
        return sb.append(')').toString();
    }

    ComponentUPath() {
        this(EMPTY, false);
    }

    ComponentUPath(boolean abs) {
        this(EMPTY, abs);
    }

    ComponentUPath(ComponentUPath orig, boolean abs) {
        this.components = orig.components;
        this.absolute = abs;
    }

    ComponentUPath(String[] components, boolean absolute) {
        this.components = components;
        this.absolute = absolute;
        ComponentUPath.sanityCheck(components);
    }

    ComponentUPath(String single) {
        this(new String[]{single}, false);
    }

    ComponentUPath(String path, char sep) {
        this(ComponentUPath.toComponents(new String[]{path}, sep), path.length() > 0 && path.charAt(0) == sep);
    }

    ComponentUPath(String first, char sep, String ... more) {
        String[] all;
        if (more.length == 0) {
            all = new String[]{first};
        } else {
            all = new String[more.length + 1];
            all[0] = first;
            System.arraycopy(more, 0, all, 1, more.length);
        }
        this.components = ComponentUPath.toComponents(all, sep);
        ComponentUPath.sanityCheck(this.components);
        this.absolute = all.length > 0 && all[0].length() > 0 && all[0].charAt(0) == sep;
    }

    ComponentUPath(Path path) {
        this.components = ComponentUPath.toComponents(path);
        this.absolute = path.isAbsolute();
        ComponentUPath.sanityCheck(this.components);
    }

    ComponentUPath(Path a, Path ... more) {
        this.components = more.length == 0 ? ComponentUPath.toComponents(a) : ComponentUPath.toComponents(a, more);
        this.absolute = a.isAbsolute();
    }

    static void sanityCheck(String[] s) {
        boolean asserts = true;
        if (asserts) {
            for (int i = 0; i < s.length; ++i) {
                if (s[i] == null) {
                    throw new IllegalArgumentException("Null element at " + i + " in " + Arrays.toString(s));
                }
                for (int j = 0; j < s[i].length(); ++j) {
                    char c = s[i].charAt(j);
                    if (c == File.separatorChar) {
                        throw new IllegalArgumentException("Component at " + i + " contains " + File.separatorChar + ": " + s[i]);
                    }
                    if (c != '\u0000') continue;
                    throw new IllegalArgumentException("Component at " + i + " is nul (0) char");
                }
            }
        }
    }

    static ComponentUPath of(Path path) {
        return path.getNameCount() == 0 ? EMPTY_PATH : new ComponentUPath(path);
    }

    static ComponentUPath of(Path path, Path ... more) {
        return path.getNameCount() == 0 ? EMPTY_PATH : new ComponentUPath(path, more);
    }

    static ComponentUPath of(String path) {
        return ((String)Checks.notNull((String)"path", (Object)path)).isEmpty() ? EMPTY_PATH : (File.separator.equals(path) ? EMPTY_PATH_ABS : new ComponentUPath(path, File.separatorChar));
    }

    static ComponentUPath of(String path, String ... more) {
        if (more.length == 0) {
            return ComponentUPath.of(path);
        }
        return new ComponentUPath(path, File.separatorChar, more);
    }

    static ComponentUPath ofUnixPaths(String path, String ... more) {
        if (more.length == 0) {
            return ComponentUPath.of(path);
        }
        return new ComponentUPath(path, '/', more);
    }

    static ComponentUPath ofUnixPath(String path) {
        if (path.isEmpty()) {
            return EMPTY_PATH;
        }
        if ("/".equals(path)) {
            return EMPTY_PATH_ABS;
        }
        return new ComponentUPath(path, '/');
    }

    static String[] toComponents(Path first, Path[] more) {
        ArrayList<String> result = new ArrayList<String>(first.getNameCount() + more.length + 16);
        for (Path sub : first) {
            result.add(sub.toString());
        }
        for (Path p : more) {
            for (Path sub : p) {
                result.add(sub.toString());
            }
        }
        return result.toArray(new String[result.size()]);
    }

    static String[] toComponents(Path path) {
        if (path instanceof ComponentUPath) {
            return ((ComponentUPath)path).components;
        }
        ArrayList<String> all = new ArrayList<String>(path.getNameCount());
        for (Path p : path) {
            all.add(p.toString());
        }
        return all.toArray(new String[all.size()]);
    }

    static String[] toComponents(String[] all, char sep) {
        if (all.length == 0) {
            return EMPTY;
        }
        if (all.length == 1 && all[0].indexOf(sep) < 0) {
            return all;
        }
        ArrayList<String> result = new ArrayList<String>(Math.max(all.length * 2, 30));
        StringBuilder scratch = new StringBuilder(72);
        for (String curr : all) {
            int len = curr.length();
            for (int i = 0; i < len; ++i) {
                char c = curr.charAt(i);
                if (c == sep) {
                    if (scratch.length() <= 0) continue;
                    String comp = scratch.toString();
                    scratch.setLength(0);
                    result.add(comp);
                    continue;
                }
                scratch.append(c);
            }
            if (scratch.length() <= 0) continue;
            String comp = scratch.toString();
            scratch.setLength(0);
            result.add(comp);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public ComponentUPath toRelativePath() {
        if (this.absolute) {
            return new ComponentUPath(this.components, false);
        }
        return this;
    }

    @Override
    public String toString() {
        if (this.stringValue == null) {
            this.stringValue = this.toString('/');
        }
        return this.stringValue;
    }

    @Override
    public Iterator<Path> iterator() {
        if (!this.absolute && this.components.length == 0) {
            return Collections.singleton(EMPTY_PATH).iterator();
        }
        return new It(this.components);
    }

    @Override
    public String toString(char sep) {
        StringBuilder sb = new StringBuilder();
        if (this.absolute) {
            sb.append(sep);
        }
        for (int i = 0; i < this.components.length; ++i) {
            sb.append(this.components[i]);
            if (i == this.components.length - 1) continue;
            sb.append(sep);
        }
        return sb.toString();
    }

    @Override
    public Path toRealPath(LinkOption ... options) throws IOException {
        return Paths.get(this.toString(), new String[0]).toRealPath(options);
    }

    @Override
    public ComponentUPath toAbsolutePath() {
        if (this.absolute) {
            return this;
        }
        Path p = Paths.get(".", new String[0]).toAbsolutePath().normalize();
        return ComponentUPath.of(p, this);
    }

    private static boolean equalPaths(ComponentUPath query, Path other) {
        if (other instanceof ComponentUPath) {
            ComponentUPath o = (ComponentUPath)other;
            return o.absolute == query.absolute && Arrays.equals(query.components, o.components);
        }
        boolean abs = other.isAbsolute();
        if (abs == query.absolute) {
            Object[] comps = ComponentUPath.toComponents(other);
            return Arrays.equals(query.components, comps);
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.components.length == 0 || this.components.length == 1 && this.components[0].isEmpty();
    }

    @Override
    public ComponentUPath relativize(Path other) {
        if (ComponentUPath.equalPaths(this, other)) {
            return EMPTY_PATH;
        }
        if (this.isEmpty()) {
            return ComponentUPath.of(other);
        }
        if (this.isAbsolute() != other.isAbsolute()) {
            throw new IllegalArgumentException("'other' is different type of Path");
        }
        String[] comps = other instanceof ComponentUPath ? ((ComponentUPath)other).components : ComponentUPath.toComponents(other);
        int lastCommonComponent = -1;
        int i = 0;
        while (i < Math.min(comps.length, this.components.length) && this.components[i].equals(comps[i])) {
            lastCommonComponent = i++;
        }
        if (lastCommonComponent == this.components.length - 1) {
            int newSize = comps.length - (lastCommonComponent + 1);
            String[] items = new String[newSize];
            System.arraycopy(comps, comps.length - newSize, items, 0, newSize);
            return ComponentUPath.forItems(items, false);
        }
        if (lastCommonComponent == comps.length - 1) {
            Object[] items = new String[this.components.length - (lastCommonComponent + 1)];
            Arrays.fill(items, "..");
            return ComponentUPath.forItems((String[])items, false);
        }
        if (lastCommonComponent >= 0) {
            int dotDots = this.components.length - (lastCommonComponent + 1);
            int addedComponents = comps.length - (lastCommonComponent + 1);
            Object[] items = new String[dotDots + addedComponents];
            Arrays.fill(items, "..");
            int srcPos = comps.length - dotDots;
            if (comps.length > this.components.length) {
                srcPos -= comps.length - this.components.length;
            }
            int destLength = items.length - dotDots;
            try {
                System.arraycopy(comps, srcPos, items, dotDots, destLength);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                ArrayIndexOutOfBoundsException ex2 = new ArrayIndexOutOfBoundsException("Copying from array of " + comps.length + " into array of " + items.length + " srcPos " + srcPos + " destPos " + dotDots + " destLength " + destLength + " lastCommonComponent " + lastCommonComponent + " addedComponents " + addedComponents + " relativizing " + other + " into " + this);
                ex2.initCause(ex);
                throw ex2;
            }
            return ComponentUPath.forItems((String[])items, false);
        }
        Object[] items = new String[this.components.length + comps.length];
        Arrays.fill(items, 0, this.components.length, "..");
        System.arraycopy(comps, 0, items, this.components.length, items.length - this.components.length);
        return ComponentUPath.forItems((String[])items, false);
    }

    static ComponentUPath forItems(String[] items, boolean abs) {
        return items.length == 0 || items.length == 1 && "".equals(items[0]) ? (abs ? EMPTY_PATH_ABS : EMPTY_PATH) : new ComponentUPath(ComponentUPath.trimTrailingEmpty(items), abs);
    }

    static String[] trimTrailingEmpty(String[] items) {
        while (items.length > 0 && items[items.length - 1].isEmpty()) {
            items = Arrays.copyOf(items, items.length - 1);
        }
        return items;
    }

    @Override
    public Path toNativePath() {
        return this.toSystemPath();
    }

    @Override
    public boolean isNormalized() {
        for (String comp : this.components) {
            if (!".".equals(comp) && !"..".equals(comp)) continue;
            return false;
        }
        return true;
    }

    private String lastRealNameComponent() {
        int ct = this.components.length;
        if (ct == 0) {
            return "";
        }
        String nm = this.components[ct - 1];
        if (".".equals(nm) || "..".equals(nm)) {
            ComponentUPath up = this.normalize();
            ct = up.components.length;
            if (ct == 0) {
                return "";
            }
            nm = up.components[ct - 1];
        }
        return nm;
    }

    @Override
    public String extension() {
        String nm = this.lastRealNameComponent();
        int ix = nm.lastIndexOf(46);
        if (ix < 1 || ix == nm.length() - 1) {
            return "";
        }
        return nm.substring(ix + 1);
    }

    @Override
    public String rawName() {
        String nm = this.lastRealNameComponent();
        int ix = nm.lastIndexOf(46);
        if (ix < 1 || ix == nm.length() - 1) {
            return nm;
        }
        return nm.substring(0, ix);
    }

    @Override
    public boolean isExtension(String ext) {
        if (((String)Checks.notNull((String)"ext", (Object)ext)).length() == 0 || this.components.length == 0) {
            return false;
        }
        String nm = this.lastRealNameComponent();
        if (ext.charAt(0) == '.') {
            return nm.endsWith(ext);
        }
        int ix = nm.lastIndexOf(46);
        if (ix < 1 || ix == nm.length() - 1) {
            return false;
        }
        if (nm.length() - ix < ext.length()) {
            return false;
        }
        return ext.equals(nm.substring(ix + 1));
    }

    @Override
    public ComponentUPath resolveSibling(String other) {
        if (((String)Checks.notNull((String)"other", (Object)other)).isEmpty()) {
            return this.getParent();
        }
        int ix = other.indexOf(47);
        if (ix < 0) {
            String[] newComps = Arrays.copyOf(this.components, this.components.length);
            newComps[newComps.length - 1] = other;
            ComponentUPath.sanityCheck(newComps);
            return new ComponentUPath(newComps, this.absolute);
        }
        String[] otherComps = ComponentUPath.toComponents(new String[]{other}, '/');
        ComponentUPath.sanityCheck(otherComps);
        String[] newComps = ComponentUPath.concatLessTail(this.components, otherComps);
        ComponentUPath.sanityCheck(newComps);
        return new ComponentUPath(newComps, this.absolute);
    }

    @Override
    public ComponentUPath resolve(String other) {
        if (((String)Checks.notNull((String)"other", (Object)other)).isEmpty()) {
            return this;
        }
        int ix = other.indexOf(47);
        if (ix < 0) {
            String[] newComps = Arrays.copyOf(this.components, this.components.length + 1);
            newComps[newComps.length - 1] = other;
            return new ComponentUPath(newComps, this.absolute);
        }
        String[] otherComps = ComponentUPath.toComponents(new String[]{other}, '/');
        String[] newComps = ComponentUPath.concat(this.components, otherComps);
        return new ComponentUPath(newComps, this.absolute);
    }

    @Override
    public UnixPath resolve(Path other) {
        if (other.isAbsolute()) {
            if (other instanceof UnixPath) {
                return (UnixPath)other;
            }
            return new ComponentUPath(other);
        }
        String[] comps = other instanceof ComponentUPath ? ((ComponentUPath)other).components : ComponentUPath.toComponents(other);
        return new ComponentUPath(ComponentUPath.concat(this.components, comps), this.absolute);
    }

    @Override
    public ComponentUPath normalize() {
        if (this.components.length == 0) {
            return this;
        }
        if (this.normChecked && this.norm) {
            return this;
        }
        this.normChecked = true;
        this.norm = true;
        for (String s : this.components) {
            if (!".".equals(s) && !"..".equals(s) && !s.isEmpty()) continue;
            this.norm = false;
            break;
        }
        if (this.norm) {
            return this;
        }
        Object[] nulledRemovals = Arrays.copyOf(this.components, this.components.length);
        int removedCount = 0;
        for (int i = nulledRemovals.length - 1; i >= 0; --i) {
            String c = nulledRemovals[i];
            if (c != null && ".".equals(c)) {
                nulledRemovals[i] = null;
                ++removedCount;
                continue;
            }
            if (c == null || !"..".equals(c)) continue;
            int firstPrecedingNonDotDot = -1;
            for (int j = i - 1; j >= 0; --j) {
                String c1 = nulledRemovals[j];
                if (c1 == null || "..".equals(c1) || ".".equals(c1)) continue;
                firstPrecedingNonDotDot = j;
                break;
            }
            if (firstPrecedingNonDotDot < 0) break;
            nulledRemovals[i] = null;
            nulledRemovals[firstPrecedingNonDotDot] = null;
            removedCount += 2;
        }
        if (removedCount == 0) {
            this.norm = true;
            return this;
        }
        assert (nulledRemovals.length - removedCount >= 0) : "Weird result norm " + this + " len " + nulledRemovals.length + " removed " + removedCount;
        Object[] newComponents = new String[nulledRemovals.length - removedCount];
        int cursor = 0;
        for (int i = 0; i < nulledRemovals.length; ++i) {
            if (nulledRemovals[i] == null) continue;
            assert (cursor < newComponents.length) : "out of range " + cursor + " origLen " + nulledRemovals.length + " removed " + removedCount + " in " + Arrays.toString(nulledRemovals) + " with " + Arrays.toString(newComponents) + " at " + i + " for '" + this.toString() + "'";
            newComponents[cursor++] = nulledRemovals[i];
        }
        return new ComponentUPath((String[])newComponents, this.absolute);
    }

    @Override
    public ComponentUPath resolveSibling(Path other) {
        String[] comps = ComponentUPath.toComponents(other);
        return new ComponentUPath(ComponentUPath.concatLessTail(this.components, comps), this.absolute);
    }

    static String[] concat(String[] a, String[] b) {
        if (a.length == 0) {
            return b;
        }
        if (b.length == 0) {
            return a;
        }
        String[] result = new String[a.length + b.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }

    static String[] concatLessTail(String[] a, String[] b) {
        if (a.length == 0) {
            return b;
        }
        if (b.length == 0 && a.length != 0) {
            return Arrays.copyOf(a, a.length - 1);
        }
        if (a.length == 0 && b.length == 0) {
            return EMPTY;
        }
        String[] result = new String[a.length + b.length - 1];
        System.arraycopy(a, 0, result, 0, a.length - 1);
        System.arraycopy(b, 0, result, a.length - 1, b.length);
        return result;
    }

    @Override
    public ComponentUPath subpath(int beginIndex, int endIndex) {
        if (beginIndex == endIndex) {
            return EMPTY_PATH;
        }
        String[] sub = new String[endIndex - beginIndex];
        System.arraycopy(this.components, beginIndex, sub, 0, endIndex - beginIndex);
        return new ComponentUPath(sub, beginIndex == 0 ? this.absolute : false);
    }

    @Override
    public UnixPath getName(int index) {
        if (this.components.length == 0 && !this.absolute && index == 0) {
            return EMPTY_PATH;
        }
        return new ComponentUPath(this.components[index]);
    }

    @Override
    public ComponentUPath getParent() {
        switch (this.components.length) {
            case 1: {
                return !this.absolute ? null : EMPTY_PATH_ABS;
            }
            case 0: {
                return null;
            }
        }
        String[] comps = Arrays.copyOf(this.components, this.components.length - 1);
        return new ComponentUPath(comps, this.absolute);
    }

    @Override
    public UnixPath getRoot() {
        if (this.absolute) {
            return null;
        }
        return EMPTY_PATH;
    }

    @Override
    public FileSystem getFileSystem() {
        return Paths.get(this.toString(File.separatorChar), new String[0]).getFileSystem();
    }

    @Override
    public boolean isAbsolute() {
        return this.absolute;
    }

    @Override
    public UnixPath getFileName() {
        return this.components.length == 0 ? (this.absolute ? null : EMPTY_PATH) : new ComponentUPath(this.components[this.components.length - 1]);
    }

    @Override
    public int getNameCount() {
        return this.components.length == 0 && !this.absolute ? 1 : this.components.length;
    }

    @Override
    public boolean startsWith(Path other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ComponentUPath) {
            String[] otherComponents = ((ComponentUPath)other).components;
            if (otherComponents.length > this.components.length) {
                return false;
            }
            for (int i = 0; i < otherComponents.length; ++i) {
                if (this.components[i] == otherComponents[i] || this.components[i].equals(otherComponents[i])) continue;
                return false;
            }
            return true;
        }
        int otherCount = other.getNameCount();
        if (otherCount > this.components.length) {
            return false;
        }
        for (int i = 0; i < otherCount; ++i) {
            Path sub = other.getName(i);
            if (this.components[i].equals(sub.toString())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean startsWith(String other) {
        int ix = other.indexOf(47);
        if (ix >= 0) {
            ComponentUPath up = new ComponentUPath(other, '/');
            return this.startsWith(up);
        }
        return this.components.length > 0 && this.components[0].equals(other);
    }

    @Override
    public boolean endsWith(Path other) {
        if (other instanceof ComponentUPath) {
            Object[] comps = ((ComponentUPath)other).components;
            if (comps.length > this.components.length) {
                return false;
            }
            if (comps.length == this.components.length) {
                return Arrays.equals(comps, this.components);
            }
            int myCounter = this.components.length - 1;
            int otherCounter = comps.length - 1;
            while (otherCounter >= 0) {
                if (!((String)comps[otherCounter]).equals(this.components[myCounter])) {
                    return false;
                }
                --otherCounter;
                --myCounter;
            }
            return true;
        }
        int nc = other.getNameCount();
        if (nc > this.components.length) {
            return false;
        }
        int myCounter = this.components.length - 1;
        int otherCounter = nc - 1;
        while (otherCounter >= 0) {
            String nm = other.getName(nc).toString();
            if (!nm.equals(this.components[myCounter])) {
                return false;
            }
            --otherCounter;
            --myCounter;
        }
        return true;
    }

    @Override
    public boolean endsWith(String other) {
        int ix = other.indexOf(47);
        if (ix < 0) {
            return this.components.length == 0 ? false : other.equals(this.components[this.components.length - 1]);
        }
        return this.endsWith(new ComponentUPath(other, '/'));
    }

    @Override
    public URI toUri() {
        return Paths.get(this.toString(), new String[0]).toUri();
    }

    @Override
    public File toFile() {
        return new File(this.toUri());
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        return this.toSystemPath().register(watcher, events, modifiers);
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        return this.toSystemPath().register(watcher, events);
    }

    Path toSystemPath() {
        return Paths.get(this.toString(File.separatorChar), new String[0]);
    }

    @Override
    public int visitNames(Consumer<String> consumer) {
        for (String comp : this.components) {
            consumer.accept(comp);
        }
        return this.components.length;
    }

    @Override
    public int compareTo(Path other) {
        return this.toString().compareTo(other.toString());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof Path) {
            return ComponentUPath.equalPaths(this, (Path)obj);
        }
        return false;
    }

    @Override
    public synchronized int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        this.hashCode = Arrays.hashCode(this.components) * (this.absolute ? 1 : 17);
        return this.hashCode;
    }

    static class It
    implements Iterator<Path> {
        private final String[] items;
        private int pos = -1;

        public It(String[] items) {
            this.items = items;
        }

        @Override
        public boolean hasNext() {
            return this.pos + 1 < this.items.length;
        }

        @Override
        public Path next() {
            String item = this.items[++this.pos];
            return new ComponentUPath(item);
        }
    }
}

