/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.path;

import com.mastfrog.util.path.UnixPaths;
import com.mastfrog.util.preconditions.Checks;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Consumer;

public interface UnixPath
extends Path {
    public static UnixPath empty() {
        return UnixPaths.empty();
    }

    public static UnixPath emptyAbsolute() {
        return UnixPaths.emptyAbsolute();
    }

    public static UnixPath get(String name) {
        return UnixPaths.get((String)Checks.notNull((String)"name", (Object)name));
    }

    public static UnixPath get(String name, String ... moreNames) {
        return UnixPaths.get((String)Checks.notNull((String)"name", (Object)name), moreNames);
    }

    public static UnixPath get(Path path) {
        return path instanceof UnixPath ? (UnixPath)path : UnixPaths.get((Path)Checks.notNull((String)"path", (Object)path));
    }

    public static UnixPath get(Path first, Path ... morePaths) {
        return UnixPaths.get((Path)Checks.notNull((String)"first", (Object)first), morePaths);
    }

    public UnixPath toRelativePath();

    @Override
    public UnixPath toAbsolutePath();

    @Override
    public UnixPath relativize(Path var1);

    @Override
    public UnixPath resolveSibling(String var1);

    @Override
    public UnixPath resolveSibling(Path var1);

    @Override
    public UnixPath resolve(String var1);

    @Override
    public UnixPath resolve(Path var1);

    @Override
    public UnixPath normalize();

    @Override
    public UnixPath subpath(int var1, int var2);

    @Override
    public UnixPath getName(int var1);

    @Override
    public UnixPath getParent();

    @Override
    public UnixPath getRoot();

    @Override
    public UnixPath getFileName();

    default public Path toNativePath() {
        int nc = this.getNameCount();
        StringBuilder sb = new StringBuilder(nc * 32);
        if (this.isAbsolute()) {
            sb.append(File.separatorChar);
        }
        for (int i = 0; i < nc; ++i) {
            UnixPath nm = this.getName(i);
            if (i == nc - 1) continue;
            sb.append(File.separatorChar);
        }
        return Paths.get(sb.toString(), new String[0]);
    }

    default public boolean isNormalized() {
        for (Path p : this) {
            if (!".".equals(p.toString()) && !"..".equals(p.toString())) continue;
            return false;
        }
        return true;
    }

    default public int visitNames(Consumer<String> consumer) {
        int result = 0;
        for (Path p : this) {
            consumer.accept(p.toString());
            ++result;
        }
        return result;
    }

    default public String extension() {
        int ix;
        int ct = this.getNameCount();
        if (ct == 0) {
            return "";
        }
        String nm = this.getName(ct - 1).toString();
        if (".".equals(nm) || "..".equals(nm)) {
            UnixPath up = this.normalize();
            ct = up.getNameCount();
            if (ct == 0) {
                return "";
            }
            nm = up.getName(ct - 1).toString();
        }
        if ((ix = nm.lastIndexOf(46)) < 1 || ix == nm.length() - 1) {
            return "";
        }
        return nm.substring(ix + 1);
    }

    default public String rawName() {
        int ix;
        int ct = this.getNameCount();
        if (ct == 0) {
            return "";
        }
        String nm = this.getName(ct - 1).toString();
        if (".".equals(nm) || "..".equals(nm)) {
            UnixPath up = this.normalize();
            ct = up.getNameCount();
            if (ct == 0) {
                return "";
            }
            nm = up.getName(ct - 1).toString();
        }
        if ((ix = nm.lastIndexOf(46)) < 1 || ix == nm.length() - 1) {
            return nm;
        }
        return nm.substring(0, ix);
    }

    default public boolean isExtension(String ext) {
        if (ext == null || ext.length() == 0) {
            return false;
        }
        if (ext.charAt(0) == '.') {
            ext = ext.substring(1);
        }
        return ext.equals(this.extension());
    }

    default public String toString(char separator) {
        StringBuilder sb = new StringBuilder();
        this.visitNames(name -> {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append((String)name);
        });
        return sb.toString();
    }

    default public boolean isEmpty() {
        int nc = this.getNameCount();
        switch (nc) {
            case 0: {
                return true;
            }
            case 1: {
                return this.rawName().isEmpty();
            }
        }
        return false;
    }
}

