/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.path;

import com.mastfrog.util.path.ComponentUPath;
import com.mastfrog.util.path.UnixPath;
import com.mastfrog.util.path.WrappedUPath;
import java.nio.file.Path;
import java.nio.file.Paths;

final class UnixPaths {
    static boolean unixChecked;
    static boolean systemUnixPaths;

    UnixPaths() {
    }

    static boolean isNativeUnixPaths() {
        return false;
    }

    static UnixPath empty() {
        if (UnixPaths.isNativeUnixPaths()) {
            return WrappedUPath.EMPTY_PATH;
        }
        return ComponentUPath.EMPTY_PATH;
    }

    static UnixPath emptyAbsolute() {
        if (UnixPaths.isNativeUnixPaths()) {
            return WrappedUPath.EMPTY_PATH_ABS;
        }
        return ComponentUPath.EMPTY_PATH_ABS;
    }

    static UnixPath get(String name) {
        if (UnixPaths.isNativeUnixPaths()) {
            return WrappedUPath.of(Paths.get(name, new String[0]));
        }
        return ComponentUPath.of(name);
    }

    static UnixPath get(String name, String ... moreNames) {
        if (UnixPaths.isNativeUnixPaths()) {
            return WrappedUPath.of(Paths.get(name, moreNames));
        }
        return ComponentUPath.ofUnixPaths(name, moreNames);
    }

    static UnixPath get(Path name) {
        if (UnixPaths.isNativeUnixPaths()) {
            return WrappedUPath.of(name);
        }
        return ComponentUPath.of(name);
    }

    static UnixPath get(Path name, Path ... moreNames) {
        if (UnixPaths.isNativeUnixPaths()) {
            String[] s = new String[moreNames.length];
            for (int i = 0; i < moreNames.length; ++i) {
                s[i] = moreNames[i].toString();
            }
            return WrappedUPath.of(Paths.get(name.toString(), s));
        }
        return ComponentUPath.of(name, moreNames);
    }
}

