/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.streams;

import com.mastfrog.util.file.FileUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

public final class ContinuousStringStream
implements AutoCloseable {
    private final FileChannel fileChannel;
    private final ByteBuffer readBuffer;

    public ContinuousStringStream(FileChannel fileChannel, int readBufferSizeInBytes) {
        this.fileChannel = fileChannel;
        this.readBuffer = ByteBuffer.allocateDirect(readBufferSizeInBytes);
    }

    public boolean isOpen() {
        return this.fileChannel.isOpen();
    }

    int bufferSize() {
        return this.readBuffer.capacity();
    }

    public synchronized long position() throws IOException {
        return this.fileChannel.position();
    }

    public synchronized void position(long pos) throws IOException {
        this.fileChannel.position(pos);
    }

    @Override
    public synchronized void close() throws IOException {
        this.fileChannel.close();
    }

    public synchronized int available() throws IOException {
        return (int)(this.fileChannel.size() - this.fileChannel.position());
    }

    public synchronized long skip(long l) throws IOException {
        this.fileChannel.position(this.fileChannel.position() + l);
        return this.fileChannel.position();
    }

    boolean hasContent() throws IOException {
        return this.available() > 0 || this.readBuffer.position() > 0;
    }

    long size() throws IOException {
        return this.fileChannel.size();
    }

    public synchronized CoderResult decode(CharBuffer target, CharsetDecoder charsetDecoder) throws IOException {
        int count;
        CoderResult[] r = new CoderResult[1];
        if (this.readBuffer.position() == this.readBuffer.capacity()) {
            this.readBuffer.clear();
        }
        if ((count = FileUtils.decode(this.fileChannel, this.readBuffer, target, charsetDecoder, true, r)) > 0) {
            target.flip();
        }
        return r[0];
    }

    static String escape(CharBuffer s) {
        s = s.duplicate();
        s.flip();
        StringBuilder sb = new StringBuilder();
        int start = s.position();
        int max = s.length();
        block3: for (int i = start; i < max; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\n': {
                    sb.append("\\n");
                    continue block3;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    static String escape(CharSequence s) {
        StringBuilder sb = new StringBuilder();
        int start = 0;
        int max = s.length();
        block3: for (int i = start; i < max; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\n': {
                    sb.append("\\n");
                    continue block3;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    static String escape(char c) {
        switch (c) {
            case '\n': {
                return "\\n";
            }
            case '\t': {
                return "\\t";
            }
            case '\u0000': {
                return "\\0";
            }
        }
        return "" + c;
    }
}

