/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.streams;

import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.preconditions.Exceptions;
import com.mastfrog.util.streams.HashingOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class HashingInputStream
extends FilterInputStream {
    private final InputStream wrapped;
    private final MessageDigest digest;
    private volatile boolean closed;

    HashingInputStream(String algorithm, InputStream wrapped) {
        super(wrapped);
        Checks.notNull((String)"wrapped", (Object)wrapped);
        Checks.notNull((String)"algorithm", (Object)algorithm);
        this.wrapped = wrapped;
        this.digest = HashingInputStream.createDigest(algorithm);
    }

    public static final MessageDigest createDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException ex) {
            return (MessageDigest)Exceptions.chuck((Throwable)ex);
        }
    }

    public static HashingInputStream sha1(InputStream in) {
        return new HashingInputStream("SHA-1", in);
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        super.close();
    }

    public byte[] getDigest() {
        if (!this.closed) {
            throw new IllegalStateException("Stream not closed");
        }
        return this.digest.digest();
    }

    @Override
    public int read() throws IOException {
        int result = this.wrapped.read();
        this.digest.update((byte)result);
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = this.wrapped.read(b, off, len);
        this.digest.update(b, off, len);
        return result;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return super.read(b);
    }

    @Override
    public int available() throws IOException {
        return this.wrapped.available();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.wrapped.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.wrapped.markSupported();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.wrapped.reset();
    }

    public String getHashAsString() throws IOException {
        if (!this.closed) {
            this.close();
        }
        byte[] bytes = this.getDigest();
        return HashingOutputStream.hashString(bytes);
    }
}

