/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.time;

import com.mastfrog.util.time.Interval;
import java.time.Instant;

public class MutableInterval
extends Interval {
    private Instant start;
    private Instant end;

    public MutableInterval(Instant start, Instant end) {
        this.start = start;
        this.end = end;
    }

    public MutableInterval(Interval other) {
        this.start = other.start();
        this.end = other.end();
    }

    public MutableInterval setStart(Instant start) {
        this.start = start;
        if (start.isAfter(this.end)) {
            this.start = this.end;
            this.end = start;
        }
        return this;
    }

    public MutableInterval setEnd(Instant end) {
        this.end = end;
        if (end.isAfter(this.start)) {
            this.end = this.start;
            this.start = end;
        }
        return this;
    }

    @Override
    public Instant start() {
        return this.start;
    }

    @Override
    public Instant end() {
        return this.end;
    }

    @Override
    public MutableInterval toMutableInterval() {
        return new MutableInterval(this);
    }
}

