/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.util.time;

import com.mastfrog.util.preconditions.Checks;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalField;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeUtil {
    private static final Pattern ISO_DURATION_PATTERN = Pattern.compile("^P.+$");
    public static final DateTimeFormatter ISO_INSTANT = new DateTimeFormatterBuilder().parseCaseInsensitive().appendInstant().toFormatter(Locale.US);
    public static final ZoneId GMT = ZoneId.of("GMT");
    public static final ZonedDateTime EPOCH = ZonedDateTime.ofInstant(Instant.ofEpochMilli(0L), GMT);
    public static final DateTimeFormatter ISO2822DateFormat = new DateTimeFormatterBuilder().appendText((TemporalField)ChronoField.DAY_OF_WEEK, TextStyle.SHORT_STANDALONE).appendLiteral(", ").appendText((TemporalField)ChronoField.DAY_OF_MONTH, TextStyle.FULL).appendLiteral(" ").appendText((TemporalField)ChronoField.MONTH_OF_YEAR, TextStyle.SHORT).appendLiteral(" ").appendText((TemporalField)ChronoField.YEAR, TextStyle.FULL).appendLiteral(" ").appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(":").appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(":").appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendLiteral(" ").appendOffsetId().toFormatter();
    private static final DateTimeFormatter SORTABLE_STRING_FORMAT = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('.').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral('-').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral('-').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendLiteral('-').appendValue(ChronoField.NANO_OF_SECOND, 9).toFormatter();
    private static final DateTimeFormatter GIT_LOG_FORMAT = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4).appendLiteral("-").appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral("-").appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendLiteral(' ').appendOffset("+HHMM", "+0000").parseLenient().toFormatter();
    private static final Pattern SORTABLE = Pattern.compile("^([\\d]{4}-[\\-\\d\\.]*\\.)(\\d+).*?");
    private static final NumberFormat TWO_DIGITS = new DecimalFormat("00");
    private static final NumberFormat THREE_DIGITS = new DecimalFormat("000");
    private static final NumberFormat MANY_DIGITS = new DecimalFormat("######00");
    public static final Duration MAX_DURATION = Duration.ofDays(106751991167300L);
    public static final Duration MAX_SAFE_DURATION = Duration.ofDays(106751991167300L).minus(Duration.ofDays(3650L));

    private TimeUtil() {
    }

    public static String toSortableStringFormat(ZonedDateTime zdt) {
        return zdt.format(SORTABLE_STRING_FORMAT);
    }

    public static String toGitLogFormat(ZonedDateTime zdt) {
        return zdt.format(GIT_LOG_FORMAT);
    }

    public static String toGitLogFormat(OffsetDateTime zdt) {
        return zdt.format(GIT_LOG_FORMAT);
    }

    public static ZonedDateTime fromGitLogFormat(String txt) {
        return ZonedDateTime.parse(txt, GIT_LOG_FORMAT);
    }

    public static ZonedDateTime fromSortableDateFormat(String s) {
        Matcher m = SORTABLE.matcher(s);
        if (m.matches()) {
            s = m.group(1) + m.group(2) + m.group(3);
        }
        return ZonedDateTime.parse(s, SORTABLE_STRING_FORMAT);
    }

    public static String toIsoFormat(ZonedDateTime zdt) {
        return zdt.format(ISO_INSTANT);
    }

    public static String toIsoFormat(LocalDateTime ldt) {
        ZoneOffset off = ZoneOffset.systemDefault().getRules().getOffset(ldt);
        Instant inst = ldt.toInstant(off);
        return TimeUtil.toIsoFormat(inst);
    }

    public static String toIsoFormat(long unixTimestamp) {
        return TimeUtil.toIsoFormat(TimeUtil.fromUnixTimestamp(unixTimestamp));
    }

    public static String toIsoFormat(OffsetDateTime odt) {
        return odt.format(ISO_INSTANT);
    }

    public static String toIsoFormat(Instant inst) {
        return TimeUtil.toIsoFormat(inst.atZone(GMT));
    }

    public static String toIsoFormat(Date date) {
        return TimeUtil.toIsoFormat(TimeUtil.toZonedDateTime(date));
    }

    public static ZonedDateTime fromIsoFormat(String fmt) {
        try {
            return ZonedDateTime.parse(fmt);
        }
        catch (DateTimeParseException ex) {
            return ZonedDateTime.ofInstant(OffsetDateTime.parse(fmt).toInstant(), GMT);
        }
    }

    public static long timestampFromIsoFormat(String fmt) {
        ZonedDateTime zdt = TimeUtil.fromIsoFormat(fmt);
        return TimeUtil.toUnixTimestamp(zdt);
    }

    public static OffsetDateTime offsetFromIsoFormat(String fmt) {
        ZonedDateTime zdt = TimeUtil.fromIsoFormat(fmt);
        return zdt.toOffsetDateTime();
    }

    public static LocalDateTime localFromIsoFormat(String fmt) {
        ZonedDateTime zdt = TimeUtil.fromIsoFormat(fmt);
        return LocalDateTime.ofInstant(zdt.toInstant(), ZoneOffset.systemDefault().getRules().getOffset(zdt.toInstant()));
    }

    public static LocalDateTime localFromIsoFormatGMT(String fmt) {
        ZonedDateTime zdt = TimeUtil.fromIsoFormat(fmt);
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(TimeUtil.toUnixTimestamp(zdt)), GMT);
    }

    public static Instant instantFromIsoFormat(String fmt) {
        return TimeUtil.fromIsoFormat(fmt).toInstant();
    }

    public static boolean equalsToSecondsOrAfter(ZonedDateTime reference, ZonedDateTime test) {
        if (reference == test) {
            return true;
        }
        if (reference == null && test == null) {
            return true;
        }
        if (reference == null != (test == null)) {
            return false;
        }
        long aStamp = reference.with(ChronoField.MILLI_OF_SECOND, 0L).toInstant().toEpochMilli();
        long bStamp = test.with(ChronoField.MILLI_OF_SECOND, 0L).toInstant().toEpochMilli();
        return bStamp >= aStamp;
    }

    public static boolean equalsToSeconds(ZonedDateTime a, ZonedDateTime b) {
        if (a == b) {
            return true;
        }
        if (a == null && b == null) {
            return true;
        }
        if (a == null != (b == null)) {
            return false;
        }
        return TimeUtil.equals(a.with(ChronoField.MILLI_OF_SECOND, 0L), b.with(ChronoField.MILLI_OF_SECOND, 0L));
    }

    public static boolean equalsToSeconds(OffsetDateTime a, OffsetDateTime b) {
        if (a == b) {
            return true;
        }
        if (a == null && b == null) {
            return true;
        }
        if (a == null != (b == null)) {
            return false;
        }
        return TimeUtil.equals(a.with(ChronoField.MILLI_OF_SECOND, 0L), b.with(ChronoField.MILLI_OF_SECOND, 0L));
    }

    public static boolean equalsToSeconds(Instant a, Instant b) {
        if (a == b) {
            return true;
        }
        if (a == null && b == null) {
            return true;
        }
        if (a == null != (b == null)) {
            return false;
        }
        return a.with(ChronoField.MILLI_OF_SECOND, 0L).toEpochMilli() == b.with(ChronoField.MILLI_OF_SECOND, 0L).toEpochMilli();
    }

    public static boolean equals(ZonedDateTime a, ZonedDateTime b) {
        if (a == b) {
            return true;
        }
        if (a == null && b == null) {
            return true;
        }
        if (a == null != (b == null)) {
            return false;
        }
        return TimeUtil.toUnixTimestamp(a) == TimeUtil.toUnixTimestamp(b);
    }

    public static boolean equals(OffsetDateTime a, OffsetDateTime b) {
        if (a == b) {
            return true;
        }
        if (a == null && b == null) {
            return true;
        }
        if (a == null != (b == null)) {
            return false;
        }
        return TimeUtil.toUnixTimestamp(a) == TimeUtil.toUnixTimestamp(b);
    }

    public static boolean equals(LocalDateTime a, LocalDateTime b) {
        if (a == b) {
            return true;
        }
        if (a == null && b == null) {
            return true;
        }
        if (a == null != (b == null)) {
            return false;
        }
        return TimeUtil.toUnixTimestampGMT(a) == TimeUtil.toUnixTimestampGMT(b);
    }

    public static boolean equals(OffsetDateTime a, ZonedDateTime b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null != (b == null)) {
            return false;
        }
        return TimeUtil.toUnixTimestamp(a) == TimeUtil.toUnixTimestamp(b);
    }

    public static boolean equals(LocalDateTime a, ZonedDateTime b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null != (b == null)) {
            return false;
        }
        return TimeUtil.toUnixTimestampSystemDefault(a) == TimeUtil.toUnixTimestamp(b);
    }

    public static boolean equals(LocalDateTime a, OffsetDateTime b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null != (b == null)) {
            return false;
        }
        return TimeUtil.toUnixTimestampSystemDefault(a) == TimeUtil.toUnixTimestamp(b);
    }

    public static ZonedDateTime toZonedDateTime(Date date) {
        return TimeUtil.fromUnixTimestamp(date.getTime());
    }

    public static Date toDate(ZonedDateTime time) {
        return new Date(time.toInstant().toEpochMilli());
    }

    public static Date toDate(OffsetDateTime odt) {
        return new Date(odt.toInstant().toEpochMilli());
    }

    public static Date toDate(LocalDateTime ldt) {
        ZoneOffset offset = ZoneOffset.systemDefault().getRules().getOffset(ldt);
        return new Date(ldt.toInstant(offset).toEpochMilli());
    }

    public static ZonedDateTime nowGMT() {
        return ZonedDateTime.now().with(ChronoField.MICRO_OF_SECOND, 0L).withZoneSameInstant(GMT);
    }

    public static ZonedDateTime fromHttpHeaderFormat(String iso2822dateTime) {
        Checks.notNull((String)"iso2822dateTime", (Object)iso2822dateTime);
        return ZonedDateTime.parse(iso2822dateTime, ISO2822DateFormat);
    }

    public static String toHttpHeaderFormat(long timestamp) {
        return TimeUtil.toHttpHeaderFormat(TimeUtil.fromUnixTimestamp(timestamp));
    }

    public static long timestampFromHttpHeaderFormat(String iso2822dateTime) {
        Checks.notNull((String)"iso2822dateTime", (Object)iso2822dateTime);
        return TimeUtil.toUnixTimestamp(TimeUtil.fromHttpHeaderFormat(iso2822dateTime));
    }

    public static long toUnixTimestamp(ZonedDateTime dateTime) {
        Checks.notNull((String)"dateTime", (Object)dateTime);
        return dateTime.toInstant().toEpochMilli();
    }

    public static long toUnixTimestampGMT(LocalDateTime dateTime) {
        Checks.notNull((String)"dateTime", (Object)dateTime);
        return dateTime.toInstant(GMT.getRules().getOffset(dateTime)).toEpochMilli();
    }

    public static long toUnixTimestampSystemDefault(LocalDateTime dateTime) {
        Checks.notNull((String)"dateTime", (Object)dateTime);
        return dateTime.toInstant(ZoneId.systemDefault().getRules().getOffset(dateTime)).toEpochMilli();
    }

    public static long toUnixTimestamp(OffsetDateTime dt) {
        return dt.toInstant().toEpochMilli();
    }

    public static String toHttpHeaderFormat(ZonedDateTime dateTime) {
        Checks.notNull((String)"dateTime", (Object)dateTime);
        return ISO2822DateFormat.format(dateTime);
    }

    public static ZonedDateTime fromUnixTimestamp(long timestamp) {
        ZonedDateTime ldt = TimeUtil.fromUnixTimestamp(timestamp, ZoneId.systemDefault());
        return ldt;
    }

    public static LocalDateTime localFromUnixTimestamp(long timestamp) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault());
    }

    public static LocalDateTime localFromUnixTimestampGMT(long timestamp) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), GMT);
    }

    public static OffsetDateTime offsetFromUnixTimestamp(long timestamp) {
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault());
    }

    public static ZonedDateTime fromUnixTimestamp(long timestamp, ZoneId timeZoneId) {
        Checks.notNull((String)"timeZoneId", (Object)timeZoneId);
        ZonedDateTime ldt = Instant.ofEpochMilli(timestamp).atZone(timeZoneId);
        return ldt;
    }

    public static Duration minutes(int minutes) {
        Checks.nonNegative((String)"minutes", (int)minutes);
        return Duration.ofMinutes(minutes);
    }

    public static Duration minutes(long minutes) {
        Checks.nonNegative((String)"minutes", (long)minutes);
        return Duration.ofMinutes(minutes);
    }

    public static Duration seconds(int seconds) {
        Checks.nonNegative((String)"seconds", (int)seconds);
        return Duration.ofSeconds(seconds);
    }

    public static Duration seconds(long seconds) {
        Checks.nonNegative((String)"seconds", (long)seconds);
        return Duration.ofSeconds(seconds);
    }

    public static Duration millis(int milliseconds) {
        Checks.nonNegative((String)"milliseconds", (int)milliseconds);
        return Duration.of(milliseconds, ChronoUnit.MILLIS);
    }

    public static Duration millis(long milliseconds) {
        Checks.nonNegative((String)"milliseconds", (long)milliseconds);
        return Duration.of(milliseconds, ChronoUnit.MILLIS);
    }

    public static Duration days(int days) {
        Checks.nonNegative((String)"days", (int)days);
        return Duration.ofDays(days);
    }

    public static Duration days(long days) {
        Checks.nonNegative((String)"days", (long)days);
        return Duration.ofDays(days);
    }

    public static Duration years(long years) {
        Checks.nonNegative((String)"years", (long)years);
        return Duration.ofDays(365L * years);
    }

    public static Duration years(int years) {
        Checks.nonNegative((String)"years", (int)years);
        return Duration.ofDays(365 * years);
    }

    public static long millis(Duration duration) {
        Checks.notNull((String)"duration", (Object)duration);
        return duration.toMillis();
    }

    public static long seconds(Duration duration) {
        Checks.notNull((String)"duration", (Object)duration);
        return duration.toMillis() / 1000L;
    }

    public static String format(Duration dur) {
        return TimeUtil.format(dur, false);
    }

    public static String format(Duration dur, boolean includeAllFields) {
        long days = dur.toDays();
        long hours = dur.toHours() % 24L;
        long minutes = dur.toMinutes() % 60L;
        long seconds = 0L;
        long millis = 0L;
        try {
            seconds = dur.toMillis() / 1000L % 60L;
            millis = dur.toMillis() % 1000L;
        }
        catch (Exception e) {
            seconds = 0L;
        }
        StringBuilder sb = new StringBuilder();
        TimeUtil.appendComponent(sb, days, ':', MANY_DIGITS, includeAllFields ? ChronoUnit.MILLIS : ChronoUnit.DAYS);
        TimeUtil.appendComponent(sb, hours, ':', TWO_DIGITS, includeAllFields ? ChronoUnit.MILLIS : ChronoUnit.HOURS);
        TimeUtil.appendComponent(sb, minutes, ':', TWO_DIGITS, includeAllFields ? ChronoUnit.MILLIS : ChronoUnit.MINUTES);
        TimeUtil.appendComponent(sb, seconds, ':', TWO_DIGITS, ChronoUnit.SECONDS);
        TimeUtil.appendComponent(sb, millis, '.', THREE_DIGITS, ChronoUnit.MILLIS);
        return sb.toString();
    }

    private static boolean isDigits(CharSequence val) {
        int max = val.length();
        for (int i = 0; i < max; ++i) {
            if (Character.isDigit(val.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static Duration parseDuration(String val) {
        Checks.notNullOrEmpty((String)"val", (CharSequence)val);
        val = val.trim();
        if (val.length() == 0) {
            throw new IllegalArgumentException("Passed string is just whitespace");
        }
        if (ISO_DURATION_PATTERN.matcher(val).matches()) {
            return Duration.parse(val);
        }
        if (TimeUtil.isDigits(val)) {
            return Duration.ofMillis(Long.parseLong(val));
        }
        return TimeUtil.parseClockFormatDuration(val);
    }

    @Deprecated
    public static Duration parse(String val) {
        return TimeUtil.parseClockFormatDuration(val);
    }

    private static Duration parseClockFormatDuration(String val) {
        long[] vals = new long[5];
        char[] chars = val.toCharArray();
        int ix = vals.length - 1;
        long position = 1L;
        block9: for (int i = chars.length - 1; i >= 0; --i) {
            if (ix < 0) {
                throw new IllegalArgumentException("Too many fields in '" + val + "'");
            }
            char c = chars[i];
            switch (c) {
                case '.': 
                case ':': {
                    --ix;
                    position = 1L;
                    continue block9;
                }
                default: {
                    int n = ix;
                    vals[n] = vals[n] + position * (long)(c - 48);
                    position *= 10L;
                    if (i == 0 || i != 0) continue block9;
                    int n2 = ix;
                    vals[n2] = vals[n2] + position * (long)(c - 48);
                }
            }
        }
        if (vals[0] > 106751991167299L) {
            throw new IllegalArgumentException("Duration.ofDays() cannot handle values larger than 106,751,991,167,299 days and still contain hours/minutes/seconds/millis");
        }
        Duration result = Duration.ofDays(vals[0]);
        block10: for (int i = 1; i < 5; ++i) {
            if (vals[i] == 0L) continue;
            switch (i) {
                case 1: {
                    result = result.plus(Duration.ofHours(vals[i]));
                    continue block10;
                }
                case 2: {
                    result = result.plus(Duration.ofMinutes(vals[i]));
                    continue block10;
                }
                case 3: {
                    result = result.plus(Duration.ofSeconds(vals[i]));
                    continue block10;
                }
                case 4: {
                    result = result.plus(Duration.ofMillis(vals[i]));
                    continue block10;
                }
                default: {
                    throw new AssertionError(i);
                }
            }
        }
        return result;
    }

    private static void appendComponent(StringBuilder sb, long val, char delim, NumberFormat fmt, ChronoUnit unit) {
        boolean use;
        boolean bl = use = ChronoUnit.SECONDS == unit || ChronoUnit.MILLIS == unit || val > 0L || sb.length() > 0;
        if (use) {
            if (sb.length() != 0) {
                sb.append(delim);
            }
            sb.append(fmt.format(val));
        }
    }

    public static boolean isLonger(Duration test, Duration other) {
        return test.toMillis() > other.toMillis();
    }

    public static boolean isShorter(Duration test, Duration other) {
        return test.toMillis() < other.toMillis();
    }

    public static boolean isAfterEqualOrNullSecondsResolution(ZonedDateTime when, ZonedDateTime test) {
        if (test == null) {
            return true;
        }
        when = when.withSecond(0);
        return (test = test.withSecond(0)).isAfter(when) || test.toInstant().equals(when.toInstant());
    }

    public static boolean isBeforeEqualOrNullSecondsResolution(ZonedDateTime when, ZonedDateTime test) {
        if (test == null) {
            return true;
        }
        when = when.withSecond(0);
        return (test = test.withSecond(0)).isBefore(when) || test.toInstant().equals(when.toInstant());
    }
}

