/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago;

import com.google.gson.JsonObject;
import com.mercadopago.core.MPApiResponse;
import com.mercadopago.core.MPCredentials;
import com.mercadopago.core.annotations.rest.PayloadType;
import com.mercadopago.exceptions.MPConfException;
import com.mercadopago.exceptions.MPException;
import com.mercadopago.exceptions.MPRestException;
import com.mercadopago.net.HttpMethod;
import com.mercadopago.net.MPRestClient;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class MercadoPago {

    public static class SDK {
        private static final String DEFAULT_BASE_URL = "https://api.mercadopago.com";
        private static String clientSecret = null;
        private static String clientId = null;
        private static String accessToken = null;
        private static String userToken = null;
        private static String appId = null;
        private static String baseUrl = "https://api.mercadopago.com";

        public static void configure(String accessTokenValue) {
            accessToken = accessTokenValue;
        }

        public static void configure(String clientIdValue, String clientSecretValue) {
            clientId = clientIdValue;
            clientSecret = clientSecretValue;
        }

        public static String getClientSecret() {
            return clientSecret;
        }

        public static void setClientSecret(String value) throws MPException {
            clientSecret = value;
            if (StringUtils.isNotEmpty((CharSequence)clientId)) {
                SDK.getAccessToken();
            }
        }

        public static String getClientId() {
            return clientId;
        }

        public static void setClientId(String value) throws MPException {
            clientId = value;
            if (StringUtils.isNotEmpty((CharSequence)clientSecret)) {
                SDK.getAccessToken();
            }
        }

        public static String getAccessToken() throws MPException {
            if (StringUtils.isEmpty((CharSequence)accessToken)) {
                accessToken = MPCredentials.getAccessToken();
            }
            return accessToken;
        }

        public static void setAccessToken(String value) throws MPConfException {
            accessToken = value;
        }

        public static String getUserToken() {
            return userToken;
        }

        public static void setUserToken(String value) {
            userToken = value;
        }

        public static String getAppId() {
            return appId;
        }

        public static void setAppId(String value) throws MPException {
            if (StringUtils.isNotEmpty((CharSequence)appId)) {
                throw new MPException("appId setting can not be changed");
            }
            appId = value;
        }

        public static String getBaseUrl() {
            return baseUrl;
        }

        public static void setBaseUrl(String value) {
            baseUrl = value;
        }

        public static void setConfiguration(HashMap<String, String> hashConfigurationParams) throws MPException {
            if (hashConfigurationParams == null) {
                throw new IllegalArgumentException("Invalid hashConfigurationParams parameter");
            }
            SDK.setClientSecret(SDK.getValueFromHashMap(hashConfigurationParams, "clientSecret"));
            SDK.setClientId(SDK.getValueFromHashMap(hashConfigurationParams, "clientId"));
            SDK.setAccessToken(SDK.getValueFromHashMap(hashConfigurationParams, "accessToken"));
            SDK.setAppId(SDK.getValueFromHashMap(hashConfigurationParams, "appId"));
        }

        private static String getValueFromHashMap(HashMap<String, String> hashMap, String key) {
            if (hashMap.containsKey(key) && StringUtils.isNotEmpty((CharSequence)hashMap.get(key))) {
                return hashMap.get(key);
            }
            return null;
        }

        public static void setConfiguration(String filePath) throws MPConfException {
            if (StringUtils.isEmpty((CharSequence)filePath)) {
                throw new IllegalArgumentException("File path can not be empty");
            }
            InputStream inputStream = null;
            try {
                Properties properties = new Properties();
                inputStream = SDK.class.getClassLoader().getResourceAsStream(filePath);
                if (inputStream == null) {
                    throw new IllegalArgumentException("File not found");
                }
                properties.load(inputStream);
                SDK.setConfiguration(properties);
            }
            catch (IllegalArgumentException iaException) {
                throw iaException;
            }
            catch (Exception exception) {
                throw new MPConfException(exception);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception exception) {}
            }
        }

        public static void setConfiguration(Properties properties) throws MPException {
            SDK.setAppId(SDK.getValueFromProperties(properties, "appId"));
            if (StringUtils.isNotEmpty((CharSequence)SDK.getValueFromProperties(properties, "accessToken"))) {
                SDK.setAccessToken(SDK.getValueFromProperties(properties, "accessToken"));
            }
            if (StringUtils.isNotEmpty((CharSequence)SDK.getValueFromProperties(properties, "clientSecret"))) {
                SDK.setClientSecret(SDK.getValueFromProperties(properties, "clientSecret"));
                SDK.setClientId(SDK.getValueFromProperties(properties, "clientId"));
            }
        }

        private static String getValueFromProperties(Properties properties, String key) {
            if (properties.containsKey(key) && StringUtils.isNotEmpty((CharSequence)properties.getProperty(key))) {
                return properties.getProperty(key);
            }
            return null;
        }

        public static void cleanConfiguration() {
            clientSecret = null;
            clientId = null;
            accessToken = null;
            appId = null;
            baseUrl = DEFAULT_BASE_URL;
        }

        public static MPApiResponse Get(String uri) throws MPRestException {
            MPRestClient client = new MPRestClient();
            MPApiResponse response = client.executeRequest(HttpMethod.GET, uri, PayloadType.JSON, null, null);
            return response;
        }

        public static MPApiResponse Post(String uri, JsonObject payload) throws MPRestException {
            MPRestClient client = new MPRestClient();
            MPApiResponse response = client.executeRequest(HttpMethod.POST, uri, PayloadType.JSON, payload, null);
            return response;
        }

        public static MPApiResponse Put(String uri, JsonObject payload) throws MPRestException {
            MPRestClient client = new MPRestClient();
            MPApiResponse response = client.executeRequest(HttpMethod.PUT, uri, PayloadType.JSON, payload, null);
            return response;
        }
    }
}

