/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.core;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mercadopago.core.MPCoreUtils;
import com.mercadopago.exceptions.MPException;
import com.mercadopago.net.HttpMethod;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;

public class MPApiResponse
implements Cloneable {
    private HttpRequestBase _httpRequest;
    private JsonObject _requestPayload;
    private HttpResponse _httpResponse;
    private long _responseMillis;
    private String method;
    private String url;
    private String payload;
    private int statusCode;
    private String reasonPhrase;
    private String stringResponse;
    private JsonElement jsonElementResponse;
    public Boolean fromCache = Boolean.FALSE;

    public MPApiResponse(HttpMethod httpMethod, HttpRequestBase request, JsonObject payload, HttpResponse response, long responseMillis) throws MPException {
        this._httpRequest = request;
        this._requestPayload = payload;
        this._httpResponse = response;
        this._responseMillis = responseMillis;
        this.parseRequest(httpMethod, request, payload);
        this.parseResponse(response);
    }

    public String getMethod() {
        return this.method;
    }

    public String getUrl() {
        return this.url;
    }

    public String getPayload() {
        return this.payload;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public String getStringResponse() {
        return this.stringResponse;
    }

    public JsonElement getJsonElementResponse() {
        return this.jsonElementResponse;
    }

    public Header[] getHeaders(String headerName) {
        return this._httpResponse.getHeaders(headerName);
    }

    private void parseRequest(HttpMethod httpMethod, HttpRequestBase request, JsonObject payload) throws MPException {
        this.method = httpMethod.toString();
        this.url = request.getURI().toString();
        if (payload != null) {
            this.payload = payload.toString();
        }
    }

    private void parseResponse(HttpResponse response) throws MPException {
        this.statusCode = response.getStatusLine().getStatusCode();
        this.reasonPhrase = response.getStatusLine().getReasonPhrase();
        if (response.getEntity() != null) {
            HttpEntity respEntity = response.getEntity();
            try {
                this.stringResponse = MPCoreUtils.inputStreamToString(respEntity.getContent());
            }
            catch (Exception ex) {
                throw new MPException(ex);
            }
            try {
                this.jsonElementResponse = new JsonParser().parse(this.stringResponse);
            }
            catch (JsonParseException jsonParseException) {
                // empty catch block
            }
        }
    }

    protected MPApiResponse clone() throws CloneNotSupportedException {
        return (MPApiResponse)super.clone();
    }
}

