/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.core;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mercadopago.MercadoPago;
import com.mercadopago.core.MPApiResponse;
import com.mercadopago.core.annotations.rest.PayloadType;
import com.mercadopago.exceptions.MPException;
import com.mercadopago.net.HttpMethod;
import com.mercadopago.net.MPRestClient;
import org.apache.commons.lang3.StringUtils;

public class MPCredentials {
    public static String getAccessToken() throws MPException {
        if (StringUtils.isEmpty((CharSequence)MercadoPago.SDK.getClientId()) || StringUtils.isEmpty((CharSequence)MercadoPago.SDK.getClientSecret())) {
            throw new MPException("\"client_id\" and \"client_secret\" can not be \"null\" when getting the \"access_token\"");
        }
        JsonObject jsonPayload = new JsonObject();
        jsonPayload.addProperty("grant_type", "client_credentials");
        jsonPayload.addProperty("client_id", MercadoPago.SDK.getClientId());
        jsonPayload.addProperty("client_secret", MercadoPago.SDK.getClientSecret());
        String access_token = null;
        String baseUri = MercadoPago.SDK.getBaseUrl();
        MPApiResponse response = new MPRestClient().executeRequest(HttpMethod.POST, baseUri + "/oauth/token", PayloadType.JSON, jsonPayload, null);
        if (response.getStatusCode() == 200) {
            JsonElement jsonElement = response.getJsonElementResponse();
            if (jsonElement.isJsonObject()) {
                access_token = ((JsonObject)jsonElement).get("access_token").getAsString();
            }
        } else {
            throw new MPException("Can not retrieve the \"access_token\"");
        }
        return access_token;
    }
}

