/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.core;

import com.mercadopago.core.MPBase;
import com.mercadopago.core.MPCoreUtils;
import com.mercadopago.core.ValidationViolation;
import com.mercadopago.core.annotations.validation.NotNull;
import com.mercadopago.core.annotations.validation.Numeric;
import com.mercadopago.core.annotations.validation.Size;
import com.mercadopago.exceptions.MPValidationException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import org.apache.commons.lang3.math.NumberUtils;

public class MPValidator {
    public static <T extends MPBase> boolean validate(T objectToValidate) throws MPValidationException {
        Collection<ValidationViolation> colViolations = MPValidator.validate(new Vector<ValidationViolation>(), objectToValidate);
        if (!colViolations.isEmpty()) {
            throw new MPValidationException(colViolations);
        }
        return true;
    }

    private static Collection<ValidationViolation> validate(Collection<ValidationViolation> colViolations, Object objectToValidate) {
        Field[] fields;
        String className = objectToValidate.getClass().getSimpleName();
        for (Field field : fields = MPCoreUtils.getAllFields(objectToValidate.getClass())) {
            Annotation[] annotations = field.getAnnotations();
            if (annotations == null) continue;
            Object value = null;
            try {
                field.setAccessible(true);
                value = field.get(objectToValidate);
            }
            catch (Exception ex) {
                colViolations.add(new ValidationViolation(className, field.getName(), "is not accesible"));
            }
            if (value != null && value.getClass().getCanonicalName().indexOf("com.mercadopago.resources.datastructures.") == 0 && !value.getClass().getName().contains("$")) {
                colViolations = MPValidator.validate(colViolations, value);
                continue;
            }
            if (value != null && value.getClass().getCanonicalName().equals("java.util.ArrayList")) {
                for (Object arrayItem : (ArrayList)value) {
                    colViolations = MPValidator.validate(colViolations, arrayItem);
                }
                continue;
            }
            for (Annotation annotation : annotations) {
                if (annotation instanceof NotNull) {
                    if (value != null) continue;
                    colViolations.add(new ValidationViolation(className, field.getName(), "can not be 'null'"));
                    continue;
                }
                if (annotation instanceof Numeric) {
                    if (value == null) continue;
                    if (!NumberUtils.isNumber((String)value.toString())) {
                        colViolations.add(new ValidationViolation(className, field.getName(), "is not a valid number", value));
                        continue;
                    }
                    Float floatValue = Float.valueOf(Float.parseFloat(value.toString()));
                    String stringValue = NumberUtils.createBigDecimal((String)value.toString()).toString();
                    Numeric numeric = (Numeric)annotation;
                    if (numeric.min() > floatValue.floatValue()) {
                        colViolations.add(new ValidationViolation(className, field.getName(), "falls short of the minimum value", stringValue, Float.valueOf(numeric.min())));
                    }
                    if (numeric.max() < floatValue.floatValue()) {
                        colViolations.add(new ValidationViolation(className, field.getName(), "exceeds the maximum value", stringValue, Float.valueOf(numeric.max())));
                    }
                    if (numeric.fractionDigits() <= -1 || !stringValue.contains(".") || stringValue.substring(String.valueOf(floatValue).indexOf(".") + 1).length() <= numeric.fractionDigits()) continue;
                    colViolations.add(new ValidationViolation(className, field.getName(), "exceeds the maximum decimal digits", stringValue, numeric.fractionDigits()));
                    continue;
                }
                if (!(annotation instanceof Size) || value == null) continue;
                String stringValue = value.toString();
                Size size = (Size)annotation;
                if (size.min() > -1 && stringValue.length() < size.min()) {
                    colViolations.add(new ValidationViolation(className, field.getName(), "fall short of the minimum length", stringValue.length(), size.min()));
                }
                if (size.max() <= -1 || stringValue.length() <= size.max()) continue;
                colViolations.add(new ValidationViolation(className, field.getName(), "exceed the maximum length value", stringValue.length(), size.max()));
            }
        }
        return colViolations;
    }
}

