/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.resources;

import com.mercadopago.core.MPBase;
import com.mercadopago.core.annotations.rest.GET;
import com.mercadopago.core.annotations.rest.POST;
import com.mercadopago.core.annotations.rest.PUT;
import com.mercadopago.core.annotations.validation.Size;
import com.mercadopago.exceptions.MPException;
import com.mercadopago.resources.datastructures.merchantorder.Collector;
import com.mercadopago.resources.datastructures.merchantorder.Item;
import com.mercadopago.resources.datastructures.merchantorder.MerchantOrderPayment;
import com.mercadopago.resources.datastructures.merchantorder.Payer;
import com.mercadopago.resources.datastructures.merchantorder.Shipment;
import java.util.ArrayList;
import java.util.Date;

public class MerchantOrder
extends MPBase {
    private String id = null;
    private String preferenceId = null;
    private Date dateCreated = null;
    private Date lastUpdate = null;
    private String applicationId = null;
    private String status = null;
    private String siteId = null;
    private Payer payer = null;
    private Collector collector = null;
    private Integer sponsorId = null;
    private ArrayList<MerchantOrderPayment> payments = null;
    private Float paidAmount = null;
    private Float refundedAmount = null;
    private Float shippingCost = null;
    private Boolean cancelled = null;
    private ArrayList<Item> items = null;
    private ArrayList<Shipment> shipments = null;
    @Size(max=500)
    private String notificationUrl = null;
    @Size(max=600)
    private String additionalInfo = null;
    @Size(max=256)
    private String externalReference = null;
    @Size(max=256)
    private String marketplace = null;
    private Float totalAmount = null;

    public String getId() {
        return this.id;
    }

    public String getPreferenceId() {
        return this.preferenceId;
    }

    public MerchantOrder setPreferenceId(String preferenceId) {
        this.preferenceId = preferenceId;
        return this;
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public MerchantOrder setApplicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public MerchantOrder setSiteId(String siteId) {
        this.siteId = siteId;
        return this;
    }

    public Payer getPayer() {
        return this.payer;
    }

    public MerchantOrder setPayer(Payer payer) {
        this.payer = payer;
        return this;
    }

    public Collector getCollector() {
        return this.collector;
    }

    public MerchantOrder setCollector(Collector collector) {
        this.collector = collector;
        return this;
    }

    public Integer getSponsorId() {
        return this.sponsorId;
    }

    public MerchantOrder setSponsorId(Integer sponsorId) {
        this.sponsorId = sponsorId;
        return this;
    }

    public ArrayList<MerchantOrderPayment> getPayments() {
        return this.payments;
    }

    public Float getPaidAmount() {
        return this.paidAmount;
    }

    public Float getRefundedAmount() {
        return this.refundedAmount;
    }

    public Float getShippingCost() {
        return this.shippingCost;
    }

    public Boolean getCancelled() {
        return this.cancelled;
    }

    public MerchantOrder setCancelled(Boolean cancelled) {
        this.cancelled = cancelled;
        return this;
    }

    public ArrayList<Item> getItems() {
        return this.items;
    }

    public MerchantOrder setItems(ArrayList<Item> items) {
        this.items = items;
        return this;
    }

    public MerchantOrder appendItem(Item item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        this.items.add(item);
        return this;
    }

    public ArrayList<Shipment> getShipments() {
        return this.shipments;
    }

    public MerchantOrder setShipments(ArrayList<Shipment> shipments) {
        this.shipments = shipments;
        return this;
    }

    public MerchantOrder appendShipment(Shipment shipment) {
        if (this.shipments == null) {
            this.shipments = new ArrayList();
        }
        this.shipments.add(shipment);
        return this;
    }

    public String getNotificationUrl() {
        return this.notificationUrl;
    }

    public MerchantOrder setNotificationUrl(String notificationUrl) {
        this.notificationUrl = notificationUrl;
        return this;
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public MerchantOrder setAdditionalInfo(String additionalInfo) {
        this.additionalInfo = additionalInfo;
        return this;
    }

    public String getExternalReference() {
        return this.externalReference;
    }

    public MerchantOrder setExternalReference(String externalReference) {
        this.externalReference = externalReference;
        return this;
    }

    public String getMarketplace() {
        return this.marketplace;
    }

    public MerchantOrder setMarketplace(String marketplace) {
        this.marketplace = marketplace;
        return this;
    }

    public Float getTotalAmount() {
        return this.totalAmount;
    }

    public static MerchantOrder findById(String id) throws MPException {
        return MerchantOrder.findById(id, WITHOUT_CACHE);
    }

    @GET(path="/merchant_orders/:id")
    public static MerchantOrder findById(String id, Boolean useCache) throws MPException {
        return (MerchantOrder)MerchantOrder.processMethod(MerchantOrder.class, "findById", id, useCache);
    }

    @POST(path="/merchant_orders")
    public MerchantOrder save() throws MPException {
        return (MerchantOrder)super.processMethod("save", WITHOUT_CACHE);
    }

    @PUT(path="/merchant_orders/:id")
    public MerchantOrder update() throws MPException {
        return (MerchantOrder)super.processMethod("update", WITHOUT_CACHE);
    }
}

