/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.APIKeyRequest;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ApplicationInsightsComponentAPIKeyInner;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ApplicationInsightsManagementClientImpl;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.PageImpl1;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class APIKeysInner {
    private APIKeysService service;
    private ApplicationInsightsManagementClientImpl client;

    public APIKeysInner(Retrofit retrofit, ApplicationInsightsManagementClientImpl client) {
        this.service = (APIKeysService)retrofit.create(APIKeysService.class);
        this.client = client;
    }

    public List<ApplicationInsightsComponentAPIKeyInner> list(String resourceGroupName, String resourceName) {
        return (List)((ServiceResponse)this.listWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().single()).body();
    }

    public ServiceFuture<List<ApplicationInsightsComponentAPIKeyInner>> listAsync(String resourceGroupName, String resourceName, ServiceCallback<List<ApplicationInsightsComponentAPIKeyInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    public Observable<List<ApplicationInsightsComponentAPIKeyInner>> listAsync(String resourceGroupName, String resourceName) {
        return this.listWithServiceResponseAsync(resourceGroupName, resourceName).map((Func1)new Func1<ServiceResponse<List<ApplicationInsightsComponentAPIKeyInner>>, List<ApplicationInsightsComponentAPIKeyInner>>(){

            public List<ApplicationInsightsComponentAPIKeyInner> call(ServiceResponse<List<ApplicationInsightsComponentAPIKeyInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<ApplicationInsightsComponentAPIKeyInner>>> listWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(resourceGroupName, this.client.subscriptionId(), resourceName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<ApplicationInsightsComponentAPIKeyInner>>>>(){

            public Observable<ServiceResponse<List<ApplicationInsightsComponentAPIKeyInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = APIKeysInner.this.listDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl1)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ApplicationInsightsComponentAPIKeyInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ApplicationInsightsComponentAPIKeyInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ApplicationInsightsComponentAPIKeyInner create(String resourceGroupName, String resourceName, APIKeyRequest aPIKeyProperties) {
        return (ApplicationInsightsComponentAPIKeyInner)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, resourceName, aPIKeyProperties).toBlocking().single()).body();
    }

    public ServiceFuture<ApplicationInsightsComponentAPIKeyInner> createAsync(String resourceGroupName, String resourceName, APIKeyRequest aPIKeyProperties, ServiceCallback<ApplicationInsightsComponentAPIKeyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, resourceName, aPIKeyProperties), serviceCallback);
    }

    public Observable<ApplicationInsightsComponentAPIKeyInner> createAsync(String resourceGroupName, String resourceName, APIKeyRequest aPIKeyProperties) {
        return this.createWithServiceResponseAsync(resourceGroupName, resourceName, aPIKeyProperties).map((Func1)new Func1<ServiceResponse<ApplicationInsightsComponentAPIKeyInner>, ApplicationInsightsComponentAPIKeyInner>(){

            public ApplicationInsightsComponentAPIKeyInner call(ServiceResponse<ApplicationInsightsComponentAPIKeyInner> response) {
                return (ApplicationInsightsComponentAPIKeyInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ApplicationInsightsComponentAPIKeyInner>> createWithServiceResponseAsync(String resourceGroupName, String resourceName, APIKeyRequest aPIKeyProperties) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (aPIKeyProperties == null) {
            throw new IllegalArgumentException("Parameter aPIKeyProperties is required and cannot be null.");
        }
        Validator.validate((Object)aPIKeyProperties);
        return this.service.create(resourceGroupName, this.client.subscriptionId(), resourceName, this.client.apiVersion(), aPIKeyProperties, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationInsightsComponentAPIKeyInner>>>(){

            public Observable<ServiceResponse<ApplicationInsightsComponentAPIKeyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = APIKeysInner.this.createDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ApplicationInsightsComponentAPIKeyInner> createDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ApplicationInsightsComponentAPIKeyInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ApplicationInsightsComponentAPIKeyInner delete(String resourceGroupName, String resourceName, String keyId) {
        return (ApplicationInsightsComponentAPIKeyInner)((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, resourceName, keyId).toBlocking().single()).body();
    }

    public ServiceFuture<ApplicationInsightsComponentAPIKeyInner> deleteAsync(String resourceGroupName, String resourceName, String keyId, ServiceCallback<ApplicationInsightsComponentAPIKeyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, resourceName, keyId), serviceCallback);
    }

    public Observable<ApplicationInsightsComponentAPIKeyInner> deleteAsync(String resourceGroupName, String resourceName, String keyId) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, resourceName, keyId).map((Func1)new Func1<ServiceResponse<ApplicationInsightsComponentAPIKeyInner>, ApplicationInsightsComponentAPIKeyInner>(){

            public ApplicationInsightsComponentAPIKeyInner call(ServiceResponse<ApplicationInsightsComponentAPIKeyInner> response) {
                return (ApplicationInsightsComponentAPIKeyInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ApplicationInsightsComponentAPIKeyInner>> deleteWithServiceResponseAsync(String resourceGroupName, String resourceName, String keyId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (keyId == null) {
            throw new IllegalArgumentException("Parameter keyId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(resourceGroupName, this.client.subscriptionId(), resourceName, keyId, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationInsightsComponentAPIKeyInner>>>(){

            public Observable<ServiceResponse<ApplicationInsightsComponentAPIKeyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = APIKeysInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ApplicationInsightsComponentAPIKeyInner> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ApplicationInsightsComponentAPIKeyInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ApplicationInsightsComponentAPIKeyInner get(String resourceGroupName, String resourceName, String keyId) {
        return (ApplicationInsightsComponentAPIKeyInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, resourceName, keyId).toBlocking().single()).body();
    }

    public ServiceFuture<ApplicationInsightsComponentAPIKeyInner> getAsync(String resourceGroupName, String resourceName, String keyId, ServiceCallback<ApplicationInsightsComponentAPIKeyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, resourceName, keyId), serviceCallback);
    }

    public Observable<ApplicationInsightsComponentAPIKeyInner> getAsync(String resourceGroupName, String resourceName, String keyId) {
        return this.getWithServiceResponseAsync(resourceGroupName, resourceName, keyId).map((Func1)new Func1<ServiceResponse<ApplicationInsightsComponentAPIKeyInner>, ApplicationInsightsComponentAPIKeyInner>(){

            public ApplicationInsightsComponentAPIKeyInner call(ServiceResponse<ApplicationInsightsComponentAPIKeyInner> response) {
                return (ApplicationInsightsComponentAPIKeyInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ApplicationInsightsComponentAPIKeyInner>> getWithServiceResponseAsync(String resourceGroupName, String resourceName, String keyId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (keyId == null) {
            throw new IllegalArgumentException("Parameter keyId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, this.client.subscriptionId(), resourceName, keyId, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationInsightsComponentAPIKeyInner>>>(){

            public Observable<ServiceResponse<ApplicationInsightsComponentAPIKeyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = APIKeysInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ApplicationInsightsComponentAPIKeyInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ApplicationInsightsComponentAPIKeyInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface APIKeysService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.APIKeys list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/ApiKeys")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.APIKeys create"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/ApiKeys")
        public Observable<Response<ResponseBody>> create(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Body APIKeyRequest var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.APIKeys delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/APIKeys/{keyId}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Path(value="resourceName") String var3, @Path(value="keyId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.APIKeys get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/APIKeys/{keyId}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Path(value="resourceName") String var3, @Path(value="keyId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);
    }
}

