/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.ItemScope;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.ItemScopePath;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.ItemTypeParameter;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ApplicationInsightsComponentAnalyticsItemInner;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ApplicationInsightsManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class AnalyticsItemsInner {
    private AnalyticsItemsService service;
    private ApplicationInsightsManagementClientImpl client;

    public AnalyticsItemsInner(Retrofit retrofit, ApplicationInsightsManagementClientImpl client) {
        this.service = (AnalyticsItemsService)retrofit.create(AnalyticsItemsService.class);
        this.client = client;
    }

    public List<ApplicationInsightsComponentAnalyticsItemInner> list(String resourceGroupName, String resourceName, ItemScopePath scopePath) {
        return (List)((ServiceResponse)this.listWithServiceResponseAsync(resourceGroupName, resourceName, scopePath).toBlocking().single()).body();
    }

    public ServiceFuture<List<ApplicationInsightsComponentAnalyticsItemInner>> listAsync(String resourceGroupName, String resourceName, ItemScopePath scopePath, ServiceCallback<List<ApplicationInsightsComponentAnalyticsItemInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(resourceGroupName, resourceName, scopePath), serviceCallback);
    }

    public Observable<List<ApplicationInsightsComponentAnalyticsItemInner>> listAsync(String resourceGroupName, String resourceName, ItemScopePath scopePath) {
        return this.listWithServiceResponseAsync(resourceGroupName, resourceName, scopePath).map((Func1)new Func1<ServiceResponse<List<ApplicationInsightsComponentAnalyticsItemInner>>, List<ApplicationInsightsComponentAnalyticsItemInner>>(){

            public List<ApplicationInsightsComponentAnalyticsItemInner> call(ServiceResponse<List<ApplicationInsightsComponentAnalyticsItemInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<ApplicationInsightsComponentAnalyticsItemInner>>> listWithServiceResponseAsync(String resourceGroupName, String resourceName, ItemScopePath scopePath) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (scopePath == null) {
            throw new IllegalArgumentException("Parameter scopePath is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        ItemScope scope = null;
        ItemTypeParameter type = null;
        Boolean includeContent = null;
        return this.service.list(this.client.subscriptionId(), resourceGroupName, resourceName, scopePath, this.client.apiVersion(), scope, type, includeContent, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<ApplicationInsightsComponentAnalyticsItemInner>>>>(){

            public Observable<ServiceResponse<List<ApplicationInsightsComponentAnalyticsItemInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AnalyticsItemsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public List<ApplicationInsightsComponentAnalyticsItemInner> list(String resourceGroupName, String resourceName, ItemScopePath scopePath, ItemScope scope, ItemTypeParameter type, Boolean includeContent) {
        return (List)((ServiceResponse)this.listWithServiceResponseAsync(resourceGroupName, resourceName, scopePath, scope, type, includeContent).toBlocking().single()).body();
    }

    public ServiceFuture<List<ApplicationInsightsComponentAnalyticsItemInner>> listAsync(String resourceGroupName, String resourceName, ItemScopePath scopePath, ItemScope scope, ItemTypeParameter type, Boolean includeContent, ServiceCallback<List<ApplicationInsightsComponentAnalyticsItemInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(resourceGroupName, resourceName, scopePath, scope, type, includeContent), serviceCallback);
    }

    public Observable<List<ApplicationInsightsComponentAnalyticsItemInner>> listAsync(String resourceGroupName, String resourceName, ItemScopePath scopePath, ItemScope scope, ItemTypeParameter type, Boolean includeContent) {
        return this.listWithServiceResponseAsync(resourceGroupName, resourceName, scopePath, scope, type, includeContent).map((Func1)new Func1<ServiceResponse<List<ApplicationInsightsComponentAnalyticsItemInner>>, List<ApplicationInsightsComponentAnalyticsItemInner>>(){

            public List<ApplicationInsightsComponentAnalyticsItemInner> call(ServiceResponse<List<ApplicationInsightsComponentAnalyticsItemInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<ApplicationInsightsComponentAnalyticsItemInner>>> listWithServiceResponseAsync(String resourceGroupName, String resourceName, ItemScopePath scopePath, ItemScope scope, ItemTypeParameter type, Boolean includeContent) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (scopePath == null) {
            throw new IllegalArgumentException("Parameter scopePath is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.subscriptionId(), resourceGroupName, resourceName, scopePath, this.client.apiVersion(), scope, type, includeContent, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<ApplicationInsightsComponentAnalyticsItemInner>>>>(){

            public Observable<ServiceResponse<List<ApplicationInsightsComponentAnalyticsItemInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AnalyticsItemsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<List<ApplicationInsightsComponentAnalyticsItemInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<List<ApplicationInsightsComponentAnalyticsItemInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ApplicationInsightsComponentAnalyticsItemInner get(String resourceGroupName, String resourceName, ItemScopePath scopePath) {
        return (ApplicationInsightsComponentAnalyticsItemInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, resourceName, scopePath).toBlocking().single()).body();
    }

    public ServiceFuture<ApplicationInsightsComponentAnalyticsItemInner> getAsync(String resourceGroupName, String resourceName, ItemScopePath scopePath, ServiceCallback<ApplicationInsightsComponentAnalyticsItemInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, resourceName, scopePath), serviceCallback);
    }

    public Observable<ApplicationInsightsComponentAnalyticsItemInner> getAsync(String resourceGroupName, String resourceName, ItemScopePath scopePath) {
        return this.getWithServiceResponseAsync(resourceGroupName, resourceName, scopePath).map((Func1)new Func1<ServiceResponse<ApplicationInsightsComponentAnalyticsItemInner>, ApplicationInsightsComponentAnalyticsItemInner>(){

            public ApplicationInsightsComponentAnalyticsItemInner call(ServiceResponse<ApplicationInsightsComponentAnalyticsItemInner> response) {
                return (ApplicationInsightsComponentAnalyticsItemInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ApplicationInsightsComponentAnalyticsItemInner>> getWithServiceResponseAsync(String resourceGroupName, String resourceName, ItemScopePath scopePath) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (scopePath == null) {
            throw new IllegalArgumentException("Parameter scopePath is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String id = null;
        String name = null;
        return this.service.get(this.client.subscriptionId(), resourceGroupName, resourceName, scopePath, this.client.apiVersion(), id, name, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationInsightsComponentAnalyticsItemInner>>>(){

            public Observable<ServiceResponse<ApplicationInsightsComponentAnalyticsItemInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AnalyticsItemsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public ApplicationInsightsComponentAnalyticsItemInner get(String resourceGroupName, String resourceName, ItemScopePath scopePath, String id, String name) {
        return (ApplicationInsightsComponentAnalyticsItemInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, resourceName, scopePath, id, name).toBlocking().single()).body();
    }

    public ServiceFuture<ApplicationInsightsComponentAnalyticsItemInner> getAsync(String resourceGroupName, String resourceName, ItemScopePath scopePath, String id, String name, ServiceCallback<ApplicationInsightsComponentAnalyticsItemInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, resourceName, scopePath, id, name), serviceCallback);
    }

    public Observable<ApplicationInsightsComponentAnalyticsItemInner> getAsync(String resourceGroupName, String resourceName, ItemScopePath scopePath, String id, String name) {
        return this.getWithServiceResponseAsync(resourceGroupName, resourceName, scopePath, id, name).map((Func1)new Func1<ServiceResponse<ApplicationInsightsComponentAnalyticsItemInner>, ApplicationInsightsComponentAnalyticsItemInner>(){

            public ApplicationInsightsComponentAnalyticsItemInner call(ServiceResponse<ApplicationInsightsComponentAnalyticsItemInner> response) {
                return (ApplicationInsightsComponentAnalyticsItemInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ApplicationInsightsComponentAnalyticsItemInner>> getWithServiceResponseAsync(String resourceGroupName, String resourceName, ItemScopePath scopePath, String id, String name) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (scopePath == null) {
            throw new IllegalArgumentException("Parameter scopePath is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(this.client.subscriptionId(), resourceGroupName, resourceName, scopePath, this.client.apiVersion(), id, name, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationInsightsComponentAnalyticsItemInner>>>(){

            public Observable<ServiceResponse<ApplicationInsightsComponentAnalyticsItemInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AnalyticsItemsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ApplicationInsightsComponentAnalyticsItemInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ApplicationInsightsComponentAnalyticsItemInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ApplicationInsightsComponentAnalyticsItemInner put(String resourceGroupName, String resourceName, ItemScopePath scopePath, ApplicationInsightsComponentAnalyticsItemInner itemProperties) {
        return (ApplicationInsightsComponentAnalyticsItemInner)((ServiceResponse)this.putWithServiceResponseAsync(resourceGroupName, resourceName, scopePath, itemProperties).toBlocking().single()).body();
    }

    public ServiceFuture<ApplicationInsightsComponentAnalyticsItemInner> putAsync(String resourceGroupName, String resourceName, ItemScopePath scopePath, ApplicationInsightsComponentAnalyticsItemInner itemProperties, ServiceCallback<ApplicationInsightsComponentAnalyticsItemInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.putWithServiceResponseAsync(resourceGroupName, resourceName, scopePath, itemProperties), serviceCallback);
    }

    public Observable<ApplicationInsightsComponentAnalyticsItemInner> putAsync(String resourceGroupName, String resourceName, ItemScopePath scopePath, ApplicationInsightsComponentAnalyticsItemInner itemProperties) {
        return this.putWithServiceResponseAsync(resourceGroupName, resourceName, scopePath, itemProperties).map((Func1)new Func1<ServiceResponse<ApplicationInsightsComponentAnalyticsItemInner>, ApplicationInsightsComponentAnalyticsItemInner>(){

            public ApplicationInsightsComponentAnalyticsItemInner call(ServiceResponse<ApplicationInsightsComponentAnalyticsItemInner> response) {
                return (ApplicationInsightsComponentAnalyticsItemInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ApplicationInsightsComponentAnalyticsItemInner>> putWithServiceResponseAsync(String resourceGroupName, String resourceName, ItemScopePath scopePath, ApplicationInsightsComponentAnalyticsItemInner itemProperties) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (scopePath == null) {
            throw new IllegalArgumentException("Parameter scopePath is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (itemProperties == null) {
            throw new IllegalArgumentException("Parameter itemProperties is required and cannot be null.");
        }
        Validator.validate((Object)itemProperties);
        Boolean overrideItem = null;
        return this.service.put(this.client.subscriptionId(), resourceGroupName, resourceName, scopePath, this.client.apiVersion(), overrideItem, itemProperties, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationInsightsComponentAnalyticsItemInner>>>(){

            public Observable<ServiceResponse<ApplicationInsightsComponentAnalyticsItemInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AnalyticsItemsInner.this.putDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public ApplicationInsightsComponentAnalyticsItemInner put(String resourceGroupName, String resourceName, ItemScopePath scopePath, ApplicationInsightsComponentAnalyticsItemInner itemProperties, Boolean overrideItem) {
        return (ApplicationInsightsComponentAnalyticsItemInner)((ServiceResponse)this.putWithServiceResponseAsync(resourceGroupName, resourceName, scopePath, itemProperties, overrideItem).toBlocking().single()).body();
    }

    public ServiceFuture<ApplicationInsightsComponentAnalyticsItemInner> putAsync(String resourceGroupName, String resourceName, ItemScopePath scopePath, ApplicationInsightsComponentAnalyticsItemInner itemProperties, Boolean overrideItem, ServiceCallback<ApplicationInsightsComponentAnalyticsItemInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.putWithServiceResponseAsync(resourceGroupName, resourceName, scopePath, itemProperties, overrideItem), serviceCallback);
    }

    public Observable<ApplicationInsightsComponentAnalyticsItemInner> putAsync(String resourceGroupName, String resourceName, ItemScopePath scopePath, ApplicationInsightsComponentAnalyticsItemInner itemProperties, Boolean overrideItem) {
        return this.putWithServiceResponseAsync(resourceGroupName, resourceName, scopePath, itemProperties, overrideItem).map((Func1)new Func1<ServiceResponse<ApplicationInsightsComponentAnalyticsItemInner>, ApplicationInsightsComponentAnalyticsItemInner>(){

            public ApplicationInsightsComponentAnalyticsItemInner call(ServiceResponse<ApplicationInsightsComponentAnalyticsItemInner> response) {
                return (ApplicationInsightsComponentAnalyticsItemInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ApplicationInsightsComponentAnalyticsItemInner>> putWithServiceResponseAsync(String resourceGroupName, String resourceName, ItemScopePath scopePath, ApplicationInsightsComponentAnalyticsItemInner itemProperties, Boolean overrideItem) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (scopePath == null) {
            throw new IllegalArgumentException("Parameter scopePath is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (itemProperties == null) {
            throw new IllegalArgumentException("Parameter itemProperties is required and cannot be null.");
        }
        Validator.validate((Object)itemProperties);
        return this.service.put(this.client.subscriptionId(), resourceGroupName, resourceName, scopePath, this.client.apiVersion(), overrideItem, itemProperties, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationInsightsComponentAnalyticsItemInner>>>(){

            public Observable<ServiceResponse<ApplicationInsightsComponentAnalyticsItemInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AnalyticsItemsInner.this.putDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ApplicationInsightsComponentAnalyticsItemInner> putDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ApplicationInsightsComponentAnalyticsItemInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String resourceName, ItemScopePath scopePath) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, resourceName, scopePath).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String resourceName, ItemScopePath scopePath, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, resourceName, scopePath), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String resourceName, ItemScopePath scopePath) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, resourceName, scopePath).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String resourceName, ItemScopePath scopePath) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (scopePath == null) {
            throw new IllegalArgumentException("Parameter scopePath is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String id = null;
        String name = null;
        return this.service.delete(this.client.subscriptionId(), resourceGroupName, resourceName, scopePath, this.client.apiVersion(), id, name, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AnalyticsItemsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public void delete(String resourceGroupName, String resourceName, ItemScopePath scopePath, String id, String name) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, resourceName, scopePath, id, name).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String resourceName, ItemScopePath scopePath, String id, String name, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, resourceName, scopePath, id, name), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String resourceName, ItemScopePath scopePath, String id, String name) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, resourceName, scopePath, id, name).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String resourceName, ItemScopePath scopePath, String id, String name) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (scopePath == null) {
            throw new IllegalArgumentException("Parameter scopePath is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(this.client.subscriptionId(), resourceGroupName, resourceName, scopePath, this.client.apiVersion(), id, name, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AnalyticsItemsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface AnalyticsItemsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.AnalyticsItems list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components/{resourceName}/{scopePath}")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Path(value="scopePath") ItemScopePath var4, @Query(value="api-version") String var5, @Query(value="scope") ItemScope var6, @Query(value="type") ItemTypeParameter var7, @Query(value="includeContent") Boolean var8, @Header(value="accept-language") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.AnalyticsItems get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components/{resourceName}/{scopePath}/item")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Path(value="scopePath") ItemScopePath var4, @Query(value="api-version") String var5, @Query(value="id") String var6, @Query(value="name") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.AnalyticsItems put"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components/{resourceName}/{scopePath}/item")
        public Observable<Response<ResponseBody>> put(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Path(value="scopePath") ItemScopePath var4, @Query(value="api-version") String var5, @Query(value="overrideItem") Boolean var6, @Body ApplicationInsightsComponentAnalyticsItemInner var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.AnalyticsItems delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/microsoft.insights/components/{resourceName}/{scopePath}/item", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Path(value="scopePath") ItemScopePath var4, @Query(value="api-version") String var5, @Query(value="id") String var6, @Query(value="name") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);
    }
}

