/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.AnnotationErrorException;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.AnnotationInner;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ApplicationInsightsManagementClientImpl;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.PageImpl1;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class AnnotationsInner {
    private AnnotationsService service;
    private ApplicationInsightsManagementClientImpl client;

    public AnnotationsInner(Retrofit retrofit, ApplicationInsightsManagementClientImpl client) {
        this.service = (AnnotationsService)retrofit.create(AnnotationsService.class);
        this.client = client;
    }

    public List<AnnotationInner> list(String resourceGroupName, String resourceName, String start, String end) {
        return (List)((ServiceResponse)this.listWithServiceResponseAsync(resourceGroupName, resourceName, start, end).toBlocking().single()).body();
    }

    public ServiceFuture<List<AnnotationInner>> listAsync(String resourceGroupName, String resourceName, String start, String end, ServiceCallback<List<AnnotationInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(resourceGroupName, resourceName, start, end), serviceCallback);
    }

    public Observable<List<AnnotationInner>> listAsync(String resourceGroupName, String resourceName, String start, String end) {
        return this.listWithServiceResponseAsync(resourceGroupName, resourceName, start, end).map((Func1)new Func1<ServiceResponse<List<AnnotationInner>>, List<AnnotationInner>>(){

            public List<AnnotationInner> call(ServiceResponse<List<AnnotationInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<AnnotationInner>>> listWithServiceResponseAsync(String resourceGroupName, String resourceName, String start, String end) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (start == null) {
            throw new IllegalArgumentException("Parameter start is required and cannot be null.");
        }
        if (end == null) {
            throw new IllegalArgumentException("Parameter end is required and cannot be null.");
        }
        return this.service.list(resourceGroupName, this.client.subscriptionId(), resourceName, this.client.apiVersion(), start, end, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<AnnotationInner>>>>(){

            public Observable<ServiceResponse<List<AnnotationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = AnnotationsInner.this.listDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl1)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<AnnotationInner>> listDelegate(Response<ResponseBody> response) throws AnnotationErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<AnnotationInner>>(){}.getType()).registerError(AnnotationErrorException.class).build(response);
    }

    public List<AnnotationInner> create(String resourceGroupName, String resourceName, AnnotationInner annotationProperties) {
        return (List)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, resourceName, annotationProperties).toBlocking().single()).body();
    }

    public ServiceFuture<List<AnnotationInner>> createAsync(String resourceGroupName, String resourceName, AnnotationInner annotationProperties, ServiceCallback<List<AnnotationInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, resourceName, annotationProperties), serviceCallback);
    }

    public Observable<List<AnnotationInner>> createAsync(String resourceGroupName, String resourceName, AnnotationInner annotationProperties) {
        return this.createWithServiceResponseAsync(resourceGroupName, resourceName, annotationProperties).map((Func1)new Func1<ServiceResponse<List<AnnotationInner>>, List<AnnotationInner>>(){

            public List<AnnotationInner> call(ServiceResponse<List<AnnotationInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<AnnotationInner>>> createWithServiceResponseAsync(String resourceGroupName, String resourceName, AnnotationInner annotationProperties) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (annotationProperties == null) {
            throw new IllegalArgumentException("Parameter annotationProperties is required and cannot be null.");
        }
        Validator.validate((Object)annotationProperties);
        return this.service.create(resourceGroupName, this.client.subscriptionId(), resourceName, this.client.apiVersion(), annotationProperties, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<AnnotationInner>>>>(){

            public Observable<ServiceResponse<List<AnnotationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AnnotationsInner.this.createDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<List<AnnotationInner>> createDelegate(Response<ResponseBody> response) throws AnnotationErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<List<AnnotationInner>>(){}.getType()).registerError(AnnotationErrorException.class).build(response);
    }

    public Object delete(String resourceGroupName, String resourceName, String annotationId) {
        return ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, resourceName, annotationId).toBlocking().single()).body();
    }

    public ServiceFuture<Object> deleteAsync(String resourceGroupName, String resourceName, String annotationId, ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, resourceName, annotationId), serviceCallback);
    }

    public Observable<Object> deleteAsync(String resourceGroupName, String resourceName, String annotationId) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, resourceName, annotationId).map((Func1)new Func1<ServiceResponse<Object>, Object>(){

            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    public Observable<ServiceResponse<Object>> deleteWithServiceResponseAsync(String resourceGroupName, String resourceName, String annotationId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (annotationId == null) {
            throw new IllegalArgumentException("Parameter annotationId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(resourceGroupName, this.client.subscriptionId(), resourceName, annotationId, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AnnotationsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Object> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Object>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<AnnotationInner> get(String resourceGroupName, String resourceName, String annotationId) {
        return (List)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, resourceName, annotationId).toBlocking().single()).body();
    }

    public ServiceFuture<List<AnnotationInner>> getAsync(String resourceGroupName, String resourceName, String annotationId, ServiceCallback<List<AnnotationInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, resourceName, annotationId), serviceCallback);
    }

    public Observable<List<AnnotationInner>> getAsync(String resourceGroupName, String resourceName, String annotationId) {
        return this.getWithServiceResponseAsync(resourceGroupName, resourceName, annotationId).map((Func1)new Func1<ServiceResponse<List<AnnotationInner>>, List<AnnotationInner>>(){

            public List<AnnotationInner> call(ServiceResponse<List<AnnotationInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<AnnotationInner>>> getWithServiceResponseAsync(String resourceGroupName, String resourceName, String annotationId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (annotationId == null) {
            throw new IllegalArgumentException("Parameter annotationId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, this.client.subscriptionId(), resourceName, annotationId, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<AnnotationInner>>>>(){

            public Observable<ServiceResponse<List<AnnotationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AnnotationsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<List<AnnotationInner>> getDelegate(Response<ResponseBody> response) throws AnnotationErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<List<AnnotationInner>>(){}.getType()).registerError(AnnotationErrorException.class).build(response);
    }

    static interface AnnotationsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.Annotations list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/Annotations")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Query(value="start") String var5, @Query(value="end") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.Annotations create"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/Annotations")
        public Observable<Response<ResponseBody>> create(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Body AnnotationInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.Annotations delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/Annotations/{annotationId}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Path(value="resourceName") String var3, @Path(value="annotationId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.Annotations get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/Annotations/{annotationId}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Path(value="resourceName") String var3, @Path(value="annotationId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);
    }
}

