/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation;

import com.microsoft.azure.arm.model.implementation.IndexableRefreshableWrapperImpl;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.ApplicationInsightsComponentAPIKey;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.APIKeysInner;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ApplicationInsightsComponentAPIKeyInner;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ApplicationInsightsManagementClientImpl;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.IdParsingUtils;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.InsightsManager;
import java.util.List;
import rx.Observable;

class ApplicationInsightsComponentAPIKeyImpl
extends IndexableRefreshableWrapperImpl<ApplicationInsightsComponentAPIKey, ApplicationInsightsComponentAPIKeyInner>
implements ApplicationInsightsComponentAPIKey {
    private final InsightsManager manager;
    private String resourceGroupName;
    private String resourceName;
    private String keyId;

    ApplicationInsightsComponentAPIKeyImpl(ApplicationInsightsComponentAPIKeyInner inner, InsightsManager manager) {
        super(null, (Object)inner);
        this.manager = manager;
        this.resourceGroupName = IdParsingUtils.getValueFromIdByName(inner.id(), "resourceGroups");
        this.resourceName = IdParsingUtils.getValueFromIdByName(inner.id(), "components");
        this.keyId = IdParsingUtils.getValueFromIdByName(inner.id(), "APIKeys");
    }

    public InsightsManager manager() {
        return this.manager;
    }

    protected Observable<ApplicationInsightsComponentAPIKeyInner> getInnerAsync() {
        APIKeysInner client = ((ApplicationInsightsManagementClientImpl)((Object)this.manager().inner())).aPIKeys();
        return client.getAsync(this.resourceGroupName, this.resourceName, this.keyId);
    }

    @Override
    public String apiKey() {
        return ((ApplicationInsightsComponentAPIKeyInner)this.inner()).apiKey();
    }

    @Override
    public String createdDate() {
        return ((ApplicationInsightsComponentAPIKeyInner)this.inner()).createdDate();
    }

    @Override
    public String id() {
        return ((ApplicationInsightsComponentAPIKeyInner)this.inner()).id();
    }

    @Override
    public List<String> linkedReadProperties() {
        return ((ApplicationInsightsComponentAPIKeyInner)this.inner()).linkedReadProperties();
    }

    @Override
    public List<String> linkedWriteProperties() {
        return ((ApplicationInsightsComponentAPIKeyInner)this.inner()).linkedWriteProperties();
    }

    @Override
    public String name() {
        return ((ApplicationInsightsComponentAPIKeyInner)this.inner()).name();
    }
}

