/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation;

import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.APIKeysInner;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.AnalyticsItemsInner;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.AnnotationsInner;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ComponentAvailableFeaturesInner;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ComponentCurrentBillingFeaturesInner;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ComponentFeatureCapabilitiesInner;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ComponentQuotaStatusInner;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ComponentsInner;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ExportConfigurationsInner;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.FavoritesInner;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.OperationsInner;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ProactiveDetectionConfigurationsInner;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.WebTestLocationsInner;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.WebTestsInner;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.WorkItemConfigurationsInner;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.WorkbooksInner;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;

public class ApplicationInsightsManagementClientImpl
extends AzureServiceClient {
    private AzureClient azureClient;
    private String apiVersion;
    private String subscriptionId;
    private String acceptLanguage;
    private int longRunningOperationRetryTimeout;
    private boolean generateClientRequestId;
    private OperationsInner operations;
    private AnnotationsInner annotations;
    private APIKeysInner aPIKeys;
    private ExportConfigurationsInner exportConfigurations;
    private ComponentCurrentBillingFeaturesInner componentCurrentBillingFeatures;
    private ComponentQuotaStatusInner componentQuotaStatus;
    private ComponentFeatureCapabilitiesInner componentFeatureCapabilities;
    private ComponentAvailableFeaturesInner componentAvailableFeatures;
    private ProactiveDetectionConfigurationsInner proactiveDetectionConfigurations;
    private ComponentsInner components;
    private WorkItemConfigurationsInner workItemConfigurations;
    private FavoritesInner favorites;
    private WebTestLocationsInner webTestLocations;
    private WebTestsInner webTests;
    private AnalyticsItemsInner analyticsItems;
    private WorkbooksInner workbooks;

    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    public String apiVersion() {
        return this.apiVersion;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public ApplicationInsightsManagementClientImpl withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public ApplicationInsightsManagementClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    public ApplicationInsightsManagementClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    public ApplicationInsightsManagementClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    public OperationsInner operations() {
        return this.operations;
    }

    public AnnotationsInner annotations() {
        return this.annotations;
    }

    public APIKeysInner aPIKeys() {
        return this.aPIKeys;
    }

    public ExportConfigurationsInner exportConfigurations() {
        return this.exportConfigurations;
    }

    public ComponentCurrentBillingFeaturesInner componentCurrentBillingFeatures() {
        return this.componentCurrentBillingFeatures;
    }

    public ComponentQuotaStatusInner componentQuotaStatus() {
        return this.componentQuotaStatus;
    }

    public ComponentFeatureCapabilitiesInner componentFeatureCapabilities() {
        return this.componentFeatureCapabilities;
    }

    public ComponentAvailableFeaturesInner componentAvailableFeatures() {
        return this.componentAvailableFeatures;
    }

    public ProactiveDetectionConfigurationsInner proactiveDetectionConfigurations() {
        return this.proactiveDetectionConfigurations;
    }

    public ComponentsInner components() {
        return this.components;
    }

    public WorkItemConfigurationsInner workItemConfigurations() {
        return this.workItemConfigurations;
    }

    public FavoritesInner favorites() {
        return this.favorites;
    }

    public WebTestLocationsInner webTestLocations() {
        return this.webTestLocations;
    }

    public WebTestsInner webTests() {
        return this.webTests;
    }

    public AnalyticsItemsInner analyticsItems() {
        return this.analyticsItems;
    }

    public WorkbooksInner workbooks() {
        return this.workbooks;
    }

    public ApplicationInsightsManagementClientImpl(ServiceClientCredentials credentials) {
        this("https://management.azure.com", credentials);
    }

    public ApplicationInsightsManagementClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        this.initialize();
    }

    public ApplicationInsightsManagementClientImpl(RestClient restClient) {
        super(restClient);
        this.initialize();
    }

    protected void initialize() {
        this.apiVersion = "2015-05-01";
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.operations = new OperationsInner(this.restClient().retrofit(), this);
        this.annotations = new AnnotationsInner(this.restClient().retrofit(), this);
        this.aPIKeys = new APIKeysInner(this.restClient().retrofit(), this);
        this.exportConfigurations = new ExportConfigurationsInner(this.restClient().retrofit(), this);
        this.componentCurrentBillingFeatures = new ComponentCurrentBillingFeaturesInner(this.restClient().retrofit(), this);
        this.componentQuotaStatus = new ComponentQuotaStatusInner(this.restClient().retrofit(), this);
        this.componentFeatureCapabilities = new ComponentFeatureCapabilitiesInner(this.restClient().retrofit(), this);
        this.componentAvailableFeatures = new ComponentAvailableFeaturesInner(this.restClient().retrofit(), this);
        this.proactiveDetectionConfigurations = new ProactiveDetectionConfigurationsInner(this.restClient().retrofit(), this);
        this.components = new ComponentsInner(this.restClient().retrofit(), this);
        this.workItemConfigurations = new WorkItemConfigurationsInner(this.restClient().retrofit(), this);
        this.favorites = new FavoritesInner(this.restClient().retrofit(), this);
        this.webTestLocations = new WebTestLocationsInner(this.restClient().retrofit(), this);
        this.webTests = new WebTestsInner(this.restClient().retrofit(), this);
        this.analyticsItems = new AnalyticsItemsInner(this.restClient().retrofit(), this);
        this.workbooks = new WorkbooksInner(this.restClient().retrofit(), this);
        this.azureClient = new AzureClient((AzureServiceClient)this);
    }

    public String userAgent() {
        return String.format("%s (%s, %s)", super.userAgent(), "ApplicationInsightsManagementClient", "2015-05-01");
    }
}

