/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ApplicationInsightsComponentBillingFeaturesInner;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ApplicationInsightsManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class ComponentCurrentBillingFeaturesInner {
    private ComponentCurrentBillingFeaturesService service;
    private ApplicationInsightsManagementClientImpl client;

    public ComponentCurrentBillingFeaturesInner(Retrofit retrofit, ApplicationInsightsManagementClientImpl client) {
        this.service = (ComponentCurrentBillingFeaturesService)retrofit.create(ComponentCurrentBillingFeaturesService.class);
        this.client = client;
    }

    public ApplicationInsightsComponentBillingFeaturesInner get(String resourceGroupName, String resourceName) {
        return (ApplicationInsightsComponentBillingFeaturesInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().single()).body();
    }

    public ServiceFuture<ApplicationInsightsComponentBillingFeaturesInner> getAsync(String resourceGroupName, String resourceName, ServiceCallback<ApplicationInsightsComponentBillingFeaturesInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    public Observable<ApplicationInsightsComponentBillingFeaturesInner> getAsync(String resourceGroupName, String resourceName) {
        return this.getWithServiceResponseAsync(resourceGroupName, resourceName).map((Func1)new Func1<ServiceResponse<ApplicationInsightsComponentBillingFeaturesInner>, ApplicationInsightsComponentBillingFeaturesInner>(){

            public ApplicationInsightsComponentBillingFeaturesInner call(ServiceResponse<ApplicationInsightsComponentBillingFeaturesInner> response) {
                return (ApplicationInsightsComponentBillingFeaturesInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ApplicationInsightsComponentBillingFeaturesInner>> getWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, this.client.subscriptionId(), resourceName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationInsightsComponentBillingFeaturesInner>>>(){

            public Observable<ServiceResponse<ApplicationInsightsComponentBillingFeaturesInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ComponentCurrentBillingFeaturesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ApplicationInsightsComponentBillingFeaturesInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ApplicationInsightsComponentBillingFeaturesInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ApplicationInsightsComponentBillingFeaturesInner update(String resourceGroupName, String resourceName, ApplicationInsightsComponentBillingFeaturesInner billingFeaturesProperties) {
        return (ApplicationInsightsComponentBillingFeaturesInner)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, resourceName, billingFeaturesProperties).toBlocking().single()).body();
    }

    public ServiceFuture<ApplicationInsightsComponentBillingFeaturesInner> updateAsync(String resourceGroupName, String resourceName, ApplicationInsightsComponentBillingFeaturesInner billingFeaturesProperties, ServiceCallback<ApplicationInsightsComponentBillingFeaturesInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, resourceName, billingFeaturesProperties), serviceCallback);
    }

    public Observable<ApplicationInsightsComponentBillingFeaturesInner> updateAsync(String resourceGroupName, String resourceName, ApplicationInsightsComponentBillingFeaturesInner billingFeaturesProperties) {
        return this.updateWithServiceResponseAsync(resourceGroupName, resourceName, billingFeaturesProperties).map((Func1)new Func1<ServiceResponse<ApplicationInsightsComponentBillingFeaturesInner>, ApplicationInsightsComponentBillingFeaturesInner>(){

            public ApplicationInsightsComponentBillingFeaturesInner call(ServiceResponse<ApplicationInsightsComponentBillingFeaturesInner> response) {
                return (ApplicationInsightsComponentBillingFeaturesInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ApplicationInsightsComponentBillingFeaturesInner>> updateWithServiceResponseAsync(String resourceGroupName, String resourceName, ApplicationInsightsComponentBillingFeaturesInner billingFeaturesProperties) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (billingFeaturesProperties == null) {
            throw new IllegalArgumentException("Parameter billingFeaturesProperties is required and cannot be null.");
        }
        Validator.validate((Object)billingFeaturesProperties);
        return this.service.update(resourceGroupName, this.client.subscriptionId(), resourceName, this.client.apiVersion(), billingFeaturesProperties, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationInsightsComponentBillingFeaturesInner>>>(){

            public Observable<ServiceResponse<ApplicationInsightsComponentBillingFeaturesInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ComponentCurrentBillingFeaturesInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ApplicationInsightsComponentBillingFeaturesInner> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ApplicationInsightsComponentBillingFeaturesInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ComponentCurrentBillingFeaturesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.ComponentCurrentBillingFeatures get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/currentbillingfeatures")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.ComponentCurrentBillingFeatures update"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/currentbillingfeatures")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Body ApplicationInsightsComponentBillingFeaturesInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);
    }
}

