/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ApplicationInsightsComponentQuotaStatusInner;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ApplicationInsightsManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class ComponentQuotaStatusInner {
    private ComponentQuotaStatusService service;
    private ApplicationInsightsManagementClientImpl client;

    public ComponentQuotaStatusInner(Retrofit retrofit, ApplicationInsightsManagementClientImpl client) {
        this.service = (ComponentQuotaStatusService)retrofit.create(ComponentQuotaStatusService.class);
        this.client = client;
    }

    public ApplicationInsightsComponentQuotaStatusInner get(String resourceGroupName, String resourceName) {
        return (ApplicationInsightsComponentQuotaStatusInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().single()).body();
    }

    public ServiceFuture<ApplicationInsightsComponentQuotaStatusInner> getAsync(String resourceGroupName, String resourceName, ServiceCallback<ApplicationInsightsComponentQuotaStatusInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    public Observable<ApplicationInsightsComponentQuotaStatusInner> getAsync(String resourceGroupName, String resourceName) {
        return this.getWithServiceResponseAsync(resourceGroupName, resourceName).map((Func1)new Func1<ServiceResponse<ApplicationInsightsComponentQuotaStatusInner>, ApplicationInsightsComponentQuotaStatusInner>(){

            public ApplicationInsightsComponentQuotaStatusInner call(ServiceResponse<ApplicationInsightsComponentQuotaStatusInner> response) {
                return (ApplicationInsightsComponentQuotaStatusInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ApplicationInsightsComponentQuotaStatusInner>> getWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, this.client.subscriptionId(), resourceName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationInsightsComponentQuotaStatusInner>>>(){

            public Observable<ServiceResponse<ApplicationInsightsComponentQuotaStatusInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ComponentQuotaStatusInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ApplicationInsightsComponentQuotaStatusInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ApplicationInsightsComponentQuotaStatusInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ComponentQuotaStatusService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.ComponentQuotaStatus get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/quotastatus")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);
    }
}

