/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.arm.resources.ResourceUtilsCore;
import com.microsoft.azure.arm.resources.collection.implementation.GroupableResourcesCoreImpl;
import com.microsoft.azure.arm.resources.implementation.ManagerBaseCore;
import com.microsoft.azure.arm.utils.RXMapper;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.ApplicationInsightsComponent;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.ComponentPurgeBody;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.ComponentPurgeResponse;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.ComponentPurgeStatusResponse;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.Components;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ApplicationInsightsComponentImpl;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ApplicationInsightsComponentInner;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ApplicationInsightsManagementClientImpl;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ComponentPurgeResponseImpl;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ComponentPurgeResponseInner;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ComponentPurgeStatusResponseImpl;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ComponentPurgeStatusResponseInner;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ComponentsInner;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.IdParsingUtils;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.InsightsManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

class ComponentsImpl
extends GroupableResourcesCoreImpl<ApplicationInsightsComponent, ApplicationInsightsComponentImpl, ApplicationInsightsComponentInner, ComponentsInner, InsightsManager>
implements Components {
    protected ComponentsImpl(InsightsManager manager) {
        super((Object)((ApplicationInsightsManagementClientImpl)((Object)manager.inner())).components(), (ManagerBaseCore)manager);
    }

    protected Observable<ApplicationInsightsComponentInner> getInnerAsync(String resourceGroupName, String name) {
        ComponentsInner client = (ComponentsInner)this.inner();
        return client.getByResourceGroupAsync(resourceGroupName, name);
    }

    protected Completable deleteInnerAsync(String resourceGroupName, String name) {
        ComponentsInner client = (ComponentsInner)this.inner();
        return client.deleteAsync(resourceGroupName, name).toCompletable();
    }

    public Observable<String> deleteByIdsAsync(Collection<String> ids) {
        if (ids == null || ids.isEmpty()) {
            return Observable.empty();
        }
        ArrayList<Observable> observables = new ArrayList<Observable>();
        for (String id : ids) {
            String resourceGroupName = ResourceUtilsCore.groupFromResourceId((String)id);
            String name = ResourceUtilsCore.nameFromResourceId((String)id);
            Observable o = RXMapper.map(((ComponentsInner)this.inner()).deleteAsync(resourceGroupName, name), (Object)id);
            observables.add(o);
        }
        return Observable.mergeDelayError(observables);
    }

    public Observable<String> deleteByIdsAsync(String ... ids) {
        return this.deleteByIdsAsync(new ArrayList<String>(Arrays.asList(ids)));
    }

    public void deleteByIds(Collection<String> ids) {
        if (ids != null && !ids.isEmpty()) {
            this.deleteByIdsAsync(ids).toBlocking().last();
        }
    }

    public void deleteByIds(String ... ids) {
        this.deleteByIds(new ArrayList<String>(Arrays.asList(ids)));
    }

    public PagedList<ApplicationInsightsComponent> listByResourceGroup(String resourceGroupName) {
        ComponentsInner client = (ComponentsInner)this.inner();
        return this.wrapList(client.listByResourceGroup(resourceGroupName));
    }

    public Observable<ApplicationInsightsComponent> listByResourceGroupAsync(String resourceGroupName) {
        ComponentsInner client = (ComponentsInner)this.inner();
        return client.listByResourceGroupAsync(resourceGroupName).flatMapIterable((Func1)new Func1<Page<ApplicationInsightsComponentInner>, Iterable<ApplicationInsightsComponentInner>>(){

            public Iterable<ApplicationInsightsComponentInner> call(Page<ApplicationInsightsComponentInner> page) {
                return page.items();
            }
        }).map((Func1)new Func1<ApplicationInsightsComponentInner, ApplicationInsightsComponent>(){

            public ApplicationInsightsComponent call(ApplicationInsightsComponentInner inner) {
                return ComponentsImpl.this.wrapModel(inner);
            }
        });
    }

    public PagedList<ApplicationInsightsComponent> list() {
        ComponentsInner client = (ComponentsInner)this.inner();
        return this.wrapList(client.list());
    }

    public Observable<ApplicationInsightsComponent> listAsync() {
        ComponentsInner client = (ComponentsInner)this.inner();
        return client.listAsync().flatMapIterable((Func1)new Func1<Page<ApplicationInsightsComponentInner>, Iterable<ApplicationInsightsComponentInner>>(){

            public Iterable<ApplicationInsightsComponentInner> call(Page<ApplicationInsightsComponentInner> page) {
                return page.items();
            }
        }).map((Func1)new Func1<ApplicationInsightsComponentInner, ApplicationInsightsComponent>(){

            public ApplicationInsightsComponent call(ApplicationInsightsComponentInner inner) {
                return ComponentsImpl.this.wrapModel(inner);
            }
        });
    }

    public ApplicationInsightsComponentImpl define(String name) {
        return this.wrapModel(name);
    }

    @Override
    public Observable<ComponentPurgeResponse> purgeAsync(String resourceGroupName, String resourceName, ComponentPurgeBody body) {
        ComponentsInner client = (ComponentsInner)this.inner();
        return client.purgeAsync(resourceGroupName, resourceName, body).map((Func1)new Func1<ComponentPurgeResponseInner, ComponentPurgeResponse>(){

            public ComponentPurgeResponse call(ComponentPurgeResponseInner inner) {
                return new ComponentPurgeResponseImpl(inner, (InsightsManager)ComponentsImpl.this.manager());
            }
        });
    }

    protected ApplicationInsightsComponentImpl wrapModel(ApplicationInsightsComponentInner inner) {
        return new ApplicationInsightsComponentImpl(inner.name(), inner, (InsightsManager)this.manager());
    }

    protected ApplicationInsightsComponentImpl wrapModel(String name) {
        return new ApplicationInsightsComponentImpl(name, new ApplicationInsightsComponentInner(), (InsightsManager)this.manager());
    }

    private ComponentPurgeStatusResponseImpl wrapComponentPurgeStatusResponseModel(ComponentPurgeStatusResponseInner inner) {
        return new ComponentPurgeStatusResponseImpl(inner, (InsightsManager)this.manager());
    }

    private Observable<ComponentPurgeStatusResponseInner> getComponentPurgeStatusResponseInnerUsingComponentsInnerAsync(String id) {
        String resourceGroupName = IdParsingUtils.getValueFromIdByName(id, "resourceGroups");
        String resourceName = IdParsingUtils.getValueFromIdByName(id, "components");
        String purgeId = IdParsingUtils.getValueFromIdByName(id, "operations");
        ComponentsInner client = (ComponentsInner)this.inner();
        return client.getPurgeStatusAsync(resourceGroupName, resourceName, purgeId);
    }

    @Override
    public Observable<ComponentPurgeStatusResponse> getPurgeStatusAsync(String resourceGroupName, String resourceName, String purgeId) {
        ComponentsInner client = (ComponentsInner)this.inner();
        return client.getPurgeStatusAsync(resourceGroupName, resourceName, purgeId).map((Func1)new Func1<ComponentPurgeStatusResponseInner, ComponentPurgeStatusResponse>(){

            public ComponentPurgeStatusResponse call(ComponentPurgeStatusResponseInner inner) {
                return ComponentsImpl.this.wrapComponentPurgeStatusResponseModel(inner);
            }
        });
    }
}

