/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.arm.collection.InnerSupportsDelete;
import com.microsoft.azure.arm.collection.InnerSupportsGet;
import com.microsoft.azure.arm.collection.InnerSupportsListing;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.ComponentPurgeBody;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.TagsResource;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ApplicationInsightsComponentInner;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ApplicationInsightsManagementClientImpl;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ComponentPurgeResponseInner;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ComponentPurgeStatusResponseInner;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.PageImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ComponentsInner
implements InnerSupportsGet<ApplicationInsightsComponentInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<ApplicationInsightsComponentInner> {
    private ComponentsService service;
    private ApplicationInsightsManagementClientImpl client;

    public ComponentsInner(Retrofit retrofit, ApplicationInsightsManagementClientImpl client) {
        this.service = (ComponentsService)retrofit.create(ComponentsService.class);
        this.client = client;
    }

    public PagedList<ApplicationInsightsComponentInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<ApplicationInsightsComponentInner>((Page)response.body()){

            public Page<ApplicationInsightsComponentInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ComponentsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ApplicationInsightsComponentInner>> listAsync(ListOperationCallback<ApplicationInsightsComponentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<ApplicationInsightsComponentInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationInsightsComponentInner>>> call(String nextPageLink) {
                return ComponentsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ApplicationInsightsComponentInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<ApplicationInsightsComponentInner>>, Page<ApplicationInsightsComponentInner>>(){

            public Page<ApplicationInsightsComponentInner> call(ServiceResponse<Page<ApplicationInsightsComponentInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationInsightsComponentInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<ApplicationInsightsComponentInner>>, Observable<ServiceResponse<Page<ApplicationInsightsComponentInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationInsightsComponentInner>>> call(ServiceResponse<Page<ApplicationInsightsComponentInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ComponentsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationInsightsComponentInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ApplicationInsightsComponentInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationInsightsComponentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ComponentsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ApplicationInsightsComponentInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ApplicationInsightsComponentInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ApplicationInsightsComponentInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<ApplicationInsightsComponentInner>((Page)response.body()){

            public Page<ApplicationInsightsComponentInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ComponentsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ApplicationInsightsComponentInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<ApplicationInsightsComponentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ApplicationInsightsComponentInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationInsightsComponentInner>>> call(String nextPageLink) {
                return ComponentsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ApplicationInsightsComponentInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<ApplicationInsightsComponentInner>>, Page<ApplicationInsightsComponentInner>>(){

            public Page<ApplicationInsightsComponentInner> call(ServiceResponse<Page<ApplicationInsightsComponentInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationInsightsComponentInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<ApplicationInsightsComponentInner>>, Observable<ServiceResponse<Page<ApplicationInsightsComponentInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationInsightsComponentInner>>> call(ServiceResponse<Page<ApplicationInsightsComponentInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ComponentsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationInsightsComponentInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ApplicationInsightsComponentInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationInsightsComponentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ComponentsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ApplicationInsightsComponentInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ApplicationInsightsComponentInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String resourceName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String resourceName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String resourceName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, resourceName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(resourceGroupName, this.client.subscriptionId(), resourceName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ComponentsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ApplicationInsightsComponentInner getByResourceGroup(String resourceGroupName, String resourceName) {
        return (ApplicationInsightsComponentInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().single()).body());
    }

    public ServiceFuture<ApplicationInsightsComponentInner> getByResourceGroupAsync(String resourceGroupName, String resourceName, ServiceCallback<ApplicationInsightsComponentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    public Observable<ApplicationInsightsComponentInner> getByResourceGroupAsync(String resourceGroupName, String resourceName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, resourceName).map((Func1)new Func1<ServiceResponse<ApplicationInsightsComponentInner>, ApplicationInsightsComponentInner>(){

            public ApplicationInsightsComponentInner call(ServiceResponse<ApplicationInsightsComponentInner> response) {
                return (ApplicationInsightsComponentInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ApplicationInsightsComponentInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getByResourceGroup(resourceGroupName, this.client.subscriptionId(), resourceName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationInsightsComponentInner>>>(){

            public Observable<ServiceResponse<ApplicationInsightsComponentInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ComponentsInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ApplicationInsightsComponentInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ApplicationInsightsComponentInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ApplicationInsightsComponentInner createOrUpdate(String resourceGroupName, String resourceName, ApplicationInsightsComponentInner insightProperties) {
        return (ApplicationInsightsComponentInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, resourceName, insightProperties).toBlocking().single()).body());
    }

    public ServiceFuture<ApplicationInsightsComponentInner> createOrUpdateAsync(String resourceGroupName, String resourceName, ApplicationInsightsComponentInner insightProperties, ServiceCallback<ApplicationInsightsComponentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, resourceName, insightProperties), serviceCallback);
    }

    public Observable<ApplicationInsightsComponentInner> createOrUpdateAsync(String resourceGroupName, String resourceName, ApplicationInsightsComponentInner insightProperties) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, resourceName, insightProperties).map((Func1)new Func1<ServiceResponse<ApplicationInsightsComponentInner>, ApplicationInsightsComponentInner>(){

            public ApplicationInsightsComponentInner call(ServiceResponse<ApplicationInsightsComponentInner> response) {
                return (ApplicationInsightsComponentInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ApplicationInsightsComponentInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String resourceName, ApplicationInsightsComponentInner insightProperties) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (insightProperties == null) {
            throw new IllegalArgumentException("Parameter insightProperties is required and cannot be null.");
        }
        Validator.validate((Object)((Object)insightProperties));
        return this.service.createOrUpdate(resourceGroupName, this.client.subscriptionId(), resourceName, this.client.apiVersion(), insightProperties, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationInsightsComponentInner>>>(){

            public Observable<ServiceResponse<ApplicationInsightsComponentInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ComponentsInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ApplicationInsightsComponentInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ApplicationInsightsComponentInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ApplicationInsightsComponentInner updateTags(String resourceGroupName, String resourceName) {
        return (ApplicationInsightsComponentInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().single()).body());
    }

    public ServiceFuture<ApplicationInsightsComponentInner> updateTagsAsync(String resourceGroupName, String resourceName, ServiceCallback<ApplicationInsightsComponentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    public Observable<ApplicationInsightsComponentInner> updateTagsAsync(String resourceGroupName, String resourceName) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, resourceName).map((Func1)new Func1<ServiceResponse<ApplicationInsightsComponentInner>, ApplicationInsightsComponentInner>(){

            public ApplicationInsightsComponentInner call(ServiceResponse<ApplicationInsightsComponentInner> response) {
                return (ApplicationInsightsComponentInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ApplicationInsightsComponentInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object tags = null;
        TagsResource componentTags = new TagsResource();
        componentTags.withTags(null);
        return this.service.updateTags(resourceGroupName, this.client.subscriptionId(), resourceName, this.client.apiVersion(), this.client.acceptLanguage(), componentTags, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationInsightsComponentInner>>>(){

            public Observable<ServiceResponse<ApplicationInsightsComponentInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ComponentsInner.this.updateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public ApplicationInsightsComponentInner updateTags(String resourceGroupName, String resourceName, Map<String, String> tags) {
        return (ApplicationInsightsComponentInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, resourceName, tags).toBlocking().single()).body());
    }

    public ServiceFuture<ApplicationInsightsComponentInner> updateTagsAsync(String resourceGroupName, String resourceName, Map<String, String> tags, ServiceCallback<ApplicationInsightsComponentInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, resourceName, tags), serviceCallback);
    }

    public Observable<ApplicationInsightsComponentInner> updateTagsAsync(String resourceGroupName, String resourceName, Map<String, String> tags) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, resourceName, tags).map((Func1)new Func1<ServiceResponse<ApplicationInsightsComponentInner>, ApplicationInsightsComponentInner>(){

            public ApplicationInsightsComponentInner call(ServiceResponse<ApplicationInsightsComponentInner> response) {
                return (ApplicationInsightsComponentInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ApplicationInsightsComponentInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String resourceName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(tags);
        TagsResource componentTags = new TagsResource();
        componentTags.withTags(tags);
        return this.service.updateTags(resourceGroupName, this.client.subscriptionId(), resourceName, this.client.apiVersion(), this.client.acceptLanguage(), componentTags, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationInsightsComponentInner>>>(){

            public Observable<ServiceResponse<ApplicationInsightsComponentInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ComponentsInner.this.updateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ApplicationInsightsComponentInner> updateTagsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ApplicationInsightsComponentInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ComponentPurgeResponseInner purge(String resourceGroupName, String resourceName, ComponentPurgeBody body) {
        return (ComponentPurgeResponseInner)((ServiceResponse)this.purgeWithServiceResponseAsync(resourceGroupName, resourceName, body).toBlocking().single()).body();
    }

    public ServiceFuture<ComponentPurgeResponseInner> purgeAsync(String resourceGroupName, String resourceName, ComponentPurgeBody body, ServiceCallback<ComponentPurgeResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.purgeWithServiceResponseAsync(resourceGroupName, resourceName, body), serviceCallback);
    }

    public Observable<ComponentPurgeResponseInner> purgeAsync(String resourceGroupName, String resourceName, ComponentPurgeBody body) {
        return this.purgeWithServiceResponseAsync(resourceGroupName, resourceName, body).map((Func1)new Func1<ServiceResponse<ComponentPurgeResponseInner>, ComponentPurgeResponseInner>(){

            public ComponentPurgeResponseInner call(ServiceResponse<ComponentPurgeResponseInner> response) {
                return (ComponentPurgeResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ComponentPurgeResponseInner>> purgeWithServiceResponseAsync(String resourceGroupName, String resourceName, ComponentPurgeBody body) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        Validator.validate((Object)body);
        return this.service.purge(resourceGroupName, this.client.subscriptionId(), resourceName, this.client.apiVersion(), body, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ComponentPurgeResponseInner>>>(){

            public Observable<ServiceResponse<ComponentPurgeResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ComponentsInner.this.purgeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ComponentPurgeResponseInner> purgeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<ComponentPurgeResponseInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ComponentPurgeStatusResponseInner getPurgeStatus(String resourceGroupName, String resourceName, String purgeId) {
        return (ComponentPurgeStatusResponseInner)((ServiceResponse)this.getPurgeStatusWithServiceResponseAsync(resourceGroupName, resourceName, purgeId).toBlocking().single()).body();
    }

    public ServiceFuture<ComponentPurgeStatusResponseInner> getPurgeStatusAsync(String resourceGroupName, String resourceName, String purgeId, ServiceCallback<ComponentPurgeStatusResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getPurgeStatusWithServiceResponseAsync(resourceGroupName, resourceName, purgeId), serviceCallback);
    }

    public Observable<ComponentPurgeStatusResponseInner> getPurgeStatusAsync(String resourceGroupName, String resourceName, String purgeId) {
        return this.getPurgeStatusWithServiceResponseAsync(resourceGroupName, resourceName, purgeId).map((Func1)new Func1<ServiceResponse<ComponentPurgeStatusResponseInner>, ComponentPurgeStatusResponseInner>(){

            public ComponentPurgeStatusResponseInner call(ServiceResponse<ComponentPurgeStatusResponseInner> response) {
                return (ComponentPurgeStatusResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ComponentPurgeStatusResponseInner>> getPurgeStatusWithServiceResponseAsync(String resourceGroupName, String resourceName, String purgeId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (purgeId == null) {
            throw new IllegalArgumentException("Parameter purgeId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getPurgeStatus(resourceGroupName, this.client.subscriptionId(), resourceName, purgeId, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ComponentPurgeStatusResponseInner>>>(){

            public Observable<ServiceResponse<ComponentPurgeStatusResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ComponentsInner.this.getPurgeStatusDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ComponentPurgeStatusResponseInner> getPurgeStatusDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ComponentPurgeStatusResponseInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ApplicationInsightsComponentInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ApplicationInsightsComponentInner>((Page)response.body()){

            public Page<ApplicationInsightsComponentInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ComponentsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ApplicationInsightsComponentInner>> listNextAsync(String nextPageLink, ServiceFuture<List<ApplicationInsightsComponentInner>> serviceFuture, ListOperationCallback<ApplicationInsightsComponentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ApplicationInsightsComponentInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationInsightsComponentInner>>> call(String nextPageLink) {
                return ComponentsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ApplicationInsightsComponentInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ApplicationInsightsComponentInner>>, Page<ApplicationInsightsComponentInner>>(){

            public Page<ApplicationInsightsComponentInner> call(ServiceResponse<Page<ApplicationInsightsComponentInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationInsightsComponentInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ApplicationInsightsComponentInner>>, Observable<ServiceResponse<Page<ApplicationInsightsComponentInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationInsightsComponentInner>>> call(ServiceResponse<Page<ApplicationInsightsComponentInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ComponentsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationInsightsComponentInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ApplicationInsightsComponentInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationInsightsComponentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ComponentsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ApplicationInsightsComponentInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ApplicationInsightsComponentInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ApplicationInsightsComponentInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ApplicationInsightsComponentInner>((Page)response.body()){

            public Page<ApplicationInsightsComponentInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ComponentsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ApplicationInsightsComponentInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<ApplicationInsightsComponentInner>> serviceFuture, ListOperationCallback<ApplicationInsightsComponentInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ApplicationInsightsComponentInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationInsightsComponentInner>>> call(String nextPageLink) {
                return ComponentsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ApplicationInsightsComponentInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ApplicationInsightsComponentInner>>, Page<ApplicationInsightsComponentInner>>(){

            public Page<ApplicationInsightsComponentInner> call(ServiceResponse<Page<ApplicationInsightsComponentInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationInsightsComponentInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ApplicationInsightsComponentInner>>, Observable<ServiceResponse<Page<ApplicationInsightsComponentInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationInsightsComponentInner>>> call(ServiceResponse<Page<ApplicationInsightsComponentInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ComponentsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationInsightsComponentInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ApplicationInsightsComponentInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationInsightsComponentInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ComponentsInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ApplicationInsightsComponentInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ApplicationInsightsComponentInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ComponentsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.Components list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Insights/components")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.Components listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.Components delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.Components getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.Components createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Body ApplicationInsightsComponentInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.Components updateTags"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}")
        public Observable<Response<ResponseBody>> updateTags(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body TagsResource var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.Components purge"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/purge")
        public Observable<Response<ResponseBody>> purge(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Body ComponentPurgeBody var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.Components getPurgeStatus"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/operations/{purgeId}")
        public Observable<Response<ResponseBody>> getPurgeStatus(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Path(value="resourceName") String var3, @Path(value="purgeId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.Components listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.Components listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

