/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.ApplicationInsightsComponentExportRequest;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ApplicationInsightsComponentExportConfigurationInner;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ApplicationInsightsManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class ExportConfigurationsInner {
    private ExportConfigurationsService service;
    private ApplicationInsightsManagementClientImpl client;

    public ExportConfigurationsInner(Retrofit retrofit, ApplicationInsightsManagementClientImpl client) {
        this.service = (ExportConfigurationsService)retrofit.create(ExportConfigurationsService.class);
        this.client = client;
    }

    public List<ApplicationInsightsComponentExportConfigurationInner> list(String resourceGroupName, String resourceName) {
        return (List)((ServiceResponse)this.listWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().single()).body();
    }

    public ServiceFuture<List<ApplicationInsightsComponentExportConfigurationInner>> listAsync(String resourceGroupName, String resourceName, ServiceCallback<List<ApplicationInsightsComponentExportConfigurationInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    public Observable<List<ApplicationInsightsComponentExportConfigurationInner>> listAsync(String resourceGroupName, String resourceName) {
        return this.listWithServiceResponseAsync(resourceGroupName, resourceName).map((Func1)new Func1<ServiceResponse<List<ApplicationInsightsComponentExportConfigurationInner>>, List<ApplicationInsightsComponentExportConfigurationInner>>(){

            public List<ApplicationInsightsComponentExportConfigurationInner> call(ServiceResponse<List<ApplicationInsightsComponentExportConfigurationInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<ApplicationInsightsComponentExportConfigurationInner>>> listWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(resourceGroupName, this.client.subscriptionId(), resourceName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<ApplicationInsightsComponentExportConfigurationInner>>>>(){

            public Observable<ServiceResponse<List<ApplicationInsightsComponentExportConfigurationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ExportConfigurationsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<List<ApplicationInsightsComponentExportConfigurationInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<List<ApplicationInsightsComponentExportConfigurationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<ApplicationInsightsComponentExportConfigurationInner> create(String resourceGroupName, String resourceName, ApplicationInsightsComponentExportRequest exportProperties) {
        return (List)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, resourceName, exportProperties).toBlocking().single()).body();
    }

    public ServiceFuture<List<ApplicationInsightsComponentExportConfigurationInner>> createAsync(String resourceGroupName, String resourceName, ApplicationInsightsComponentExportRequest exportProperties, ServiceCallback<List<ApplicationInsightsComponentExportConfigurationInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, resourceName, exportProperties), serviceCallback);
    }

    public Observable<List<ApplicationInsightsComponentExportConfigurationInner>> createAsync(String resourceGroupName, String resourceName, ApplicationInsightsComponentExportRequest exportProperties) {
        return this.createWithServiceResponseAsync(resourceGroupName, resourceName, exportProperties).map((Func1)new Func1<ServiceResponse<List<ApplicationInsightsComponentExportConfigurationInner>>, List<ApplicationInsightsComponentExportConfigurationInner>>(){

            public List<ApplicationInsightsComponentExportConfigurationInner> call(ServiceResponse<List<ApplicationInsightsComponentExportConfigurationInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<ApplicationInsightsComponentExportConfigurationInner>>> createWithServiceResponseAsync(String resourceGroupName, String resourceName, ApplicationInsightsComponentExportRequest exportProperties) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (exportProperties == null) {
            throw new IllegalArgumentException("Parameter exportProperties is required and cannot be null.");
        }
        Validator.validate((Object)exportProperties);
        return this.service.create(resourceGroupName, this.client.subscriptionId(), resourceName, this.client.apiVersion(), exportProperties, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<ApplicationInsightsComponentExportConfigurationInner>>>>(){

            public Observable<ServiceResponse<List<ApplicationInsightsComponentExportConfigurationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ExportConfigurationsInner.this.createDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<List<ApplicationInsightsComponentExportConfigurationInner>> createDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<List<ApplicationInsightsComponentExportConfigurationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ApplicationInsightsComponentExportConfigurationInner delete(String resourceGroupName, String resourceName, String exportId) {
        return (ApplicationInsightsComponentExportConfigurationInner)((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, resourceName, exportId).toBlocking().single()).body();
    }

    public ServiceFuture<ApplicationInsightsComponentExportConfigurationInner> deleteAsync(String resourceGroupName, String resourceName, String exportId, ServiceCallback<ApplicationInsightsComponentExportConfigurationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, resourceName, exportId), serviceCallback);
    }

    public Observable<ApplicationInsightsComponentExportConfigurationInner> deleteAsync(String resourceGroupName, String resourceName, String exportId) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, resourceName, exportId).map((Func1)new Func1<ServiceResponse<ApplicationInsightsComponentExportConfigurationInner>, ApplicationInsightsComponentExportConfigurationInner>(){

            public ApplicationInsightsComponentExportConfigurationInner call(ServiceResponse<ApplicationInsightsComponentExportConfigurationInner> response) {
                return (ApplicationInsightsComponentExportConfigurationInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ApplicationInsightsComponentExportConfigurationInner>> deleteWithServiceResponseAsync(String resourceGroupName, String resourceName, String exportId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (exportId == null) {
            throw new IllegalArgumentException("Parameter exportId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(resourceGroupName, this.client.subscriptionId(), resourceName, exportId, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationInsightsComponentExportConfigurationInner>>>(){

            public Observable<ServiceResponse<ApplicationInsightsComponentExportConfigurationInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ExportConfigurationsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ApplicationInsightsComponentExportConfigurationInner> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ApplicationInsightsComponentExportConfigurationInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ApplicationInsightsComponentExportConfigurationInner get(String resourceGroupName, String resourceName, String exportId) {
        return (ApplicationInsightsComponentExportConfigurationInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, resourceName, exportId).toBlocking().single()).body();
    }

    public ServiceFuture<ApplicationInsightsComponentExportConfigurationInner> getAsync(String resourceGroupName, String resourceName, String exportId, ServiceCallback<ApplicationInsightsComponentExportConfigurationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, resourceName, exportId), serviceCallback);
    }

    public Observable<ApplicationInsightsComponentExportConfigurationInner> getAsync(String resourceGroupName, String resourceName, String exportId) {
        return this.getWithServiceResponseAsync(resourceGroupName, resourceName, exportId).map((Func1)new Func1<ServiceResponse<ApplicationInsightsComponentExportConfigurationInner>, ApplicationInsightsComponentExportConfigurationInner>(){

            public ApplicationInsightsComponentExportConfigurationInner call(ServiceResponse<ApplicationInsightsComponentExportConfigurationInner> response) {
                return (ApplicationInsightsComponentExportConfigurationInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ApplicationInsightsComponentExportConfigurationInner>> getWithServiceResponseAsync(String resourceGroupName, String resourceName, String exportId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (exportId == null) {
            throw new IllegalArgumentException("Parameter exportId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, this.client.subscriptionId(), resourceName, exportId, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationInsightsComponentExportConfigurationInner>>>(){

            public Observable<ServiceResponse<ApplicationInsightsComponentExportConfigurationInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ExportConfigurationsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ApplicationInsightsComponentExportConfigurationInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ApplicationInsightsComponentExportConfigurationInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ApplicationInsightsComponentExportConfigurationInner update(String resourceGroupName, String resourceName, String exportId, ApplicationInsightsComponentExportRequest exportProperties) {
        return (ApplicationInsightsComponentExportConfigurationInner)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, resourceName, exportId, exportProperties).toBlocking().single()).body();
    }

    public ServiceFuture<ApplicationInsightsComponentExportConfigurationInner> updateAsync(String resourceGroupName, String resourceName, String exportId, ApplicationInsightsComponentExportRequest exportProperties, ServiceCallback<ApplicationInsightsComponentExportConfigurationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, resourceName, exportId, exportProperties), serviceCallback);
    }

    public Observable<ApplicationInsightsComponentExportConfigurationInner> updateAsync(String resourceGroupName, String resourceName, String exportId, ApplicationInsightsComponentExportRequest exportProperties) {
        return this.updateWithServiceResponseAsync(resourceGroupName, resourceName, exportId, exportProperties).map((Func1)new Func1<ServiceResponse<ApplicationInsightsComponentExportConfigurationInner>, ApplicationInsightsComponentExportConfigurationInner>(){

            public ApplicationInsightsComponentExportConfigurationInner call(ServiceResponse<ApplicationInsightsComponentExportConfigurationInner> response) {
                return (ApplicationInsightsComponentExportConfigurationInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ApplicationInsightsComponentExportConfigurationInner>> updateWithServiceResponseAsync(String resourceGroupName, String resourceName, String exportId, ApplicationInsightsComponentExportRequest exportProperties) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (exportId == null) {
            throw new IllegalArgumentException("Parameter exportId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (exportProperties == null) {
            throw new IllegalArgumentException("Parameter exportProperties is required and cannot be null.");
        }
        Validator.validate((Object)exportProperties);
        return this.service.update(resourceGroupName, this.client.subscriptionId(), resourceName, exportId, this.client.apiVersion(), exportProperties, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationInsightsComponentExportConfigurationInner>>>(){

            public Observable<ServiceResponse<ApplicationInsightsComponentExportConfigurationInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ExportConfigurationsInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ApplicationInsightsComponentExportConfigurationInner> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ApplicationInsightsComponentExportConfigurationInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ExportConfigurationsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.ExportConfigurations list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/exportconfiguration")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.ExportConfigurations create"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/exportconfiguration")
        public Observable<Response<ResponseBody>> create(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Body ApplicationInsightsComponentExportRequest var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.ExportConfigurations delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/exportconfiguration/{exportId}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Path(value="resourceName") String var3, @Path(value="exportId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.ExportConfigurations get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/exportconfiguration/{exportId}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Path(value="resourceName") String var3, @Path(value="exportId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.ExportConfigurations update"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/exportconfiguration/{exportId}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Path(value="resourceName") String var3, @Path(value="exportId") String var4, @Query(value="api-version") String var5, @Body ApplicationInsightsComponentExportRequest var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);
    }
}

