/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.FavoriteSourceType;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.FavoriteType;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ApplicationInsightsComponentFavoriteInner;
import com.microsoft.azure.management.applicationinsights.v2015_05_01.implementation.ApplicationInsightsManagementClientImpl;
import com.microsoft.rest.CollectionFormat;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class FavoritesInner {
    private FavoritesService service;
    private ApplicationInsightsManagementClientImpl client;

    public FavoritesInner(Retrofit retrofit, ApplicationInsightsManagementClientImpl client) {
        this.service = (FavoritesService)retrofit.create(FavoritesService.class);
        this.client = client;
    }

    public List<ApplicationInsightsComponentFavoriteInner> list(String resourceGroupName, String resourceName) {
        return (List)((ServiceResponse)this.listWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().single()).body();
    }

    public ServiceFuture<List<ApplicationInsightsComponentFavoriteInner>> listAsync(String resourceGroupName, String resourceName, ServiceCallback<List<ApplicationInsightsComponentFavoriteInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    public Observable<List<ApplicationInsightsComponentFavoriteInner>> listAsync(String resourceGroupName, String resourceName) {
        return this.listWithServiceResponseAsync(resourceGroupName, resourceName).map((Func1)new Func1<ServiceResponse<List<ApplicationInsightsComponentFavoriteInner>>, List<ApplicationInsightsComponentFavoriteInner>>(){

            public List<ApplicationInsightsComponentFavoriteInner> call(ServiceResponse<List<ApplicationInsightsComponentFavoriteInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<ApplicationInsightsComponentFavoriteInner>>> listWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        FavoriteType favoriteType = null;
        FavoriteSourceType sourceType = null;
        Boolean canFetchContent = null;
        List tags = null;
        String tagsConverted = this.client.serializerAdapter().serializeList(tags, CollectionFormat.CSV);
        return this.service.list(resourceGroupName, this.client.subscriptionId(), resourceName, this.client.apiVersion(), favoriteType, sourceType, canFetchContent, tagsConverted, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<ApplicationInsightsComponentFavoriteInner>>>>(){

            public Observable<ServiceResponse<List<ApplicationInsightsComponentFavoriteInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FavoritesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public List<ApplicationInsightsComponentFavoriteInner> list(String resourceGroupName, String resourceName, FavoriteType favoriteType, FavoriteSourceType sourceType, Boolean canFetchContent, List<String> tags) {
        return (List)((ServiceResponse)this.listWithServiceResponseAsync(resourceGroupName, resourceName, favoriteType, sourceType, canFetchContent, tags).toBlocking().single()).body();
    }

    public ServiceFuture<List<ApplicationInsightsComponentFavoriteInner>> listAsync(String resourceGroupName, String resourceName, FavoriteType favoriteType, FavoriteSourceType sourceType, Boolean canFetchContent, List<String> tags, ServiceCallback<List<ApplicationInsightsComponentFavoriteInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(resourceGroupName, resourceName, favoriteType, sourceType, canFetchContent, tags), serviceCallback);
    }

    public Observable<List<ApplicationInsightsComponentFavoriteInner>> listAsync(String resourceGroupName, String resourceName, FavoriteType favoriteType, FavoriteSourceType sourceType, Boolean canFetchContent, List<String> tags) {
        return this.listWithServiceResponseAsync(resourceGroupName, resourceName, favoriteType, sourceType, canFetchContent, tags).map((Func1)new Func1<ServiceResponse<List<ApplicationInsightsComponentFavoriteInner>>, List<ApplicationInsightsComponentFavoriteInner>>(){

            public List<ApplicationInsightsComponentFavoriteInner> call(ServiceResponse<List<ApplicationInsightsComponentFavoriteInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<ApplicationInsightsComponentFavoriteInner>>> listWithServiceResponseAsync(String resourceGroupName, String resourceName, FavoriteType favoriteType, FavoriteSourceType sourceType, Boolean canFetchContent, List<String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(tags);
        String tagsConverted = this.client.serializerAdapter().serializeList(tags, CollectionFormat.CSV);
        return this.service.list(resourceGroupName, this.client.subscriptionId(), resourceName, this.client.apiVersion(), favoriteType, sourceType, canFetchContent, tagsConverted, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<ApplicationInsightsComponentFavoriteInner>>>>(){

            public Observable<ServiceResponse<List<ApplicationInsightsComponentFavoriteInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FavoritesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<List<ApplicationInsightsComponentFavoriteInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<List<ApplicationInsightsComponentFavoriteInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ApplicationInsightsComponentFavoriteInner get(String resourceGroupName, String resourceName, String favoriteId) {
        return (ApplicationInsightsComponentFavoriteInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, resourceName, favoriteId).toBlocking().single()).body();
    }

    public ServiceFuture<ApplicationInsightsComponentFavoriteInner> getAsync(String resourceGroupName, String resourceName, String favoriteId, ServiceCallback<ApplicationInsightsComponentFavoriteInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, resourceName, favoriteId), serviceCallback);
    }

    public Observable<ApplicationInsightsComponentFavoriteInner> getAsync(String resourceGroupName, String resourceName, String favoriteId) {
        return this.getWithServiceResponseAsync(resourceGroupName, resourceName, favoriteId).map((Func1)new Func1<ServiceResponse<ApplicationInsightsComponentFavoriteInner>, ApplicationInsightsComponentFavoriteInner>(){

            public ApplicationInsightsComponentFavoriteInner call(ServiceResponse<ApplicationInsightsComponentFavoriteInner> response) {
                return (ApplicationInsightsComponentFavoriteInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ApplicationInsightsComponentFavoriteInner>> getWithServiceResponseAsync(String resourceGroupName, String resourceName, String favoriteId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (favoriteId == null) {
            throw new IllegalArgumentException("Parameter favoriteId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, this.client.subscriptionId(), resourceName, favoriteId, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationInsightsComponentFavoriteInner>>>(){

            public Observable<ServiceResponse<ApplicationInsightsComponentFavoriteInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FavoritesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ApplicationInsightsComponentFavoriteInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ApplicationInsightsComponentFavoriteInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ApplicationInsightsComponentFavoriteInner add(String resourceGroupName, String resourceName, String favoriteId, ApplicationInsightsComponentFavoriteInner favoriteProperties) {
        return (ApplicationInsightsComponentFavoriteInner)((ServiceResponse)this.addWithServiceResponseAsync(resourceGroupName, resourceName, favoriteId, favoriteProperties).toBlocking().single()).body();
    }

    public ServiceFuture<ApplicationInsightsComponentFavoriteInner> addAsync(String resourceGroupName, String resourceName, String favoriteId, ApplicationInsightsComponentFavoriteInner favoriteProperties, ServiceCallback<ApplicationInsightsComponentFavoriteInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.addWithServiceResponseAsync(resourceGroupName, resourceName, favoriteId, favoriteProperties), serviceCallback);
    }

    public Observable<ApplicationInsightsComponentFavoriteInner> addAsync(String resourceGroupName, String resourceName, String favoriteId, ApplicationInsightsComponentFavoriteInner favoriteProperties) {
        return this.addWithServiceResponseAsync(resourceGroupName, resourceName, favoriteId, favoriteProperties).map((Func1)new Func1<ServiceResponse<ApplicationInsightsComponentFavoriteInner>, ApplicationInsightsComponentFavoriteInner>(){

            public ApplicationInsightsComponentFavoriteInner call(ServiceResponse<ApplicationInsightsComponentFavoriteInner> response) {
                return (ApplicationInsightsComponentFavoriteInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ApplicationInsightsComponentFavoriteInner>> addWithServiceResponseAsync(String resourceGroupName, String resourceName, String favoriteId, ApplicationInsightsComponentFavoriteInner favoriteProperties) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (favoriteId == null) {
            throw new IllegalArgumentException("Parameter favoriteId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (favoriteProperties == null) {
            throw new IllegalArgumentException("Parameter favoriteProperties is required and cannot be null.");
        }
        Validator.validate((Object)favoriteProperties);
        return this.service.add(resourceGroupName, this.client.subscriptionId(), resourceName, favoriteId, this.client.apiVersion(), favoriteProperties, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationInsightsComponentFavoriteInner>>>(){

            public Observable<ServiceResponse<ApplicationInsightsComponentFavoriteInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FavoritesInner.this.addDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ApplicationInsightsComponentFavoriteInner> addDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ApplicationInsightsComponentFavoriteInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ApplicationInsightsComponentFavoriteInner update(String resourceGroupName, String resourceName, String favoriteId, ApplicationInsightsComponentFavoriteInner favoriteProperties) {
        return (ApplicationInsightsComponentFavoriteInner)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, resourceName, favoriteId, favoriteProperties).toBlocking().single()).body();
    }

    public ServiceFuture<ApplicationInsightsComponentFavoriteInner> updateAsync(String resourceGroupName, String resourceName, String favoriteId, ApplicationInsightsComponentFavoriteInner favoriteProperties, ServiceCallback<ApplicationInsightsComponentFavoriteInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, resourceName, favoriteId, favoriteProperties), serviceCallback);
    }

    public Observable<ApplicationInsightsComponentFavoriteInner> updateAsync(String resourceGroupName, String resourceName, String favoriteId, ApplicationInsightsComponentFavoriteInner favoriteProperties) {
        return this.updateWithServiceResponseAsync(resourceGroupName, resourceName, favoriteId, favoriteProperties).map((Func1)new Func1<ServiceResponse<ApplicationInsightsComponentFavoriteInner>, ApplicationInsightsComponentFavoriteInner>(){

            public ApplicationInsightsComponentFavoriteInner call(ServiceResponse<ApplicationInsightsComponentFavoriteInner> response) {
                return (ApplicationInsightsComponentFavoriteInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ApplicationInsightsComponentFavoriteInner>> updateWithServiceResponseAsync(String resourceGroupName, String resourceName, String favoriteId, ApplicationInsightsComponentFavoriteInner favoriteProperties) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (favoriteId == null) {
            throw new IllegalArgumentException("Parameter favoriteId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (favoriteProperties == null) {
            throw new IllegalArgumentException("Parameter favoriteProperties is required and cannot be null.");
        }
        Validator.validate((Object)favoriteProperties);
        return this.service.update(resourceGroupName, this.client.subscriptionId(), resourceName, favoriteId, this.client.apiVersion(), favoriteProperties, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationInsightsComponentFavoriteInner>>>(){

            public Observable<ServiceResponse<ApplicationInsightsComponentFavoriteInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FavoritesInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ApplicationInsightsComponentFavoriteInner> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ApplicationInsightsComponentFavoriteInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String resourceName, String favoriteId) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, resourceName, favoriteId).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String resourceName, String favoriteId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, resourceName, favoriteId), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String resourceName, String favoriteId) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, resourceName, favoriteId).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String resourceName, String favoriteId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (favoriteId == null) {
            throw new IllegalArgumentException("Parameter favoriteId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(resourceGroupName, this.client.subscriptionId(), resourceName, favoriteId, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FavoritesInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface FavoritesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.Favorites list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/favorites")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Query(value="favoriteType") FavoriteType var5, @Query(value="sourceType") FavoriteSourceType var6, @Query(value="canFetchContent") Boolean var7, @Query(value="tags") String var8, @Header(value="accept-language") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.Favorites get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/favorites/{favoriteId}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Path(value="resourceName") String var3, @Path(value="favoriteId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.Favorites add"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/favorites/{favoriteId}")
        public Observable<Response<ResponseBody>> add(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Path(value="resourceName") String var3, @Path(value="favoriteId") String var4, @Query(value="api-version") String var5, @Body ApplicationInsightsComponentFavoriteInner var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.Favorites update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/favorites/{favoriteId}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Path(value="resourceName") String var3, @Path(value="favoriteId") String var4, @Query(value="api-version") String var5, @Body ApplicationInsightsComponentFavoriteInner var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.applicationinsights.v2015_05_01.Favorites delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/components/{resourceName}/favorites/{favoriteId}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Path(value="resourceName") String var3, @Path(value="favoriteId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);
    }
}

